/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonQueue;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;

public class RedissonBlockingQueue<V>
extends RedissonQueue<V>
implements RBlockingQueue<V> {
    protected RedissonBlockingQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    protected RedissonBlockingQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        return this.addAsync(e, RedisCommands.RPUSH_VOID);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.get(this.putAsync(e));
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), 0);
    }

    @Override
    public V take() throws InterruptedException {
        RFuture<V> res = this.takeAsync();
        return res.await().getNow();
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), this.toSeconds(timeout, unit));
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        RFuture<V> res = this.pollAsync(timeout, unit);
        return res.await().getNow();
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        RFuture<V> res = this.pollFromAnyAsync(timeout, unit, queueNames);
        return res.await().getNow();
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>(queueNames.length + 1);
        params.add(this.getName());
        for (String name : queueNames) {
            params.add(name);
        }
        params.add(this.toSeconds(timeout, unit));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, params.toArray());
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BRPOPLPUSH, this.getName(), queueName, this.toSeconds(timeout, unit));
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        RFuture<V> res = this.pollLastAndOfferFirstToAsync(queueName, timeout, unit);
        return res.await().getNow();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('ltrim', KEYS[1], -1, 0); return vals", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); return vals", Collections.singletonList(this.getName()), maxElements);
    }
}

