/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.RedissonKeys;
import org.redisson.api.RType;
import org.redisson.api.options.KeysScanOptions;
import org.redisson.api.options.KeysScanParams;
import org.redisson.client.RedisClient;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.rx.CommandRxExecutor;

public class RedissonKeysRx {
    private final CommandRxExecutor commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysRx(CommandRxExecutor commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public Flowable<String> getKeys() {
        return this.getKeysByPattern(null);
    }

    public Flowable<String> getKeys(KeysScanOptions options) {
        KeysScanParams params = (KeysScanParams)options;
        ArrayList<Publisher<String>> publishers = new ArrayList<Publisher<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, params.getPattern(), params.getChunkSize(), params.getType()));
        }
        return Flowable.merge(publishers);
    }

    public Flowable<String> getKeys(int count) {
        return this.getKeys(KeysScanOptions.defaults().chunkSize(count));
    }

    public Flowable<String> getKeysByPattern(String pattern) {
        return this.getKeys(KeysScanOptions.defaults().pattern(pattern));
    }

    public Flowable<String> getKeysByPattern(String pattern, int count) {
        return this.getKeys(KeysScanOptions.defaults().pattern(pattern).chunkSize(count));
    }

    private Publisher<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count, final RType type) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private RedisClient client;
            private List<String> firstValues;
            private String nextIterPos = "0";
            private long currentIndex;

            @Override
            public void accept(long value) {
                this.currentIndex = value;
                this.nextValues();
            }

            private void nextValues() {
                RedissonKeysRx.this.instance.scanIteratorAsync(this.client, entry, this.nextIterPos, pattern, count, type).whenComplete((res, e) -> {
                    if (e != null) {
                        p.onError((Throwable)e);
                        return;
                    }
                    this.client = res.getRedisClient();
                    String prevIterPos = this.nextIterPos;
                    if ("0".equals(this.nextIterPos) && this.firstValues == null) {
                        this.firstValues = (List)res.getValues();
                    } else if (res.getValues().equals(this.firstValues)) {
                        p.onComplete();
                        this.currentIndex = 0L;
                        return;
                    }
                    this.nextIterPos = res.getPos();
                    if (prevIterPos.equals(this.nextIterPos)) {
                        this.nextIterPos = "-1";
                    }
                    for (Object val : res.getValues()) {
                        p.onNext((String)val);
                        --this.currentIndex;
                        if (this.currentIndex != 0L) continue;
                        p.onComplete();
                        return;
                    }
                    if ("-1".equals(this.nextIterPos)) {
                        p.onComplete();
                        this.currentIndex = 0L;
                    }
                    if (this.currentIndex == 0L) {
                        return;
                    }
                    this.nextValues();
                });
            }
        });
    }
}

