/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RIdGenerator;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonIdGenerator
extends RedissonExpirable
implements RIdGenerator {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private String allocationSizeName;
    private final AtomicLong start = new AtomicLong();
    private final AtomicLong counter = new AtomicLong();
    private final Queue<CompletableFuture<Long>> queue = new ConcurrentLinkedQueue<CompletableFuture<Long>>();
    private final AtomicBoolean isWorkerActive = new AtomicBoolean();

    RedissonIdGenerator(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
        this.allocationSizeName = this.getAllocationSizeName(this.getRawName());
    }

    private String getAllocationSizeName(String name) {
        return RedissonIdGenerator.suffixName(name, "allocation");
    }

    @Override
    public boolean tryInit(long value, long allocationSize) {
        return this.get(this.tryInitAsync(value, allocationSize));
    }

    @Override
    public long nextId() {
        return this.get(this.nextIdAsync());
    }

    @Override
    public RFuture<Boolean> tryInitAsync(long value, long allocationSize) {
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('setnx', KEYS[1], ARGV[1]); return redis.call('setnx', KEYS[2], ARGV[2]); ", Arrays.asList(this.getRawName(), this.allocationSizeName), value, allocationSize);
    }

    private void startIdRequestsHandle() {
        if (!this.isWorkerActive.compareAndSet(false, true)) {
            return;
        }
        this.handleIdRequests();
    }

    private void handleIdRequests() {
        if (this.getServiceManager().isShuttingDown()) {
            return;
        }
        if (this.queue.peek() == null) {
            this.isWorkerActive.set(false);
            if (!this.queue.isEmpty()) {
                this.startIdRequestsHandle();
            }
            return;
        }
        long v = this.counter.decrementAndGet();
        if (v >= 0L) {
            CompletableFuture<Long> pp = this.queue.poll();
            if (pp != null) {
                pp.complete(this.start.incrementAndGet());
                this.handleIdRequests();
            } else {
                this.counter.incrementAndGet();
                this.isWorkerActive.set(false);
                if (!this.queue.isEmpty()) {
                    this.startIdRequestsHandle();
                }
            }
        } else {
            RFuture future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local allocationSize = redis.call('get', KEYS[2]); if allocationSize == false then allocationSize = 5000; redis.call('set', KEYS[2], allocationSize);end;local value = redis.call('get', KEYS[1]); if value == false then redis.call('incr', KEYS[1]);value = 1; end; redis.call('incrby', KEYS[1], allocationSize); return {value, allocationSize}; ", Arrays.asList(this.getRawName(), this.allocationSizeName), new Object[0]);
            future.whenComplete((res, ex) -> {
                if (ex != null) {
                    if (this.getServiceManager().isShuttingDown((Throwable)ex)) {
                        return;
                    }
                    this.log.error(ex.getMessage(), (Throwable)ex);
                    this.commandExecutor.getServiceManager().newTimeout(task -> this.handleIdRequests(), 1L, TimeUnit.SECONDS);
                    return;
                }
                long value = (Long)res.get(0);
                long allocationSize = (Long)res.get(1);
                this.start.set(value);
                this.counter.set(allocationSize);
                CompletableFuture<Long> pp = this.queue.poll();
                if (pp != null) {
                    this.counter.decrementAndGet();
                    pp.complete(this.start.get());
                }
                this.handleIdRequests();
            });
        }
    }

    @Override
    public RFuture<Long> nextIdAsync() {
        CompletableFuture promise = new CompletableFuture();
        this.queue.add(promise);
        this.startIdRequestsHandle();
        return new CompletableFutureWrapper<Long>(promise);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.allocationSizeName);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return super.sizeInMemoryAsync(Arrays.asList(this.getRawName(), this.allocationSizeName));
    }

    @Override
    public RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        String newName = (String)keys.get(1);
        List<Object> kks = Arrays.asList(this.getRawName(), this.allocationSizeName, newName, this.getAllocationSizeName(newName));
        return super.copyAsync(kks, database, replace);
    }

    @Override
    public RFuture<Void> renameAsync(String nn) {
        String newName = this.mapName(nn);
        List<Object> kks = Arrays.asList(this.getRawName(), this.allocationSizeName, newName, this.getAllocationSizeName(newName));
        return this.renameAsync(this.commandExecutor, kks, () -> {
            this.setName(nn);
            this.allocationSizeName = this.getAllocationSizeName(newName);
        });
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String nn) {
        String newName = this.mapName(nn);
        List<Object> kks = Arrays.asList(this.getRawName(), this.allocationSizeName, newName, this.getAllocationSizeName(newName));
        return this.renamenxAsync(this.commandExecutor, kks, value -> {
            if (value.booleanValue()) {
                this.setName(nn);
                this.allocationSizeName = this.getAllocationSizeName(newName);
            }
        });
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.allocationSizeName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.allocationSizeName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.allocationSizeName);
    }
}

