/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class IOUtil {
    public static int ioBufferSize = 16384;
    private static final int ZERO = 0;
    private static final int NEGATIVE_ONE = -1;
    private static final int ALL = -1;

    public static void close(Closeable closeable) {
        if (closeable != null) {
            if (closeable instanceof Flushable) {
                try {
                    ((Flushable)((Object)closeable)).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int copy(Reader input, Writer output) throws IOException {
        int read;
        int numToRead = IOUtil.bufferSize();
        char[] buffer = new char[numToRead];
        int totalRead = 0;
        while ((read = input.read(buffer, 0, numToRead)) >= 0) {
            output.write(buffer, 0, read);
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        int read;
        int numToRead = IOUtil.bufferSize();
        byte[] buffer = new byte[numToRead];
        int totalRead = 0;
        while ((read = input.read(buffer, 0, numToRead)) >= 0) {
            output.write(buffer, 0, read);
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static int copy(Reader input, Writer output, int count) throws IOException {
        int read;
        if (count == -1) {
            return IOUtil.copy(input, output);
        }
        int numToRead = count;
        char[] buffer = new char[numToRead];
        int totalRead = 0;
        while (numToRead > 0 && (read = input.read(buffer, 0, IOUtil.bufferSize(numToRead))) != -1) {
            output.write(buffer, 0, read);
            numToRead -= read;
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static int copy(InputStream input, OutputStream output, int count) throws IOException {
        int read;
        if (count == -1) {
            return IOUtil.copy(input, output);
        }
        int numToRead = count;
        byte[] buffer = new byte[numToRead];
        int totalRead = 0;
        while (numToRead > 0 && (read = input.read(buffer, 0, IOUtil.bufferSize(numToRead))) != -1) {
            output.write(buffer, 0, read);
            numToRead -= read;
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static byte[] readAvailableBytes(InputStream input) throws IOException {
        int totalRead;
        int read;
        int numToRead = input.available();
        byte[] buffer = new byte[numToRead];
        for (totalRead = 0; totalRead < numToRead && (read = input.read(buffer, totalRead, numToRead - totalRead)) >= 0; totalRead += read) {
        }
        if (totalRead < numToRead) {
            throw new IOException("Failed to completely read InputStream");
        }
        return buffer;
    }

    public static <T extends OutputStream> T copy(Reader input, T output) throws IOException {
        return IOUtil.copy(input, output, IOUtil.encoding());
    }

    public static <T extends OutputStream> T copy(Reader input, T output, int count) throws IOException {
        return IOUtil.copy(input, output, IOUtil.encoding(), count);
    }

    public static <T extends OutputStream> T copy(Reader input, T output, Charset encoding) throws IOException {
        return IOUtil.copy(input, output, encoding, -1);
    }

    public static <T extends OutputStream> T copy(Reader input, T output, Charset encoding, int count) throws IOException {
        try (OutputStreamWriter out = IOUtil.outputStreamWriterOf(output, encoding);){
            IOUtil.copy(input, out, count);
            T t = output;
            return t;
        }
    }

    public static ByteArrayOutputStream copyToOutputStream(InputStream input) throws IOException {
        return IOUtil.copyToOutputStream(input, -1);
    }

    public static ByteArrayOutputStream copyToOutputStream(InputStream input, int count) throws IOException {
        try (ByteArrayOutputStream output = IOUtil.createFastByteArrayOutputStream();){
            IOUtil.copy(input, output, count);
            ByteArrayOutputStream byteArrayOutputStream = output;
            return byteArrayOutputStream;
        }
    }

    public static ByteArrayOutputStream copyToOutputStream(Reader input) throws IOException {
        return IOUtil.copyToOutputStream(input, IOUtil.encoding());
    }

    public static ByteArrayOutputStream copyToOutputStream(Reader input, Charset encoding) throws IOException {
        return IOUtil.copyToOutputStream(input, encoding, -1);
    }

    public static ByteArrayOutputStream copyToOutputStream(Reader input, int count) throws IOException {
        return IOUtil.copyToOutputStream(input, IOUtil.encoding(), count);
    }

    public static ByteArrayOutputStream copyToOutputStream(Reader input, Charset encoding, int count) throws IOException {
        try (ByteArrayOutputStream output = IOUtil.createFastByteArrayOutputStream();){
            IOUtil.copy(input, output, encoding, count);
            ByteArrayOutputStream byteArrayOutputStream = output;
            return byteArrayOutputStream;
        }
    }

    public static <T extends Writer> T copy(InputStream input, T output) throws IOException {
        return IOUtil.copy(input, output, IOUtil.encoding());
    }

    public static <T extends Writer> T copy(InputStream input, T output, int count) throws IOException {
        return IOUtil.copy(input, output, IOUtil.encoding(), count);
    }

    public static <T extends Writer> T copy(InputStream input, T output, Charset encoding) throws IOException {
        return IOUtil.copy(input, output, encoding, -1);
    }

    public static <T extends Writer> T copy(InputStream input, T output, Charset encoding, int count) throws IOException {
        IOUtil.copy((Reader)IOUtil.inputStreamReadeOf(input, encoding), output, count);
        return output;
    }

    public static CharArrayWriter copy(InputStream input) throws IOException {
        return IOUtil.copy(input, IOUtil.encoding());
    }

    public static CharArrayWriter copy(InputStream input, int count) throws IOException {
        return IOUtil.copy(input, IOUtil.encoding(), count);
    }

    public static CharArrayWriter copy(InputStream input, Charset encoding) throws IOException {
        return IOUtil.copy(input, encoding, -1);
    }

    public static CharArrayWriter copy(InputStream input, Charset encoding, int count) throws IOException {
        try (CharArrayWriter output = IOUtil.createFastCharArrayWriter();){
            IOUtil.copy(input, output, encoding, count);
            CharArrayWriter charArrayWriter = output;
            return charArrayWriter;
        }
    }

    public static CharArrayWriter copy(Reader input) throws IOException {
        return IOUtil.copy(input, -1);
    }

    public static CharArrayWriter copy(Reader input, int count) throws IOException {
        try (CharArrayWriter output = IOUtil.createFastCharArrayWriter();){
            IOUtil.copy(input, output, count);
            CharArrayWriter charArrayWriter = output;
            return charArrayWriter;
        }
    }

    public static byte[] readBytes(InputStream input) throws IOException {
        return IOUtil.readBytes(input, -1);
    }

    public static byte[] readBytes(InputStream input, int count) throws IOException {
        return IOUtil.copyToOutputStream(input, count).toByteArray();
    }

    public static byte[] readBytes(Reader input) throws IOException {
        return IOUtil.readBytes(input, IOUtil.encoding());
    }

    public static byte[] readBytes(Reader input, int count) throws IOException {
        return IOUtil.readBytes(input, IOUtil.encoding(), count);
    }

    public static byte[] readBytes(Reader input, Charset encoding) throws IOException {
        return IOUtil.readBytes(input, encoding, -1);
    }

    public static byte[] readBytes(Reader input, Charset encoding, int count) throws IOException {
        return IOUtil.copyToOutputStream(input, encoding, count).toByteArray();
    }

    public static char[] readChars(Reader input) throws IOException {
        return IOUtil.readChars(input, -1);
    }

    public static char[] readChars(Reader input, int count) throws IOException {
        return IOUtil.copy(input, count).toCharArray();
    }

    public static char[] readChars(InputStream input) throws IOException {
        return IOUtil.readChars(input, -1);
    }

    public static char[] readChars(InputStream input, Charset encoding) throws IOException {
        return IOUtil.readChars(input, encoding, -1);
    }

    public static char[] readChars(InputStream input, int count) throws IOException {
        return IOUtil.readChars(input, IOUtil.encoding(), count);
    }

    public static char[] readChars(InputStream input, Charset encoding, int count) throws IOException {
        return IOUtil.copy(input, encoding, count).toCharArray();
    }

    public static boolean compare(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean compare(Reader input1, Reader input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedReader)) {
            input1 = new BufferedReader(input1);
        }
        if (!(input2 instanceof BufferedReader)) {
            input2 = new BufferedReader(input2);
        }
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    private static int bufferSize() {
        return ioBufferSize;
    }

    private static int bufferSize(int count) {
        int ioBufferSize = IOUtil.ioBufferSize;
        return Math.min(count, ioBufferSize);
    }

    private static Charset encoding() {
        return StandardCharsets.UTF_8;
    }

    private static CharArrayWriter createFastCharArrayWriter() {
        return new CharArrayWriter(IOUtil.bufferSize());
    }

    private static ByteArrayOutputStream createFastByteArrayOutputStream() {
        return new ByteArrayOutputStream(IOUtil.bufferSize());
    }

    public static InputStreamReader inputStreamReadeOf(InputStream input) {
        return IOUtil.inputStreamReadeOf(input, IOUtil.encoding());
    }

    public static InputStreamReader inputStreamReadeOf(InputStream input, Charset encoding) {
        return new InputStreamReader(input, encoding);
    }

    public static OutputStreamWriter outputStreamWriterOf(OutputStream output) {
        return IOUtil.outputStreamWriterOf(output, IOUtil.encoding());
    }

    public static OutputStreamWriter outputStreamWriterOf(OutputStream output, Charset encoding) {
        return new OutputStreamWriter(output, encoding);
    }
}

