/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.BaseTransactionalMap;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.map.MapCacheFastPutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapCacheFastPutOperation;
import org.redisson.transaction.operation.map.MapCachePutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapCachePutOperation;

public class BaseTransactionalMapCache<K, V>
extends BaseTransactionalMap<K, V> {
    public BaseTransactionalMapCache(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RMap<K, V> map, String transactionId) {
        super(commandExecutor, timeout, operations, map, transactionId);
    }

    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        long threadId = Thread.currentThread().getId();
        return this.putIfAbsentOperationAsync(key, value, new MapCachePutIfAbsentOperation(this.map, key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit, this.transactionId, threadId));
    }

    public RFuture<Boolean> fastPutOperationAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        long threadId = Thread.currentThread().getId();
        return this.fastPutOperationAsync(key, value, new MapCacheFastPutOperation(this.map, key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit, this.transactionId, threadId));
    }

    public RFuture<V> putOperationAsync(K key, V value, long ttlTimeout, long maxIdleTimeout, long maxIdleDelta, long ttlTimeoutDelta) {
        long threadId = Thread.currentThread().getId();
        return this.putOperationAsync(key, value, new MapCachePutOperation(this.map, key, value, ttlTimeoutDelta, TimeUnit.MILLISECONDS, maxIdleDelta, TimeUnit.MILLISECONDS, this.transactionId, threadId));
    }

    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        long threadId = Thread.currentThread().getId();
        return this.fastPutIfAbsentOperationAsync(key, value, new MapCacheFastPutIfAbsentOperation(this.map, key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit, this.transactionId, threadId));
    }
}

