/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.map;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.redisson.api.MapOptions;
import org.redisson.api.map.MapWriterAsync;
import org.redisson.connection.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableMapWriterAsync<K, V>
implements MapWriterAsync<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RetryableMapWriterAsync.class);
    private final MapOptions<K, V> options;
    private final MapWriterAsync<K, V> mapWriterAsync;
    private ServiceManager serviceManager;

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public RetryableMapWriterAsync(MapOptions<K, V> options, MapWriterAsync<K, V> mapWriterAsync) {
        this.options = options;
        this.mapWriterAsync = mapWriterAsync;
    }

    @Override
    public CompletionStage<Void> write(Map<K, V> addedMap) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.retryWrite(Math.max(1, this.options.getWriterRetryAttempts()), addedMap, result);
        return result;
    }

    private void retryWrite(int leftAttempts, Map<K, V> addedMap, CompletableFuture<Void> result) {
        this.mapWriterAsync.write(addedMap).whenComplete((x, e) -> {
            if (e == null) {
                result.complete(null);
                return;
            }
            if (leftAttempts - 1 <= 0) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (this.serviceManager == null) {
                log.warn("The serviceManager is null, so cannot retry writing keys: {}", (Object)addedMap);
                result.completeExceptionally((Throwable)e);
                return;
            }
            log.warn("Unable to add keys: {}, will retry after {}ms", addedMap, this.options.getWriterRetryInterval(), e);
            this.serviceManager.newTimeout(t -> this.retryWrite(leftAttempts - 1, addedMap, result), this.options.getWriterRetryInterval(), TimeUnit.MILLISECONDS);
        });
    }

    @Override
    public CompletionStage<Void> delete(Collection<K> keys) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.retryDelete(Math.max(1, this.options.getWriterRetryAttempts()), keys, result);
        return result;
    }

    private void retryDelete(int leftAttempts, Collection<K> keys, CompletableFuture<Void> result) {
        this.mapWriterAsync.delete(keys).whenComplete((x, e) -> {
            if (e == null) {
                result.complete(null);
                return;
            }
            if (leftAttempts - 1 <= 0) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (this.serviceManager == null) {
                log.warn("The serviceManager is null so cannot retry deleting keys: {}", (Object)keys);
                result.completeExceptionally((Throwable)e);
                return;
            }
            log.warn("Unable to delete keys: {}, will retry after {}ms", keys, this.options.getWriterRetryInterval(), e);
            this.serviceManager.newTimeout(t -> this.retryDelete(leftAttempts - 1, keys, result), this.options.getWriterRetryInterval(), TimeUnit.MILLISECONDS);
        });
    }
}

