/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RTimeSeries;
import org.redisson.api.TimeSeriesEntry;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.TimeSeriesEntryReplayDecoder;
import org.redisson.client.protocol.decoder.TimeSeriesFirstEntryReplayDecoder;
import org.redisson.client.protocol.decoder.TimeSeriesSingleEntryReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonTimeSeries<V, L>
extends RedissonExpirable
implements RTimeSeries<V, L> {
    private final EvictionScheduler evictionScheduler;
    private String timeoutSetName;
    private static final RedisCommand<Object> EVAL_FIRST_ENTRY = new RedisCommand<Object>("EVAL", new TimeSeriesFirstEntryReplayDecoder(){});
    private static final RedisCommand<List<TimeSeriesEntry<Object, Object>>> EVAL_ENTRIES = new RedisCommand<List<TimeSeriesEntry<Object, Object>>>("EVAL", new TimeSeriesEntryReplayDecoder());
    private static final RedisCommand<List<TimeSeriesEntry<Object, Object>>> EVAL_ENTRIES_REVERSE = new RedisCommand<List<TimeSeriesEntry<Object, Object>>>("EVAL", new TimeSeriesEntryReplayDecoder(true));
    private static final RedisCommand<TimeSeriesEntry<Object, Object>> EVAL_ENTRY = new RedisCommand<TimeSeriesEntry<Object, Object>>("EVAL", new TimeSeriesSingleEntryReplayDecoder());

    public RedissonTimeSeries(EvictionScheduler evictionScheduler, CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
        this.evictionScheduler = evictionScheduler;
        this.timeoutSetName = this.getTimeoutSetName(this.getRawName());
        if (evictionScheduler != null) {
            evictionScheduler.scheduleTimeSeries(this.getRawName(), this.timeoutSetName);
        }
    }

    public RedissonTimeSeries(Codec codec, EvictionScheduler evictionScheduler, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
        this.evictionScheduler = evictionScheduler;
        this.timeoutSetName = this.getTimeoutSetName(this.getRawName());
        if (evictionScheduler != null) {
            evictionScheduler.scheduleTimeSeries(this.getRawName(), this.timeoutSetName);
        }
    }

    String getTimeoutSetName(String name) {
        return RedissonTimeSeries.prefixName("redisson__ts_ttl", name);
    }

    @Override
    public void add(long timestamp, V value) {
        this.addAll(Collections.singletonMap(timestamp, value));
    }

    @Override
    public RFuture<Void> addAsync(long timestamp, V object) {
        return this.addAllAsync(Collections.singletonMap(timestamp, object));
    }

    @Override
    public void add(long timestamp, V object, L label) {
        this.addAll(Collections.singletonList(new TimeSeriesEntry<V, L>(timestamp, object, label)));
    }

    @Override
    public RFuture<Void> addAsync(long timestamp, V object, L label) {
        return this.addAllAsync(Collections.singletonList(new TimeSeriesEntry<V, L>(timestamp, object, label)));
    }

    @Override
    public void addAll(Map<Long, V> objects) {
        this.addAll(objects, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void add(long timestamp, V value, long timeToLive, TimeUnit timeUnit) {
        this.addAll(Collections.singletonMap(timestamp, value), timeToLive, timeUnit);
    }

    @Override
    public RFuture<Void> addAsync(long timestamp, V object, long timeToLive, TimeUnit timeUnit) {
        return this.addAllAsync(Collections.singletonMap(timestamp, object), timeToLive, timeUnit);
    }

    @Override
    public void add(long timestamp, V object, Duration timeToLive) {
        this.get(this.addAsync(timestamp, object, timeToLive));
    }

    @Override
    public RFuture<Void> addAsync(long timestamp, V object, Duration timeToLive) {
        return this.addAllAsync(Collections.singletonMap(timestamp, object), timeToLive);
    }

    @Override
    public void add(long timestamp, V object, L label, Duration timeToLive) {
        this.addAll(Collections.singletonList(new TimeSeriesEntry<V, L>(timestamp, object, label)), timeToLive);
    }

    @Override
    public RFuture<Void> addAsync(long timestamp, V object, L label, Duration timeToLive) {
        return this.addAllAsync(Collections.singletonList(new TimeSeriesEntry<V, L>(timestamp, object, label)), timeToLive);
    }

    @Override
    public void addAll(Map<Long, V> objects, long timeToLive, TimeUnit timeUnit) {
        this.get(this.addAllAsync(objects, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> addAllAsync(Map<Long, V> objects) {
        return this.addAllAsync(objects, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<Void> addAllAsync(Map<Long, V> objects, long timeToLive, TimeUnit timeUnit) {
        return this.addAllAsync(objects, Duration.ofMillis(timeUnit.toMillis(timeToLive)));
    }

    @Override
    public void addAll(Map<Long, V> objects, Duration timeToLive) {
        this.get(this.addAllAsync(objects, timeToLive));
    }

    @Override
    public RFuture<Void> addAllAsync(Map<Long, V> objects, Duration timeToLive) {
        long expirationTime = System.currentTimeMillis();
        expirationTime = timeToLive != null && !timeToLive.isZero() ? (expirationTime += timeToLive.toMillis()) : (expirationTime += TimeUnit.DAYS.toMillis(36500L));
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(expirationTime);
        for (Map.Entry<Long, V> entry : objects.entrySet()) {
            params.add(entry.getKey());
            byte[] random = this.getServiceManager().generateIdArray();
            params.add(random);
            this.encode(params, entry.getValue());
        }
        if (timeToLive != null && !timeToLive.isZero()) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "for i = 2, #ARGV, 3 do local val = struct.pack('BBc0Lc0Lc0', 2, string.len(ARGV[i+1]), ARGV[i+1], string.len(ARGV[i+2]), ARGV[i+2], 0, ''); redis.call('zadd', KEYS[1], ARGV[i], val); redis.call('zadd', KEYS[2], ARGV[1], val); end; ", Arrays.asList(this.getRawName(), this.timeoutSetName), params.toArray());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "local expirationTime = ARGV[1]; local lastValues = redis.call('zrange', KEYS[2], -1, -1, 'withscores'); if (#lastValues > 0 and tonumber(lastValues[2]) > tonumber(ARGV[1])) then expirationTime = tonumber(lastValues[2]); end; for i = 2, #ARGV, 3 do local val = struct.pack('BBc0Lc0Lc0', 2, string.len(ARGV[i+1]), ARGV[i+1], string.len(ARGV[i+2]), ARGV[i+2], 0, ''); redis.call('zadd', KEYS[1], ARGV[i], val); redis.call('zadd', KEYS[2], expirationTime + 1, val); end; ", Arrays.asList(this.getRawName(), this.timeoutSetName), params.toArray());
    }

    @Override
    public void addAll(Collection<TimeSeriesEntry<V, L>> entries) {
        this.addAll(entries, null);
    }

    @Override
    public RFuture<Void> addAllAsync(Collection<TimeSeriesEntry<V, L>> entries) {
        return this.addAllAsync(entries, null);
    }

    @Override
    public void addAll(Collection<TimeSeriesEntry<V, L>> entries, Duration timeToLive) {
        this.get(this.addAllAsync(entries, timeToLive));
    }

    @Override
    public RFuture<Void> addAllAsync(Collection<TimeSeriesEntry<V, L>> entries, Duration timeToLive) {
        long expirationTime = System.currentTimeMillis();
        expirationTime = timeToLive != null ? (expirationTime += timeToLive.toMillis()) : (expirationTime += TimeUnit.DAYS.toMillis(36500L));
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(expirationTime);
        for (TimeSeriesEntry<V, L> entry : entries) {
            params.add(entry.getTimestamp());
            byte[] random = this.getServiceManager().generateIdArray();
            if (entry.getLabel() == null) {
                params.add(2);
            } else {
                params.add(3);
            }
            params.add(random);
            this.encode(params, entry.getValue());
            if (entry.getLabel() == null) {
                params.add("");
                continue;
            }
            this.encode(params, entry.getLabel());
        }
        if (timeToLive != null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "for i = 2, #ARGV, 5 do local val = struct.pack('BBc0Lc0Lc0', ARGV[i+1], string.len(ARGV[i+2]), ARGV[i+2], string.len(ARGV[i+3]), ARGV[i+3], string.len(ARGV[i+4]), ARGV[i+4]); redis.call('zadd', KEYS[1], ARGV[i], val); redis.call('zadd', KEYS[2], ARGV[1], val); end; ", Arrays.asList(this.getRawName(), this.timeoutSetName), params.toArray());
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "local expirationTime = ARGV[1]; local lastValues = redis.call('zrange', KEYS[2], -1, -1, 'withscores'); if (#lastValues > 0 and tonumber(lastValues[2]) > tonumber(ARGV[1])) then expirationTime = tonumber(lastValues[2]); end; for i = 2, #ARGV, 5 do local val = struct.pack('BBc0Lc0Lc0', ARGV[i+1],string.len(ARGV[i+2]), ARGV[i+2], string.len(ARGV[i+3]), ARGV[i+3], string.len(ARGV[i+4]), ARGV[i+4]); redis.call('zadd', KEYS[1], ARGV[i], val); redis.call('zadd', KEYS[2], expirationTime + 1, val); end; ", Arrays.asList(this.getRawName(), this.timeoutSetName), params.toArray());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local values = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1]);return redis.call('zcard', KEYS[1]) - #values;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis());
    }

    @Override
    public V get(long timestamp) {
        return this.get(this.getAsync(timestamp));
    }

    @Override
    public RFuture<V> getAsync(long timestamp) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[2]);if #values == 0 then return nil;end;local expirationDate = redis.call('zscore', KEYS[2], values[1]); if expirationDate ~= false and tonumber(expirationDate) <= tonumber(ARGV[1]) then return nil;end;local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[1]); return val;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), timestamp);
    }

    @Override
    public TimeSeriesEntry<V, L> getEntry(long timestamp) {
        return this.get(this.getEntryAsync(timestamp));
    }

    @Override
    public RFuture<TimeSeriesEntry<V, L>> getEntryAsync(long timestamp) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, EVAL_ENTRY, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[2]);if #values == 0 then return nil;end;local expirationDate = redis.call('zscore', KEYS[2], values[1]); if expirationDate ~= false and tonumber(expirationDate) <= tonumber(ARGV[1]) then return nil;end;local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[1]); if n == 2 then return {n, ARGV[2], val};end;return {n, ARGV[2], val, label};", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), timestamp);
    }

    @Override
    public boolean remove(long timestamp) {
        return this.get(this.removeAsync(timestamp));
    }

    @Override
    public RFuture<Boolean> removeAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[2]);if #values == 0 then return 0;end;local expirationDate = redis.call('zscore', KEYS[2], values[1]); if expirationDate ~= false and tonumber(expirationDate) <= tonumber(ARGV[1]) then return 0;end;redis.call('zrem', KEYS[2], values[1]); redis.call('zrem', KEYS[1], values[1]); return 1;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), timestamp);
    }

    @Override
    public V getAndRemove(long timestamp) {
        return this.get(this.getAndRemoveAsync(timestamp));
    }

    @Override
    public RFuture<V> getAndRemoveAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[2]);if #values == 0 then return nil;end;local expirationDate = redis.call('zscore', KEYS[2], values[1]); if expirationDate ~= false and tonumber(expirationDate) <= tonumber(ARGV[1]) then return nil;end;redis.call('zrem', KEYS[2], values[1]); redis.call('zrem', KEYS[1], values[1]); local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[1]); return val;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), timestamp);
    }

    @Override
    public TimeSeriesEntry<V, L> getAndRemoveEntry(long timestamp) {
        return this.get(this.getAndRemoveEntryAsync(timestamp));
    }

    @Override
    public RFuture<TimeSeriesEntry<V, L>> getAndRemoveEntryAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, EVAL_ENTRY, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[2]);if #values == 0 then return nil;end;local expirationDate = redis.call('zscore', KEYS[2], values[1]); if expirationDate ~= false and tonumber(expirationDate) <= tonumber(ARGV[1]) then return nil;end;redis.call('zrem', KEYS[2], values[1]); redis.call('zrem', KEYS[1], values[1]); local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[1]); if n == 2 then return {n, ARGV[2], val};end;return {n, ARGV[2], val, label};", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), timestamp);
    }

    @Override
    public V last() {
        return this.get(this.lastAsync());
    }

    @Override
    public RFuture<V> lastAsync() {
        return this.listAsync(-1, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public TimeSeriesEntry<V, L> lastEntry() {
        return this.get(this.lastEntryAsync());
    }

    @Override
    public RFuture<TimeSeriesEntry<V, L>> lastEntryAsync() {
        return this.listEntriesAsync(-1, 1, EVAL_FIRST_ENTRY);
    }

    @Override
    public RFuture<Collection<V>> lastAsync(int count) {
        return this.listAsync(-1, count, RedisCommands.EVAL_LIST_REVERSE);
    }

    @Override
    public V first() {
        return this.get(this.firstAsync());
    }

    @Override
    public RFuture<V> firstAsync() {
        return this.listAsync(0, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public TimeSeriesEntry<V, L> firstEntry() {
        return this.get(this.firstEntryAsync());
    }

    @Override
    public RFuture<TimeSeriesEntry<V, L>> firstEntryAsync() {
        return this.listEntriesAsync(0, 1, EVAL_FIRST_ENTRY);
    }

    @Override
    public RFuture<Collection<V>> firstAsync(int count) {
        return this.listAsync(0, count, RedisCommands.EVAL_LIST);
    }

    @Override
    public Collection<V> first(int count) {
        return (Collection)this.get(this.listAsync(0, count, RedisCommands.EVAL_LIST));
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> firstEntries(int count) {
        return this.get(this.firstEntriesAsync(count));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> firstEntriesAsync(int count) {
        return this.listEntriesAsync(0, count, EVAL_ENTRIES);
    }

    @Override
    public Collection<V> last(int count) {
        return this.get(this.lastAsync(count));
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> lastEntries(int count) {
        return this.get(this.lastEntriesAsync(count));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> lastEntriesAsync(int count) {
        return this.listEntriesAsync(-2, count, EVAL_ENTRIES_REVERSE);
    }

    @Override
    public Long firstTimestamp() {
        return this.get(this.firstTimestampAsync());
    }

    @Override
    public RFuture<Long> firstTimestampAsync() {
        return this.listTimestampAsync(0, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public Long lastTimestamp() {
        return this.get(this.lastTimestampAsync());
    }

    @Override
    public RFuture<Long> lastTimestampAsync() {
        return this.listTimestampAsync(-1, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    private RFuture<Long> listTimestampAsync(int startScore, int limit, RedisCommand<?> evalCommandType) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, evalCommandType, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'limit', 0, ARGV[3]);end; local result = {}; for i, v in ipairs(values) do local t = redis.call('zscore', KEYS[1], v); table.insert(result, t);end;return result;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startScore, limit);
    }

    private <T> RFuture<T> listAsync(int startScore, int limit, RedisCommand<?> evalCommandType) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, evalCommandType, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'limit', 0, ARGV[3]);end; local result = {}; for i, v in ipairs(values) do local n, t, val, label = struct.unpack('BBc0Lc0Lc0', v); table.insert(result, val);end;return result;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startScore, limit);
    }

    private <T> RFuture<T> listEntriesAsync(int startScore, int limit, RedisCommand<?> evalCommandType) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, evalCommandType, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'withscores', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'withscores', 'limit', 0, ARGV[3]);end; local result = {}; for i=1, #values, 2 do local score = redis.call('zscore', KEYS[1], values[i]); local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[i]); table.insert(result, val);if n == 2 then label = 0; end; table.insert(result, label);table.insert(result, n);table.insert(result, score);end;return result;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startScore, limit);
    }

    @Override
    public int removeRange(long startTimestamp, long endTimestamp) {
        return this.get(this.removeRangeAsync(startTimestamp, endTimestamp));
    }

    @Override
    public RFuture<Integer> removeRangeAsync(long startTimestamp, long endTimestamp) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[2], ARGV[3]);local counter = 0; for i, v in ipairs(values) do local expirationDate = redis.call('zscore', KEYS[2], v); if tonumber(expirationDate) > tonumber(ARGV[1]) then counter = counter + 1; redis.call('zrem', KEYS[2], v); redis.call('zrem', KEYS[1], v); end;end;return counter;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startTimestamp, endTimestamp);
    }

    @Override
    public Collection<V> range(long startTimestamp, long endTimestamp, int limit) {
        return this.get(this.rangeAsync(startTimestamp, endTimestamp, limit));
    }

    @Override
    public Collection<V> range(long startTimestamp, long endTimestamp) {
        return this.get(this.rangeAsync(startTimestamp, endTimestamp));
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> entryRange(long startTimestamp, long endTimestamp) {
        return this.get(this.entryRangeAsync(false, startTimestamp, endTimestamp, 0));
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> entryRangeReversed(long startTimestamp, long endTimestamp) {
        return this.get(this.entryRangeAsync(true, startTimestamp, endTimestamp, 0));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> entryRangeReversedAsync(long startTimestamp, long endTimestamp) {
        return this.entryRangeAsync(true, startTimestamp, endTimestamp, 0);
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> entryRangeAsync(long startTimestamp, long endTimestamp) {
        return this.entryRangeAsync(false, startTimestamp, endTimestamp, 0);
    }

    private RFuture<Collection<TimeSeriesEntry<V, L>>> entryRangeAsync(boolean reverse, long startTimestamp, long endTimestamp, int limit) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, EVAL_ENTRIES, "local result = {}; local from = ARGV[2]; local to = ARGV[3]; local limit = tonumber(ARGV[4]); local cmd = 'zrangebyscore'; if ARGV[5] ~= '0' then from = ARGV[3]; to = ARGV[2]; cmd = 'zrevrangebyscore';end; while true do local values;if ARGV[4] ~= '0' then values = redis.call(cmd, KEYS[1], from, to, 'withscores', 'limit', 0, limit);else values = redis.call(cmd, KEYS[1], from, to, 'withscores');end; for i=1, #values, 2 do local expirationDate = redis.call('zscore', KEYS[2], values[i]);if tonumber(expirationDate) > tonumber(ARGV[1]) then local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[i]); table.insert(result, val);if n == 2 then label = 0; end; table.insert(result, label);table.insert(result, n);table.insert(result, values[i+1]);end;end;if limit == 0 or #result/4 == tonumber(ARGV[4]) or #values/2 < limit then return result;end;from = '(' .. values[#values];limit = tonumber(ARGV[4]) - #result/4;end;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startTimestamp, endTimestamp, limit, Boolean.compare(reverse, false), this.encode((Object)null));
    }

    @Override
    public Collection<V> rangeReversed(long startTimestamp, long endTimestamp, int limit) {
        return this.get(this.rangeReversedAsync(startTimestamp, endTimestamp, limit));
    }

    @Override
    public RFuture<Collection<V>> rangeAsync(long startTimestamp, long endTimestamp) {
        return this.rangeAsync(startTimestamp, endTimestamp, 0);
    }

    @Override
    public RFuture<Collection<V>> rangeAsync(long startTimestamp, long endTimestamp, int limit) {
        return this.rangeAsync(false, startTimestamp, endTimestamp, limit);
    }

    @Override
    public Collection<V> rangeReversed(long startTimestamp, long endTimestamp) {
        return this.get(this.rangeReversedAsync(startTimestamp, endTimestamp));
    }

    @Override
    public RFuture<Collection<V>> rangeReversedAsync(long startTimestamp, long endTimestamp) {
        return this.rangeReversedAsync(startTimestamp, endTimestamp, 0);
    }

    @Override
    public RFuture<Collection<V>> rangeReversedAsync(long startTimestamp, long endTimestamp, int limit) {
        return this.rangeAsync(true, startTimestamp, endTimestamp, limit);
    }

    private RFuture<Collection<V>> rangeAsync(boolean reverse, long startTimestamp, long endTimestamp, int limit) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "local result = {}; local from = ARGV[2]; local to = ARGV[3]; local limit = tonumber(ARGV[4]); local cmd = 'zrangebyscore'; if ARGV[5] ~= '0' then from = ARGV[3]; to = ARGV[2]; cmd = 'zrevrangebyscore';end; while true do local values;if ARGV[4] ~= '0' then values = redis.call(cmd, KEYS[1], from, to, 'withscores', 'limit', 0, limit);else values = redis.call(cmd, KEYS[1], from, to, 'withscores');end; for i=1, #values, 2 do local expirationDate = redis.call('zscore', KEYS[2], values[i]);if tonumber(expirationDate) > tonumber(ARGV[1]) then local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[i]); table.insert(result, val);end;end;if limit == 0 or #result == tonumber(ARGV[4]) or #values/2 < tonumber(limit) then return result;end;from = '(' .. values[#values];limit = tonumber(ARGV[4]) - #result;end;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startTimestamp, endTimestamp, limit, Boolean.compare(reverse, false));
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> entryRange(long startTimestamp, long endTimestamp, int limit) {
        return this.get(this.entryRangeAsync(startTimestamp, endTimestamp, limit));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> entryRangeAsync(long startTimestamp, long endTimestamp, int limit) {
        return this.entryRangeAsync(false, startTimestamp, endTimestamp, limit);
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> entryRangeReversed(long startTimestamp, long endTimestamp, int limit) {
        return this.get(this.entryRangeReversedAsync(startTimestamp, endTimestamp, limit));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> entryRangeReversedAsync(long startTimestamp, long endTimestamp, int limit) {
        return this.entryRangeAsync(true, startTimestamp, endTimestamp, limit);
    }

    @Override
    public Collection<V> pollFirst(int count) {
        return this.get(this.pollFirstAsync(count));
    }

    @Override
    public Collection<V> pollLast(int count) {
        return this.get(this.pollLastAsync(count));
    }

    @Override
    public RFuture<Collection<V>> pollFirstAsync(int count) {
        if (count <= 0) {
            return new CompletableFutureWrapper<Collection<V>>(Collections.emptyList());
        }
        return this.pollAsync(0, count, RedisCommands.EVAL_LIST);
    }

    @Override
    public RFuture<Collection<V>> pollLastAsync(int count) {
        if (count <= 0) {
            return new CompletableFutureWrapper<Collection<V>>(Collections.emptyList());
        }
        return this.pollAsync(-1, count, RedisCommands.EVAL_LIST_REVERSE);
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> pollFirstEntries(int count) {
        return this.get(this.pollFirstEntriesAsync(count));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> pollFirstEntriesAsync(int count) {
        if (count <= 0) {
            return new CompletableFutureWrapper<Collection<TimeSeriesEntry<V, L>>>(Collections.emptyList());
        }
        return this.pollEntriesAsync(0, count, EVAL_ENTRIES);
    }

    @Override
    public Collection<TimeSeriesEntry<V, L>> pollLastEntries(int count) {
        return this.get(this.pollLastEntriesAsync(count));
    }

    @Override
    public RFuture<Collection<TimeSeriesEntry<V, L>>> pollLastEntriesAsync(int count) {
        if (count <= 0) {
            return new CompletableFutureWrapper<Collection<TimeSeriesEntry<V, L>>>(Collections.emptyList());
        }
        return this.pollEntriesAsync(-1, count, EVAL_ENTRIES_REVERSE);
    }

    @Override
    public V pollFirst() {
        return this.get(this.pollFirstAsync());
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync() {
        return this.pollAsync(0, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public RFuture<V> pollLastAsync() {
        return this.pollAsync(-1, 1, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public TimeSeriesEntry<V, L> pollFirstEntry() {
        return this.get(this.pollFirstEntryAsync());
    }

    @Override
    public RFuture<TimeSeriesEntry<V, L>> pollFirstEntryAsync() {
        return this.pollEntriesAsync(0, 1, EVAL_FIRST_ENTRY);
    }

    @Override
    public TimeSeriesEntry<V, L> pollLastEntry() {
        return this.get(this.pollLastEntryAsync());
    }

    @Override
    public RFuture<TimeSeriesEntry<V, L>> pollLastEntryAsync() {
        return this.pollEntriesAsync(-1, 1, EVAL_FIRST_ENTRY);
    }

    private <T> RFuture<T> pollAsync(int startScore, int limit, RedisCommand<?> command) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, command, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'limit', 0, ARGV[3]);end; local result = {}; for i, v in ipairs(values) do redis.call('zrem', KEYS[2], v); redis.call('zrem', KEYS[1], v); local n, t, val, label = struct.unpack('BBc0Lc0Lc0', v); table.insert(result, val);end;return result;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startScore, limit);
    }

    private <T> RFuture<T> pollEntriesAsync(int startScore, int limit, RedisCommand<?> command) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, command, "local values;if ARGV[2] == '0' then values = redis.call('zrangebyscore', KEYS[2], ARGV[1], '+inf', 'withscores', 'limit', 0, ARGV[3]);else values = redis.call('zrevrangebyscore', KEYS[2], '+inf', ARGV[1], 'withscores', 'limit', 0, ARGV[3]);end; local result = {}; for i=1, #values, 2 do local score = redis.call('zscore', KEYS[1], values[i]); redis.call('zrem', KEYS[2], values[i]); redis.call('zrem', KEYS[1], values[i]); local n, t, val, label = struct.unpack('BBc0Lc0Lc0', values[i]); table.insert(result, val);if n == 2 then label = 0; end; table.insert(result, label);table.insert(result, n);table.insert(result, score);end;return result;", Arrays.asList(this.getRawName(), this.timeoutSetName), System.currentTimeMillis(), startScore, limit);
    }

    public ListScanResult<Object> scanIterator(String name, RedisClient client, String startPos, int count) {
        RFuture<ListScanResult<Object>> f = this.scanIteratorAsync(name, client, startPos, count);
        return this.get(f);
    }

    public RFuture<ListScanResult<Object>> scanIteratorAsync(String name, RedisClient client, String startPos, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startPos);
        params.add(System.currentTimeMillis());
        params.add(count);
        return this.commandExecutor.evalReadAsync(client, name, this.codec, RedisCommands.EVAL_SCAN, "local result = {}; local res = redis.call('zrange', KEYS[1], ARGV[1], tonumber(ARGV[1]) + tonumber(ARGV[3]) - 1); for i, value in ipairs(res) do local expirationDate = redis.call('zscore', KEYS[2], value); if tonumber(expirationDate) > tonumber(ARGV[2]) then local n, t, val, label = struct.unpack('BBc0Lc0Lc0', value); table.insert(result, val);end;end;local nextPos = tonumber(ARGV[1]) + tonumber(ARGV[3]); if #res < tonumber(ARGV[3]) then nextPos = 0;end;return {tostring(nextPos), result};", Arrays.asList(name, this.timeoutSetName), params.toArray());
    }

    @Override
    public Iterator<V> iterator(final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ListScanResult<Object> iterator(RedisClient client, String nextIterPos) {
                return RedissonTimeSeries.this.scanIterator(RedissonTimeSeries.this.getRawName(), client, nextIterPos, count);
            }

            @Override
            protected void remove(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(10);
    }

    @Override
    public Stream<V> stream() {
        return this.toStream(this.iterator());
    }

    @Override
    public Stream<V> stream(int count) {
        return this.toStream(this.iterator(count));
    }

    @Override
    public void destroy() {
        if (this.evictionScheduler != null) {
            this.evictionScheduler.remove(this.getRawName());
        }
        this.removeListeners();
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.timeoutSetName);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.timeoutSetName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, this.getRawName(), this.timeoutSetName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.timeoutSetName);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.timeoutSetName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        String newName = (String)keys.get(1);
        List<Object> kks = Arrays.asList(this.getRawName(), this.timeoutSetName, newName, this.getTimeoutSetName(newName));
        return super.copyAsync(kks, database, replace);
    }

    @Override
    public RFuture<Void> renameAsync(String nn) {
        String newName = this.mapName(nn);
        List<Object> kks = Arrays.asList(this.getRawName(), this.timeoutSetName, newName, this.getTimeoutSetName(newName));
        return this.renameAsync(this.commandExecutor, kks, () -> {
            this.setName(nn);
            this.timeoutSetName = this.getTimeoutSetName(newName);
        });
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String nn) {
        String newName = this.mapName(nn);
        List<Object> kks = Arrays.asList(this.getRawName(), this.timeoutSetName, newName, this.getTimeoutSetName(newName));
        return this.renamenxAsync(this.commandExecutor, kks, value -> {
            if (value.booleanValue()) {
                this.setName(nn);
                this.timeoutSetName = this.getTimeoutSetName(newName);
            }
        });
    }
}

