/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.Serializable;
import org.redisson.api.RObject;
import org.redisson.api.RObjectReactive;
import org.redisson.api.RObjectRx;
import org.redisson.api.annotation.REntity;
import org.redisson.client.codec.Codec;
import org.redisson.liveobject.misc.ClassUtils;

public class RedissonReference
implements Serializable {
    private static final long serialVersionUID = -2378564460151709127L;
    private String type;
    private String keyName;
    private String codec;

    public RedissonReference() {
    }

    public RedissonReference(Class<?> type, String keyName) {
        this(type, keyName, null);
    }

    public RedissonReference(Class<?> type, String keyName, Codec codec) {
        if (!(ClassUtils.isAnnotationPresent(type, REntity.class) || RObject.class.isAssignableFrom(type) || RObjectReactive.class.isAssignableFrom(type) || RObjectRx.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject/RLiveObject/RObjectReactive/RObjectRx");
        }
        if (RObjectReactive.class.isAssignableFrom(type)) {
            String t = type.getName().replaceFirst("Reactive", "");
            if (!this.isAvailable(t)) {
                throw new IllegalArgumentException("There is no compatible type for " + type);
            }
            this.type = t;
        } else if (RObjectRx.class.isAssignableFrom(type)) {
            String t = type.getName().replaceFirst("Rx", "");
            if (!this.isAvailable(t)) {
                throw new IllegalArgumentException("There is no compatible type for " + type);
            }
            this.type = t;
        } else {
            this.type = type.getName();
        }
        this.keyName = keyName;
        if (codec != null) {
            this.codec = codec.getClass().getName();
        }
    }

    public Class<?> getType() throws ClassNotFoundException {
        return Class.forName(this.type);
    }

    public Class<?> getRxJavaType() throws ClassNotFoundException {
        String rxName = this.type + "Rx";
        if (this.isAvailable(rxName)) {
            return Class.forName(rxName);
        }
        throw new ClassNotFoundException("There is no RxJava compatible type for " + this.type);
    }

    public Class<?> getReactiveType() throws ClassNotFoundException {
        String reactiveName = this.type + "Reactive";
        if (this.isAvailable(reactiveName)) {
            return Class.forName(reactiveName);
        }
        throw new ClassNotFoundException("There is no Reactive compatible type for " + this.type);
    }

    public String getTypeName() {
        return this.type;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getCodec() {
        return this.codec;
    }

    public Class<? extends Codec> getCodecType() throws ClassNotFoundException {
        if (this.codec != null) {
            return Class.forName(this.codec);
        }
        return null;
    }

    private boolean isAvailable(String type) {
        try {
            Class.forName(type);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

