/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timer;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisReconnectedException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.misc.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer;
    private final Bootstrap bootstrap;
    private final ChannelGroup channels;
    private static final int BACKOFF_CAP = 12;
    private final AsyncSemaphore semaphore = new AsyncSemaphore(2);

    public ConnectionWatchdog(Bootstrap bootstrap, ChannelGroup channels, Timer timer) {
        this.bootstrap = bootstrap;
        this.channels = channels;
        this.timer = timer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channels.add(ctx.channel());
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        Object connection = RedisConnection.getFrom(ctx.channel());
        if (connection != null) {
            if (!((RedisConnection)connection).isClosedIdle()) {
                ((RedisConnection)connection).fireDisconnected();
            }
            if (!((RedisConnection)connection).isClosed()) {
                if (((RedisConnection)connection).isFastReconnect()) {
                    this.tryReconnect((RedisConnection)connection, 1);
                } else {
                    this.semaphore.acquire().thenAccept(r -> this.reconnect((RedisConnection)connection, 1));
                }
            }
        }
        ctx.fireChannelInactive();
    }

    private void reconnect(RedisConnection connection, int attempts) {
        if (connection.isClosed()) {
            this.semaphore.release();
            return;
        }
        if (connection.getRedisClient().isShutdown() || this.bootstrap.config().group().isShuttingDown()) {
            return;
        }
        int timeout = 2 << attempts;
        try {
            this.timer.newTimeout(t -> this.tryReconnect(connection, Math.min(12, attempts + 1)), timeout, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void tryReconnect(final RedisConnection connection, final int nextAttempt) {
        if (connection.isClosed()) {
            this.semaphore.release();
            return;
        }
        if (connection.getRedisClient().isShutdown() || this.bootstrap.config().group().isShuttingDown()) {
            return;
        }
        this.log.debug("reconnecting {} to {} ", (Object)connection, (Object)connection.getRedisClient().getAddr());
        try {
            this.bootstrap.connect(connection.getRedisClient().getAddr()).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (connection.getRedisClient().isShutdown() || connection.isClosed() || ConnectionWatchdog.this.bootstrap.config().group().isShuttingDown()) {
                        Channel ch;
                        Object con;
                        if (future.isSuccess() && (con = RedisConnection.getFrom(ch = future.channel())) != null) {
                            ((RedisConnection)con).closeAsync();
                        }
                        if (connection.isClosed()) {
                            ConnectionWatchdog.this.semaphore.release();
                        }
                        return;
                    }
                    if (future.isSuccess()) {
                        Channel channel = future.channel();
                        if (channel.localAddress().equals(channel.remoteAddress())) {
                            channel.close();
                            ConnectionWatchdog.this.log.error("local address and remote address are the same! connected to: {}, localAddress: {} remoteAddress: {}", connection.getRedisClient().getAddr(), channel.localAddress(), channel.remoteAddress());
                        } else {
                            Object c = RedisConnection.getFrom(channel);
                            ((RedisConnection)c).getConnectionPromise().whenComplete((res, e) -> {
                                if (e == null) {
                                    ConnectionWatchdog.this.semaphore.release();
                                    if (connection.getRedisClient().isShutdown() || connection.isClosed()) {
                                        channel.close();
                                        return;
                                    }
                                    ConnectionWatchdog.this.log.debug("{} connected to {}, command: {}", connection, connection.getRedisClient().getAddr(), connection.getCurrentCommandData());
                                    ConnectionWatchdog.this.refresh(connection, channel);
                                } else {
                                    channel.close();
                                    ConnectionWatchdog.this.reconnect(connection, nextAttempt);
                                }
                            });
                            return;
                        }
                    }
                    ConnectionWatchdog.this.reconnect(connection, nextAttempt);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void reattachPubSub(RedisConnection connection) {
        if (connection instanceof RedisPubSubConnection) {
            RedisPubSubConnection conn = (RedisPubSubConnection)connection;
            for (Map.Entry<ChannelName, Codec> entry : conn.getChannels().entrySet()) {
                conn.subscribe(entry.getValue(), entry.getKey());
            }
            for (Map.Entry<ChannelName, Codec> entry : conn.getPatternChannels().entrySet()) {
                conn.psubscribe(entry.getValue(), entry.getKey());
            }
            for (Map.Entry<ChannelName, Codec> entry : conn.getShardedChannels().entrySet()) {
                conn.ssubscribe(entry.getValue(), entry.getKey());
            }
        }
    }

    private void refresh(RedisConnection connection, Channel channel) {
        QueueCommand currentCommand = connection.getCurrentCommandData();
        connection.fireConnected();
        connection.updateChannel(channel);
        if (connection.isFastReconnect()) {
            connection.clearFastReconnect();
        }
        if (currentCommand instanceof CommandData) {
            this.reattachBlockingQueue(connection, (CommandData)currentCommand);
        }
        this.reattachPubSub(connection);
        if (currentCommand != null && !currentCommand.isBlockingCommand() && !(connection instanceof RedisPubSubConnection)) {
            currentCommand.tryFailure(new RedisReconnectedException("Channel has been reconnected"));
        }
    }

    private void reattachBlockingQueue(RedisConnection connection, CommandData<?, ?> currentCommand) {
        if (currentCommand == null || !currentCommand.isBlockingCommand() || currentCommand.getPromise().isDone()) {
            return;
        }
        ChannelFuture future = connection.send(currentCommand);
        future.addListener(f -> {
            if (!f.isSuccess()) {
                this.log.error("Can't reconnect blocking queue by command: {} using connection: {}", (Object)currentCommand, (Object)connection);
            }
        });
    }
}

