/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.math.BigDecimal;
import java.util.Collections;
import org.redisson.RedissonExpirable;
import org.redisson.api.ObjectListener;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RFuture;
import org.redisson.api.listener.IncrByListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonAtomicDouble
extends RedissonExpirable
implements RAtomicDouble {
    public RedissonAtomicDouble(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public double addAndGet(double delta) {
        return this.get(this.addAndGetAsync(delta));
    }

    @Override
    public RFuture<Double> addAndGetAsync(double delta) {
        if (delta == 0.0) {
            return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBYFLOAT, this.getRawName(), 0);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBYFLOAT, this.getRawName(), BigDecimal.valueOf(delta).toPlainString());
    }

    @Override
    public boolean compareAndSet(double expect, double update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(double expect, double update) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]);if (value == false and tonumber(ARGV[1]) == 0) or (tonumber(value) == tonumber(ARGV[1])) then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getRawName()), BigDecimal.valueOf(expect).toPlainString(), BigDecimal.valueOf(update).toPlainString());
    }

    @Override
    public double decrementAndGet() {
        return this.get(this.decrementAndGetAsync());
    }

    @Override
    public RFuture<Double> decrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBYFLOAT, this.getRawName(), -1);
    }

    @Override
    public double get() {
        return this.get(this.getAsync());
    }

    @Override
    public double getAndDelete() {
        return this.get(this.getAndDeleteAsync());
    }

    @Override
    public RFuture<Double> getAndDeleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_DOUBLE, "local currValue = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return currValue; ", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public RFuture<Double> getAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.GET_DOUBLE, this.getRawName());
    }

    @Override
    public double getAndAdd(double delta) {
        return this.get(this.getAndAddAsync(delta));
    }

    @Override
    public RFuture<Double> getAndAddAsync(final double delta) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisStrictCommand<Double>("INCRBYFLOAT", new Convertor<Double>(){

            @Override
            public Double convert(Object obj) {
                return Double.valueOf(obj.toString()) - delta;
            }
        }), this.getRawName(), BigDecimal.valueOf(delta).toPlainString());
    }

    @Override
    public double getAndSet(double newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<Double> getAndSetAsync(double newValue) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)DoubleCodec.INSTANCE, RedisCommands.GETSET_DOUBLE, this.getRawName(), BigDecimal.valueOf(newValue).toPlainString());
    }

    @Override
    public double incrementAndGet() {
        return this.get(this.incrementAndGetAsync());
    }

    @Override
    public RFuture<Double> incrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBYFLOAT, this.getRawName(), 1);
    }

    @Override
    public double getAndIncrement() {
        return this.getAndAdd(1.0);
    }

    @Override
    public RFuture<Double> getAndIncrementAsync() {
        return this.getAndAddAsync(1.0);
    }

    @Override
    public double getAndDecrement() {
        return this.getAndAdd(-1.0);
    }

    @Override
    public RFuture<Double> getAndDecrementAsync() {
        return this.getAndAddAsync(-1.0);
    }

    @Override
    public void set(double newValue) {
        this.get(this.setAsync(newValue));
    }

    @Override
    public RFuture<Void> setAsync(double newValue) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, this.getRawName(), BigDecimal.valueOf(newValue).toPlainString());
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof IncrByListener) {
            return this.addListener("__keyevent@*:incrby", (IncrByListener)listener, IncrByListener::onChange);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof IncrByListener) {
            return this.addListenerAsync("__keyevent@*:incrby", (IncrByListener)listener, IncrByListener::onChange);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeListener(listenerId, "__keyevent@*:incrby");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        return this.removeListenerAsync(listenerId, "__keyevent@*:incrby");
    }
}

