/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import org.redisson.RedissonExpirable;
import org.redisson.api.RBitSet;
import org.redisson.api.RFuture;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;

public class RedissonBitSet
extends RedissonExpirable
implements RBitSet {
    public RedissonBitSet(CommandAsyncExecutor connectionManager, String name) {
        super(null, connectionManager, name);
    }

    @Override
    public long getSigned(int size, long offset) {
        return this.get(this.getSignedAsync(size, offset));
    }

    @Override
    public long setSigned(int size, long offset, long value) {
        return this.get(this.setSignedAsync(size, offset, value));
    }

    @Override
    public long incrementAndGetSigned(int size, long offset, long increment) {
        return this.get(this.incrementAndGetSignedAsync(size, offset, increment));
    }

    @Override
    public long getUnsigned(int size, long offset) {
        return this.get(this.getUnsignedAsync(size, offset));
    }

    @Override
    public long setUnsigned(int size, long offset, long value) {
        return this.get(this.setUnsignedAsync(size, offset, value));
    }

    @Override
    public long incrementAndGetUnsigned(int size, long offset, long increment) {
        return this.get(this.incrementAndGetUnsignedAsync(size, offset, increment));
    }

    @Override
    public RFuture<Long> getSignedAsync(int size, long offset) {
        if (size > 64) {
            throw new IllegalArgumentException("Size can't be greater than 64 bits");
        }
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "GET", "i" + size, offset);
    }

    @Override
    public RFuture<Long> setSignedAsync(int size, long offset, long value) {
        if (size > 64) {
            throw new IllegalArgumentException("Size can't be greater than 64 bits");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "SET", "i" + size, offset, value);
    }

    @Override
    public RFuture<Long> incrementAndGetSignedAsync(int size, long offset, long increment) {
        if (size > 64) {
            throw new IllegalArgumentException("Size can't be greater than 64 bits");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "INCRBY", "i" + size, offset, increment);
    }

    @Override
    public RFuture<Long> getUnsignedAsync(int size, long offset) {
        if (size > 63) {
            throw new IllegalArgumentException("Size can't be greater than 63 bits");
        }
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "GET", "u" + size, offset);
    }

    @Override
    public RFuture<Long> setUnsignedAsync(int size, long offset, long value) {
        if (size > 63) {
            throw new IllegalArgumentException("Size can't be greater than 63 bits");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "SET", "u" + size, offset, value);
    }

    @Override
    public RFuture<Long> incrementAndGetUnsignedAsync(int size, long offset, long increment) {
        if (size > 63) {
            throw new IllegalArgumentException("Size can't be greater than 63 bits");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "INCRBY", "u" + size, offset, increment);
    }

    @Override
    public byte getByte(long offset) {
        return this.get(this.getByteAsync(offset));
    }

    @Override
    public byte setByte(long offset, byte value) {
        return this.get(this.setByteAsync(offset, value));
    }

    @Override
    public byte incrementAndGetByte(long offset, byte increment) {
        return this.get(this.incrementAndGetByteAsync(offset, increment));
    }

    @Override
    public short getShort(long offset) {
        return this.get(this.getShortAsync(offset));
    }

    @Override
    public short setShort(long offset, short value) {
        return this.get(this.setShortAsync(offset, value));
    }

    @Override
    public short incrementAndGetShort(long offset, short increment) {
        return this.get(this.incrementAndGetShortAsync(offset, increment));
    }

    @Override
    public int getInteger(long offset) {
        return this.get(this.getIntegerAsync(offset));
    }

    @Override
    public int setInteger(long offset, int value) {
        return this.get(this.setIntegerAsync(offset, value));
    }

    @Override
    public int incrementAndGetInteger(long offset, int increment) {
        return this.get(this.incrementAndGetIntegerAsync(offset, increment));
    }

    @Override
    public long getLong(long offset) {
        return this.get(this.getLongAsync(offset));
    }

    @Override
    public long setLong(long offset, long value) {
        return this.get(this.setLongAsync(offset, value));
    }

    @Override
    public long incrementAndGetLong(long offset, long increment) {
        return this.get(this.incrementAndGetLongAsync(offset, increment));
    }

    @Override
    public RFuture<Byte> getByteAsync(long offset) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_BYTE, this.getRawName(), "GET", "i8", offset);
    }

    @Override
    public RFuture<Byte> setByteAsync(long offset, byte value) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_BYTE, this.getRawName(), "SET", "i8", offset, value);
    }

    @Override
    public RFuture<Byte> incrementAndGetByteAsync(long offset, byte increment) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_BYTE, this.getRawName(), "INCRBY", "i8", offset, increment);
    }

    @Override
    public RFuture<Short> getShortAsync(long offset) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_SHORT, this.getRawName(), "GET", "i16", offset);
    }

    @Override
    public RFuture<Short> setShortAsync(long offset, short value) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_SHORT, this.getRawName(), "SET", "i16", offset, value);
    }

    @Override
    public RFuture<Short> incrementAndGetShortAsync(long offset, short increment) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_SHORT, this.getRawName(), "INCRBY", "i16", offset, increment);
    }

    @Override
    public RFuture<Integer> getIntegerAsync(long offset) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_INT, this.getRawName(), "GET", "i32", offset);
    }

    @Override
    public RFuture<Integer> setIntegerAsync(long offset, int value) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_INT, this.getRawName(), "SET", "i32", offset, value);
    }

    @Override
    public RFuture<Integer> incrementAndGetIntegerAsync(long offset, int increment) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_INT, this.getRawName(), "INCRBY", "i32", offset, increment);
    }

    @Override
    public RFuture<Long> getLongAsync(long offset) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "GET", "i64", offset);
    }

    @Override
    public RFuture<Long> setLongAsync(long offset, long value) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "SET", "i64", offset, value);
    }

    @Override
    public RFuture<Long> incrementAndGetLongAsync(long offset, long increment) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITFIELD_LONG, this.getRawName(), "INCRBY", "i64", offset, increment);
    }

    @Override
    public long length() {
        return this.get(this.lengthAsync());
    }

    @Override
    public void set(BitSet bs) {
        this.get(this.setAsync(bs));
    }

    @Override
    public void set(long[] indexArray, boolean value) {
        this.get(this.setAsync(indexArray, value));
    }

    @Override
    public boolean get(long bitIndex) {
        return this.get(this.getAsync(bitIndex));
    }

    @Override
    public RFuture<Boolean> getAsync(long bitIndex) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GETBIT, this.getRawName(), bitIndex);
    }

    @Override
    public boolean set(long bitIndex) {
        return this.get(this.setAsync(bitIndex, true));
    }

    @Override
    public void set(long fromIndex, long toIndex, boolean value) {
        this.get(this.setAsync(fromIndex, toIndex, value));
    }

    @Override
    public void set(long fromIndex, long toIndex) {
        this.get(this.setAsync(fromIndex, toIndex));
    }

    @Override
    public boolean set(long bitIndex, boolean value) {
        return this.get(this.setAsync(bitIndex, value));
    }

    @Override
    public RFuture<Boolean> setAsync(long bitIndex, boolean value) {
        int val = this.toInt(value);
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.SETBIT, this.getRawName(), bitIndex, val);
    }

    protected int toInt(boolean value) {
        return Boolean.compare(value, false);
    }

    @Override
    public RFuture<Void> setAsync(long[] indexArray, boolean value) {
        int val = this.toInt(value);
        Object[] paramArray = new Object[indexArray.length * 4 + 1];
        int j = 0;
        paramArray[j++] = this.getRawName();
        for (int i = 0; i < indexArray.length; ++i) {
            paramArray[j++] = "set";
            paramArray[j++] = "u1";
            paramArray[j++] = indexArray[i];
            paramArray[j++] = val;
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BITFIELD_VOID, paramArray);
    }

    @Override
    public byte[] toByteArray() {
        return this.get(this.toByteArrayAsync());
    }

    @Override
    public RFuture<byte[]> toByteArrayAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, this.getRawName());
    }

    @Override
    public long cardinality() {
        return this.get(this.cardinalityAsync());
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public void clear(long fromIndex, long toIndex) {
        this.get(this.clearAsync(fromIndex, toIndex));
    }

    @Override
    public boolean clear(long bitIndex) {
        return this.get(this.clearAsync(bitIndex));
    }

    @Override
    public void clear() {
        this.get(this.clearAsync());
    }

    @Override
    public void or(String ... bitSetNames) {
        this.get(this.orAsync(bitSetNames));
    }

    @Override
    public void and(String ... bitSetNames) {
        this.get(this.andAsync(bitSetNames));
    }

    @Override
    public void xor(String ... bitSetNames) {
        this.get(this.xorAsync(bitSetNames));
    }

    @Override
    public void not() {
        this.get(this.notAsync());
    }

    private RFuture<Void> opAsync(String op, String ... bitSetNames) {
        ArrayList<String> params = new ArrayList<String>(bitSetNames.length + 3);
        params.add(op);
        params.add(this.getRawName());
        params.add(this.getRawName());
        params.addAll(Arrays.asList(bitSetNames));
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BITOP, params.toArray());
    }

    @Override
    public BitSet asBitSet() {
        return RedissonBitSet.fromByteArrayReverse(this.toByteArray());
    }

    private static BitSet fromByteArrayReverse(byte[] bytes) {
        if (bytes == null) {
            return new BitSet();
        }
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[i / 8] & 1 << 7 - i % 8) == 0) continue;
            bits.set(i);
        }
        return bits;
    }

    private static byte[] toByteArrayReverse(BitSet bits) {
        byte[] bytes = new byte[bits.length() / 8 + 1];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int value = bytes[i / 8] | 1 << 7 - i % 8;
            bytes[i / 8] = (byte)value;
        }
        return bytes;
    }

    public String toString() {
        return this.asBitSet().toString();
    }

    @Override
    public RFuture<Long> lengthAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local fromBit = redis.call('bitpos', KEYS[1], 1, -1);local toBit = 8*(fromBit/8 + 1) - fromBit % 8;for i = toBit, fromBit, -1 do if redis.call('getbit', KEYS[1], i) == 1 then return i+1;end;end;return fromBit+1", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public RFuture<Void> setAsync(long fromIndex, long toIndex, boolean value) {
        int val = this.toInt(value);
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor);
        for (long i = fromIndex; i < toIndex; ++i) {
            executorService.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.SETBIT_VOID, this.getRawName(), i, val);
        }
        return executorService.executeAsyncVoid();
    }

    @Override
    public RFuture<Void> clearAsync(long fromIndex, long toIndex) {
        return this.setAsync(fromIndex, toIndex, false);
    }

    @Override
    public RFuture<Void> setAsync(BitSet bs) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SET, this.getRawName(), RedissonBitSet.toByteArrayReverse(bs));
    }

    @Override
    public RFuture<Void> notAsync() {
        return this.opAsync("NOT", new String[0]);
    }

    @Override
    public RFuture<Void> setAsync(long fromIndex, long toIndex) {
        return this.setAsync(fromIndex, toIndex, true);
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITS_SIZE, this.getRawName());
    }

    @Override
    public RFuture<Boolean> setAsync(long bitIndex) {
        return this.setAsync(bitIndex, true);
    }

    @Override
    public RFuture<Long> cardinalityAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.BITCOUNT, this.getRawName());
    }

    @Override
    public RFuture<Boolean> clearAsync(long bitIndex) {
        return this.setAsync(bitIndex, false);
    }

    @Override
    public RFuture<Void> clearAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
    }

    @Override
    public RFuture<Void> orAsync(String ... bitSetNames) {
        return this.opAsync("OR", bitSetNames);
    }

    @Override
    public RFuture<Void> andAsync(String ... bitSetNames) {
        return this.opAsync("AND", bitSetNames);
    }

    @Override
    public RFuture<Void> xorAsync(String ... bitSetNames) {
        return this.opAsync("XOR", bitSetNames);
    }
}

