/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.redisson.api.Entry;
import org.redisson.api.FastAutoClaimResult;
import org.redisson.api.FunctionLibrary;
import org.redisson.api.FunctionStats;
import org.redisson.api.JsonType;
import org.redisson.api.RType;
import org.redisson.api.StreamInfo;
import org.redisson.api.StreamMessageId;
import org.redisson.api.search.index.IndexInfo;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RankedEntry;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.client.protocol.Time;
import org.redisson.client.protocol.convertor.BitsSizeReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanAmountReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanNotNullReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanNullReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanNullSafeReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanNumberReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.ByteReplayConvertor;
import org.redisson.client.protocol.convertor.DoubleNullSafeReplayConvertor;
import org.redisson.client.protocol.convertor.DoubleReplayConvertor;
import org.redisson.client.protocol.convertor.EmptyListConvertor;
import org.redisson.client.protocol.convertor.EmptyMapConvertor;
import org.redisson.client.protocol.convertor.EmptySetConvertor;
import org.redisson.client.protocol.convertor.InstantReplyConvertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.client.protocol.convertor.JsonTypeConvertor;
import org.redisson.client.protocol.convertor.LongReplayConvertor;
import org.redisson.client.protocol.convertor.ShortReplayConvertor;
import org.redisson.client.protocol.convertor.StreamIdConvertor;
import org.redisson.client.protocol.convertor.StringToListConvertor;
import org.redisson.client.protocol.convertor.TimeObjectDecoder;
import org.redisson.client.protocol.convertor.TrueReplayConvertor;
import org.redisson.client.protocol.convertor.TypeConvertor;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.AutoClaimDecoder;
import org.redisson.client.protocol.decoder.AutoClaimMapReplayDecoder;
import org.redisson.client.protocol.decoder.ClusterNodesDecoder;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.FastAutoClaimDecoder;
import org.redisson.client.protocol.decoder.IndexInfoDecoder;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ListObjectDecoder;
import org.redisson.client.protocol.decoder.ListResultReplayDecoder;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.Long2MultiDecoder;
import org.redisson.client.protocol.decoder.MapKeyDecoder;
import org.redisson.client.protocol.decoder.MapMergeDecoder;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.MapScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectFirstScoreReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapEntryReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder2;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.client.protocol.decoder.PendingEntryDecoder;
import org.redisson.client.protocol.decoder.PendingResultDecoder;
import org.redisson.client.protocol.decoder.RankedEntryDecoder;
import org.redisson.client.protocol.decoder.RedisURIDecoder;
import org.redisson.client.protocol.decoder.ScoredEntryScanDecoder;
import org.redisson.client.protocol.decoder.ScoredSortedSetPolledObjectDecoder;
import org.redisson.client.protocol.decoder.ScoredSortedSetRandomMapDecoder;
import org.redisson.client.protocol.decoder.ScoredSortedSetReplayDecoder;
import org.redisson.client.protocol.decoder.ScoredSortedSetReplayDecoderV2;
import org.redisson.client.protocol.decoder.ScoredSortedSetScanDecoder;
import org.redisson.client.protocol.decoder.ScoredSortedSetScanReplayDecoder;
import org.redisson.client.protocol.decoder.SlotsDecoder;
import org.redisson.client.protocol.decoder.StreamConsumerInfoDecoder;
import org.redisson.client.protocol.decoder.StreamGroupInfoDecoder;
import org.redisson.client.protocol.decoder.StreamIdDecoder;
import org.redisson.client.protocol.decoder.StreamObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.StreamResultDecoder;
import org.redisson.client.protocol.decoder.StreamResultDecoderV2;
import org.redisson.client.protocol.decoder.StringDataDecoder;
import org.redisson.client.protocol.decoder.StringListListReplayDecoder;
import org.redisson.client.protocol.decoder.StringListReplayDecoder;
import org.redisson.client.protocol.decoder.StringMapDataDecoder;
import org.redisson.client.protocol.decoder.StringMapReplayDecoder;
import org.redisson.client.protocol.decoder.TimeLongObjectDecoder;
import org.redisson.client.protocol.pubsub.PubSubStatusDecoder;
import org.redisson.cluster.ClusterNodeInfo;
import org.redisson.codec.CompositeCodec;
import org.redisson.misc.RedisURI;

public interface RedisCommands {
    public static final RedisStrictCommand<Void> DEBUG = new RedisStrictCommand("DEBUG");
    public static final RedisStrictCommand<Long> GEOADD = new RedisStrictCommand("GEOADD");
    public static final RedisStrictCommand<Boolean> GEOADD_BOOLEAN = new RedisStrictCommand<Boolean>("GEOADD", new BooleanReplayConvertor());
    public static final RedisCommand<Double> GEODIST = new RedisCommand<Double>("GEODIST", new DoubleReplayConvertor());
    public static final RedisCommand<List<Object>> GEORADIUS_RO = new RedisCommand("GEORADIUS_RO", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> GEORADIUSBYMEMBER_RO = new RedisCommand("GEORADIUSBYMEMBER_RO", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> GEOSEARCH = new RedisCommand("GEOSEARCH", new ObjectListReplayDecoder());
    public static final RedisCommand<Object> GEORADIUS_STORE = new RedisCommand<Object>("GEORADIUS", new Long2MultiDecoder());
    public static final RedisCommand<Object> GEORADIUSBYMEMBER_STORE = new RedisCommand<Object>("GEORADIUSBYMEMBER", new Long2MultiDecoder());
    public static final RedisCommand<Object> GEOSEARCHSTORE_STORE = new RedisCommand<Object>("GEOSEARCHSTORE", new Long2MultiDecoder());
    public static final RedisStrictCommand<Integer> KEYSLOT = new RedisStrictCommand<Integer>("CLUSTER", "KEYSLOT", new IntegerReplayConvertor());
    public static final RedisStrictCommand<RType> TYPE = new RedisStrictCommand<RType>("TYPE", new TypeConvertor());
    public static final RedisStrictCommand<Object> BITFIELD_LONG = new RedisStrictCommand<Object>("BITFIELD", null, new ListFirstObjectDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Object> BITFIELD_INT = new RedisStrictCommand<Object>("BITFIELD", null, new ListFirstObjectDecoder(), new IntegerReplayConvertor(0));
    public static final RedisStrictCommand<Object> BITFIELD_BYTE = new RedisStrictCommand<Object>("BITFIELD", null, new ListFirstObjectDecoder(), new ByteReplayConvertor());
    public static final RedisStrictCommand<Object> BITFIELD_SHORT = new RedisStrictCommand<Object>("BITFIELD", null, new ListFirstObjectDecoder(), new ShortReplayConvertor());
    public static final RedisStrictCommand<Void> BITFIELD_VOID = new RedisStrictCommand<Void>("BITFIELD", new VoidReplayConvertor());
    public static final RedisStrictCommand<Boolean> GETBIT = new RedisStrictCommand<Boolean>("GETBIT", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Long> BITS_SIZE = new RedisStrictCommand<Long>("STRLEN", new BitsSizeReplayConvertor());
    public static final RedisStrictCommand<Long> STRLEN = new RedisStrictCommand("STRLEN");
    public static final RedisStrictCommand<Long> BITCOUNT = new RedisStrictCommand("BITCOUNT");
    public static final RedisStrictCommand<Integer> BITPOS = new RedisStrictCommand<Integer>("BITPOS", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Void> SETBIT_VOID = new RedisStrictCommand<Void>("SETBIT", new VoidReplayConvertor());
    public static final RedisStrictCommand<Boolean> SETBIT = new RedisStrictCommand<Boolean>("SETBIT", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Void> BITOP = new RedisStrictCommand<Void>("BITOP", new VoidReplayConvertor());
    public static final RedisStrictCommand<Integer> WAIT = new RedisStrictCommand<Integer>("WAIT", new IntegerReplayConvertor());
    public static final RedisCommand<List<Integer>> WAITAOF = new RedisCommand<Integer>("WAITAOF", new ObjectListReplayDecoder(), new IntegerReplayConvertor());
    public static final RedisStrictCommand<Void> CLIENT_REPLY = new RedisStrictCommand<Void>("CLIENT", "REPLY", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> ASKING = new RedisStrictCommand<Void>("ASKING", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> READONLY = new RedisStrictCommand<Void>("READONLY", new VoidReplayConvertor());
    public static final RedisCommand<Map<Object, Object>> ZRANDMEMBER_ENTRIES = new RedisCommand<Map<Object, Object>>("ZRANDMEMBER", new ScoredSortedSetRandomMapDecoder());
    public static final RedisCommand<Set<Object>> ZRANDMEMBER = new RedisCommand("ZRANDMEMBER", new ObjectSetReplayDecoder());
    public static final RedisCommand<Object> ZRANDMEMBER_SINGLE = new RedisCommand("ZRANDMEMBER");
    public static final RedisStrictCommand<List<Object>> ZDIFF = new RedisStrictCommand("ZDIFF", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> ZUNION = new RedisCommand("ZUNION", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> ZINTER = new RedisCommand("ZINTER", new ObjectListReplayDecoder());
    public static final RedisStrictCommand<Integer> ZINTERCARD_INT = new RedisStrictCommand<Integer>("ZINTERCARD", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> ZDIFFSTORE_INT = new RedisStrictCommand<Integer>("ZDIFFSTORE", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> ZUNIONSTORE_INT = new RedisStrictCommand<Integer>("ZUNIONSTORE", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> ZINTERSTORE_INT = new RedisStrictCommand<Integer>("ZINTERSTORE", new IntegerReplayConvertor());
    public static final RedisCommand<Boolean> ZADD_BOOL = new RedisCommand<Boolean>("ZADD", new BooleanAmountReplayConvertor());
    public static final RedisCommand<Boolean> ZADD_NX_BOOL = new RedisCommand<Boolean>("ZADD", new BooleanAmountReplayConvertor());
    public static final RedisCommand<Boolean> ZADD_BOOL_RAW = new RedisCommand<Boolean>("ZADD", new BooleanAmountReplayConvertor());
    public static final RedisCommand<Boolean> ZADD_RAW = new RedisCommand("ZADD");
    public static final RedisStrictCommand<Integer> ZADD_INT = new RedisStrictCommand<Integer>("ZADD", new IntegerReplayConvertor());
    public static final RedisCommand<Long> ZADD = new RedisCommand("ZADD");
    public static final RedisStrictCommand<Integer> ZREM_INT = new RedisStrictCommand<Integer>("ZREM", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Long> ZREM_LONG = new RedisStrictCommand("ZREM");
    public static final RedisCommand<Boolean> ZREM = new RedisCommand<Boolean>("ZREM", new BooleanAmountReplayConvertor());
    public static final RedisStrictCommand<Integer> ZCARD_INT = new RedisStrictCommand<Integer>("ZCARD", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Long> ZCARD = new RedisStrictCommand("ZCARD");
    public static final RedisStrictCommand<Integer> ZCOUNT = new RedisStrictCommand<Integer>("ZCOUNT", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> ZLEXCOUNT = new RedisStrictCommand<Integer>("ZLEXCOUNT", new IntegerReplayConvertor());
    public static final RedisCommand<Boolean> ZSCORE_CONTAINS = new RedisCommand<Boolean>("ZSCORE", new BooleanNotNullReplayConvertor());
    public static final RedisStrictCommand<Double> ZSCORE = new RedisStrictCommand<Double>("ZSCORE", new DoubleReplayConvertor());
    public static final RedisStrictCommand<Long> ZRANK = new RedisStrictCommand("ZRANK");
    public static final RedisCommand<Integer> ZRANK_INT = new RedisCommand<Integer>("ZRANK", new IntegerReplayConvertor());
    public static final RedisCommand<RankedEntry<?>> ZRANK_ENTRY = new RedisCommand("ZRANK", new RankedEntryDecoder());
    public static final RedisStrictCommand<Long> ZREVRANK = new RedisStrictCommand("ZREVRANK");
    public static final RedisCommand<Integer> ZREVRANK_INT = new RedisCommand<Integer>("ZREVRANK", new IntegerReplayConvertor());
    public static final RedisCommand<RankedEntry<?>> ZREVRANK_ENTRY = new RedisCommand("ZREVRANK", new RankedEntryDecoder());
    public static final RedisCommand<Object> ZRANGE_SINGLE = new RedisCommand<Object>("ZRANGE", new ListFirstObjectDecoder());
    public static final RedisCommand<Object> ZRANGE_SINGLE_ENTRY = new RedisCommand<Object>("ZRANGE", new ListFirstObjectDecoder(new ScoredSortedSetReplayDecoder()));
    public static final RedisCommand<Object> ZRANGE_SINGLE_ENTRY_V2 = new RedisCommand<Object>("ZRANGE", new ListMultiDecoder2(new ListFirstObjectDecoder(), new ScoredSortedSetReplayDecoderV2()));
    public static final RedisStrictCommand<Double> ZRANGE_SINGLE_SCORE = new RedisStrictCommand<Double>("ZRANGE", new ObjectFirstScoreReplayDecoder());
    public static final RedisCommand<List<Object>> ZRANGE = new RedisCommand("ZRANGE", new ObjectListReplayDecoder());
    public static final RedisCommand<Integer> ZRANGESTORE = new RedisCommand<Integer>("ZRANGESTORE", new IntegerReplayConvertor());
    public static final RedisCommand<List<Object>> ZPOPMIN = new RedisCommand("ZPOPMIN", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> ZPOPMAX = new RedisCommand("ZPOPMAX", new ObjectListReplayDecoder());
    public static final RedisCommand<List<ScoredEntry>> BZMPOP_ENTRIES = new RedisCommand<Object>("BZMPOP", new ListMultiDecoder2(new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()){

        @Override
        public Object decode(List parts, State state) {
            int i = 0;
            if (i < parts.size()) {
                List entries = (List)parts.get(i + 1);
                ArrayList map = new ArrayList();
                for (List entry : entries) {
                    map.add(new ScoredEntry((Double)entry.get(1), entry.get(0)));
                }
                return map;
            }
            return Collections.emptyList();
        }
    }, new CodecDecoder(), new CodecDecoder(){

        @Override
        public Decoder<Object> getDecoder(Codec codec, int paramNum, State state, long size) {
            if ((paramNum + 1) % 2 == 0) {
                return DoubleCodec.INSTANCE.getValueDecoder();
            }
            return codec.getValueDecoder();
        }
    }));
    public static final RedisCommand<Map<String, Map<Object, Double>>> ZMPOP = new RedisCommand<Object>("ZMPOP", new ListMultiDecoder2(new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()){

        @Override
        public Object decode(List parts, State state) {
            HashMap result = new HashMap();
            for (int i = 0; i < parts.size(); i += 2) {
                List entries = (List)parts.get(i + 1);
                HashMap map = new HashMap(entries.size());
                for (List entry : entries) {
                    map.put(entry.get(0), entry.get(1));
                }
                result.put((String)parts.get(i), map);
            }
            return result;
        }
    }, new CodecDecoder(), new CodecDecoder(){

        @Override
        public Decoder<Object> getDecoder(Codec codec, int paramNum, State state, long size) {
            if ((paramNum + 1) % 2 == 0) {
                return DoubleCodec.INSTANCE.getValueDecoder();
            }
            return codec.getValueDecoder();
        }
    }));
    public static final RedisCommand<List<Object>> ZMPOP_VALUES = new RedisCommand<Object>("ZMPOP", new ListMultiDecoder2(new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()){

        @Override
        public Object decode(List parts, State state) {
            if (parts.isEmpty()) {
                return parts;
            }
            return parts.get(1);
        }
    }, new CodecDecoder(), new ListFirstObjectDecoder(){

        @Override
        public Decoder<Object> getDecoder(Codec codec, int paramNum, State state, long size) {
            if ((paramNum + 1) % 2 == 0) {
                return DoubleCodec.INSTANCE.getValueDecoder();
            }
            return codec.getValueDecoder();
        }
    }));
    public static final RedisStrictCommand<Integer> ZREMRANGEBYRANK = new RedisStrictCommand<Integer>("ZREMRANGEBYRANK", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> ZREMRANGEBYSCORE = new RedisStrictCommand<Integer>("ZREMRANGEBYSCORE", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> ZREMRANGEBYLEX = new RedisStrictCommand<Integer>("ZREMRANGEBYLEX", new IntegerReplayConvertor());
    public static final RedisCommand<List<Object>> ZRANGEBYLEX = new RedisCommand("ZRANGEBYLEX", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> ZREVRANGEBYLEX = new RedisCommand("ZREVRANGEBYLEX", new ObjectListReplayDecoder());
    public static final RedisCommand<Set<Object>> ZRANGEBYSCORE = new RedisCommand("ZRANGEBYSCORE", new ObjectSetReplayDecoder());
    public static final RedisCommand<List<Object>> ZRANGEBYSCORE_LIST = new RedisCommand("ZRANGEBYSCORE", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> ZREVRANGE = new RedisCommand("ZREVRANGE", new ObjectListReplayDecoder());
    public static final RedisCommand<Set<Object>> ZREVRANGEBYSCORE = new RedisCommand("ZREVRANGEBYSCORE", new ObjectSetReplayDecoder());
    public static final RedisCommand<List<ScoredEntry<Object>>> ZREVRANGE_ENTRY = new RedisCommand("ZREVRANGE", new ScoredSortedSetReplayDecoder());
    public static final RedisCommand<List<ScoredEntry<Object>>> ZREVRANGE_ENTRY_V2 = new RedisCommand<Object>("ZREVRANGE", new ListMultiDecoder2(new CodecDecoder(), new ScoredSortedSetReplayDecoderV2()));
    public static final RedisCommand<List<ScoredEntry<Object>>> ZREVRANGEBYSCORE_ENTRY = new RedisCommand("ZREVRANGEBYSCORE", new ScoredSortedSetReplayDecoder());
    public static final RedisCommand<List<ScoredEntry<Object>>> ZREVRANGEBYSCORE_ENTRY_V2 = new RedisCommand<Object>("ZREVRANGEBYSCORE", new ListMultiDecoder2(new CodecDecoder(), new ScoredSortedSetReplayDecoderV2()));
    public static final RedisCommand<List<ScoredEntry<Object>>> ZRANGE_ENTRY = new RedisCommand("ZRANGE", new ScoredSortedSetReplayDecoder());
    public static final RedisCommand<List<ScoredEntry<Object>>> ZRANGE_ENTRY_V2 = new RedisCommand<Object>("ZRANGE", new ListMultiDecoder2(new CodecDecoder(), new ScoredSortedSetReplayDecoderV2()));
    public static final RedisCommand<List<ScoredEntry<Object>>> ZRANGEBYSCORE_ENTRY = new RedisCommand("ZRANGEBYSCORE", new ScoredSortedSetReplayDecoder());
    public static final RedisCommand<List<ScoredEntry<Object>>> ZRANGEBYSCORE_ENTRY_V2 = new RedisCommand<Object>("ZRANGEBYSCORE", new ListMultiDecoder2(new CodecDecoder(), new ScoredSortedSetReplayDecoderV2()));
    public static final RedisCommand<ListScanResult<Object>> ZSCAN = new RedisCommand<Object>("ZSCAN", new ListMultiDecoder2(new ScoredSortedSetScanReplayDecoder(), new ScoredSortedSetScanDecoder()));
    public static final RedisCommand<ListScanResult<Object>> ZSCAN_ENTRY = new RedisCommand<Object>("ZSCAN", new ListMultiDecoder2(new ScoredEntryScanDecoder(), new ScoredSortedSetScanDecoder()));
    public static final RedisStrictCommand<Double> ZINCRBY = new RedisStrictCommand<Double>("ZINCRBY", new DoubleNullSafeReplayConvertor());
    public static final RedisCommand<ListScanResult<String>> SCAN = new RedisCommand<Object>("SCAN", new ListMultiDecoder2(new ListScanResultReplayDecoder(), new ObjectListReplayDecoder()));
    public static final RedisStrictCommand<String> RANDOM_KEY = new RedisStrictCommand("RANDOMKEY");
    public static final RedisCommand<String> PING = new RedisCommand("PING");
    public static final RedisStrictCommand<Boolean> PING_BOOL = new RedisStrictCommand<Boolean>("PING", new BooleanNotNullReplayConvertor());
    public static final RedisStrictCommand<Void> SHUTDOWN = new RedisStrictCommand<Void>("SHUTDOWN", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> UNWATCH = new RedisStrictCommand<Void>("UNWATCH", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> WATCH = new RedisStrictCommand<Void>("WATCH", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> MULTI = new RedisStrictCommand<Void>("MULTI", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> DISCARD = new RedisStrictCommand<Void>("DISCARD", new VoidReplayConvertor());
    public static final RedisCommand<List<Object>> EXEC = new RedisCommand("EXEC", new ObjectListReplayDecoder());
    public static final RedisCommand<Boolean> SADD_BOOL = new RedisCommand<Boolean>("SADD", new BooleanAmountReplayConvertor());
    public static final RedisCommand<Integer> SADD = new RedisCommand<Integer>("SADD", new IntegerReplayConvertor());
    public static final RedisCommand<Set<Object>> SPOP = new RedisCommand("SPOP", new ObjectSetReplayDecoder());
    public static final RedisCommand<Object> SPOP_SINGLE = new RedisCommand("SPOP");
    public static final RedisCommand<Boolean> SADD_SINGLE = new RedisCommand<Boolean>("SADD", new BooleanReplayConvertor());
    public static final RedisCommand<Integer> SREM = new RedisCommand<Integer>("SREM", new IntegerReplayConvertor());
    public static final RedisCommand<Boolean> SREM_SINGLE = new RedisCommand<Boolean>("SREM", new BooleanAmountReplayConvertor());
    public static final RedisCommand<Boolean> SMOVE = new RedisCommand<Boolean>("SMOVE", new BooleanReplayConvertor());
    public static final RedisCommand<Set<Object>> SMEMBERS = new RedisCommand("SMEMBERS", new ObjectSetReplayDecoder());
    public static final RedisCommand<Set<Object>> SRANDMEMBER = new RedisCommand("SRANDMEMBER", new ObjectSetReplayDecoder());
    public static final RedisCommand<Object> SRANDMEMBER_SINGLE = new RedisCommand("SRANDMEMBER");
    public static final RedisCommand<ListScanResult<Object>> SSCAN = new RedisCommand<Object>("SSCAN", new ListMultiDecoder2(new ListScanResultReplayDecoder(), new ObjectListReplayDecoder()));
    public static final RedisCommand<ListScanResult<Object>> EVAL_SCAN = new RedisCommand<Object>("EVAL", new ListMultiDecoder2(new ListScanResultReplayDecoder(), new ObjectListReplayDecoder()));
    public static final RedisCommand<Boolean> SISMEMBER = new RedisCommand<Boolean>("SISMEMBER", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Integer> SCARD_INT = new RedisStrictCommand<Integer>("SCARD", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> SINTERCARD_INT = new RedisStrictCommand<Integer>("SINTERCARD", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Long> SCARD = new RedisStrictCommand("SCARD");
    public static final RedisStrictCommand<Integer> SUNIONSTORE_INT = new RedisStrictCommand<Integer>("SUNIONSTORE", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> SDIFFSTORE_INT = new RedisStrictCommand<Integer>("SDIFFSTORE", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> SINTERSTORE_INT = new RedisStrictCommand<Integer>("SINTERSTORE", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Long> SUNIONSTORE = new RedisStrictCommand("SUNIONSTORE");
    public static final RedisStrictCommand<Long> SINTERSTORE = new RedisStrictCommand("SINTERSTORE");
    public static final RedisStrictCommand<Long> SDIFFSTORE = new RedisStrictCommand("SDIFFSTORE");
    public static final RedisCommand<Set<Object>> SUNION = new RedisCommand("SUNION", new ObjectSetReplayDecoder());
    public static final RedisCommand<Set<Object>> SDIFF = new RedisCommand("SDIFF", new ObjectSetReplayDecoder());
    public static final RedisCommand<Set<Object>> SINTER = new RedisCommand("SINTER", new ObjectSetReplayDecoder());
    public static final RedisCommand<List<Long>> SMISMEMBER = new RedisCommand("SMISMEMBER", new ObjectListReplayDecoder());
    public static final RedisStrictCommand<Long> LPOS = new RedisStrictCommand("LPOS");
    public static final RedisCommand<Void> LSET = new RedisCommand<Void>("LSET", new VoidReplayConvertor());
    public static final RedisCommand<Object> LPOP = new RedisCommand("LPOP");
    public static final RedisCommand<List<Object>> LPOP_LIST = new RedisCommand("LPOP", new ObjectListReplayDecoder());
    public static final RedisCommand<Boolean> LREM = new RedisCommand<Boolean>("LREM", new BooleanAmountReplayConvertor());
    public static final RedisCommand<Object> LINDEX = new RedisCommand("LINDEX");
    public static final RedisCommand<Object> LMOVE = new RedisCommand("LMOVE");
    public static final RedisCommand<Integer> LINSERT_INT = new RedisCommand<Integer>("LINSERT", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Integer> LLEN_INT = new RedisStrictCommand<Integer>("LLEN", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Void> LTRIM = new RedisStrictCommand<Void>("LTRIM", new VoidReplayConvertor());
    public static final RedisStrictCommand<Boolean> PEXPIRE = new RedisStrictCommand<Boolean>("PEXPIRE", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> PEXPIREAT = new RedisStrictCommand<Boolean>("PEXPIREAT", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> PERSIST = new RedisStrictCommand<Boolean>("PERSIST", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Long> PTTL = new RedisStrictCommand("PTTL");
    public static final RedisStrictCommand<Long> PEXPIRETIME = new RedisStrictCommand("PEXPIRETIME");
    public static final RedisCommand<Object> RPOPLPUSH = new RedisCommand("RPOPLPUSH");
    public static final RedisCommand<Object> BRPOPLPUSH = new RedisCommand<Object>("BRPOPLPUSH", new CodecDecoder(){

        @Override
        public Object decode(List<Object> parts, State state) {
            if (parts.isEmpty()) {
                return null;
            }
            return super.decode(parts, state);
        }
    });
    public static final RedisCommand<List<Object>> BLPOP = new RedisCommand("BLPOP", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> BRPOP = new RedisCommand("BRPOP", new ObjectListReplayDecoder());
    public static final RedisCommand<Map<String, Map<Object, Double>>> BZMPOP = new RedisCommand<Map<String, Map<Object, Double>>>("BZMPOP", ZMPOP.getReplayMultiDecoder());
    public static final RedisCommand<List<Object>> BZMPOP_SINGLE_LIST = new RedisCommand<Object>("BZMPOP", ZMPOP_VALUES.getReplayMultiDecoder(), new EmptyListConvertor());
    public static final RedisCommand<Object> BLPOP_VALUE = new RedisCommand("BLPOP", new ListObjectDecoder(1));
    public static final RedisCommand<Object> BLMOVE = new RedisCommand<Object>("BLMOVE", new ListFirstObjectDecoder());
    public static final RedisCommand<Object> BRPOP_VALUE = new RedisCommand("BRPOP", new ListObjectDecoder(1));
    public static final RedisCommand<Object> BZPOPMIN_VALUE = new RedisCommand<Object>("BZPOPMIN", new ScoredSortedSetPolledObjectDecoder());
    public static final RedisCommand<Object> BZPOPMAX_VALUE = new RedisCommand<Object>("BZPOPMAX", new ScoredSortedSetPolledObjectDecoder());
    public static final RedisCommand<Map<String, List<Object>>> BLPOP_NAME = new RedisCommand("BLPOP", new ListObjectDecoder(0){

        @Override
        public Object decode(List parts, State state) {
            if (parts.isEmpty()) {
                return null;
            }
            return new Entry(parts.get(0), parts.get(1));
        }
    });
    public static final RedisCommand<Map<String, List<Object>>> BLMPOP = new RedisCommand<Object>("BLMPOP", new ListMultiDecoder2(new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()){

        @Override
        public Object decode(List parts, State state) {
            if (parts.isEmpty()) {
                return null;
            }
            return Collections.singletonMap(parts.get(0), parts.get(1));
        }
    }, new CodecDecoder(), new CodecDecoder(){

        @Override
        public Decoder<Object> getDecoder(Codec codec, int paramNum, State state, long size) {
            if ((paramNum + 1) % 2 == 0) {
                return DoubleCodec.INSTANCE.getValueDecoder();
            }
            return codec.getValueDecoder();
        }
    }));
    public static final Set<String> BLOCKING_COMMAND_NAMES = new HashSet<String>(Arrays.asList(BRPOPLPUSH.getName(), BZPOPMIN_VALUE.getName(), BZPOPMAX_VALUE.getName(), BLPOP.getName(), BRPOP.getName(), BLMOVE.getName(), BZMPOP_SINGLE_LIST.getName(), BLMPOP.getName()));
    public static final RedisCommand<Boolean> PFADD = new RedisCommand<Boolean>("PFADD", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Long> PFCOUNT = new RedisStrictCommand("PFCOUNT");
    public static final RedisStrictCommand<Void> PFMERGE = new RedisStrictCommand<Void>("PFMERGE", new VoidReplayConvertor());
    public static final RedisCommand<List<Object>> SORT_LIST = new RedisCommand("SORT", new ObjectListReplayDecoder());
    public static final RedisCommand<Set<Object>> SORT_SET = new RedisCommand("SORT", new ObjectSetReplayDecoder());
    public static final RedisCommand<Integer> SORT_TO = new RedisCommand<Integer>("SORT", new IntegerReplayConvertor());
    public static final RedisCommand<Object> RPOP = new RedisCommand("RPOP");
    public static final RedisCommand<List<Object>> RPOP_LIST = new RedisCommand("RPOP", new ObjectListReplayDecoder());
    public static final RedisCommand<Integer> LPUSH = new RedisCommand<Integer>("LPUSH", new IntegerReplayConvertor());
    public static final RedisCommand<Integer> LPUSHX = new RedisCommand<Integer>("LPUSHX", new IntegerReplayConvertor());
    public static final RedisCommand<Boolean> LPUSH_BOOLEAN = new RedisCommand<Boolean>("LPUSH", new TrueReplayConvertor());
    public static final RedisStrictCommand<Void> LPUSH_VOID = new RedisStrictCommand<Void>("LPUSH", new VoidReplayConvertor());
    public static final RedisCommand<List<Object>> LRANGE = new RedisCommand("LRANGE", new ObjectListReplayDecoder());
    public static final RedisCommand<Set<Object>> LRANGE_SET = new RedisCommand("LRANGE", new ObjectSetReplayDecoder());
    public static final RedisCommand<Integer> RPUSH = new RedisCommand<Integer>("RPUSH", new IntegerReplayConvertor());
    public static final RedisCommand<Integer> RPUSHX = new RedisCommand<Integer>("RPUSHX", new IntegerReplayConvertor());
    public static final RedisCommand<Boolean> RPUSH_BOOLEAN = new RedisCommand<Boolean>("RPUSH", new TrueReplayConvertor());
    public static final RedisCommand<Void> RPUSH_VOID = new RedisCommand<Void>("RPUSH", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FUNCTION_DELETE = new RedisStrictCommand<Void>("FUNCTION", "DELETE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FUNCTION_FLUSH = new RedisStrictCommand<Void>("FUNCTION", "FLUSH", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FUNCTION_KILL = new RedisStrictCommand<Void>("FUNCTION", "KILL", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FUNCTION_RESTORE = new RedisStrictCommand<Void>("FUNCTION", "RESTORE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FUNCTION_LOAD = new RedisStrictCommand<Void>("FUNCTION", "LOAD", new VoidReplayConvertor());
    public static final RedisStrictCommand<Object> FUNCTION_DUMP = new RedisStrictCommand("FUNCTION", "DUMP");
    public static final RedisStrictCommand<Object> FUNCTION_STATS = new RedisStrictCommand<Object>("FUNCTION", "STATS", new ListMultiDecoder2(new CodecDecoder(){

        @Override
        public Object decode(List<Object> parts, State state) {
            FunctionStats.RunningFunction runningFunction = (FunctionStats.RunningFunction)parts.get(1);
            Map engines = (Map)parts.get(3);
            return new FunctionStats(runningFunction, engines);
        }
    }, new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()){

        @Override
        public Object decode(List parts, State state) {
            if (parts.size() == 2) {
                HashMap<String, FunctionStats.Engine> result = new HashMap<String, FunctionStats.Engine>();
                List objects = (List)parts.get(1);
                Long libraries = (Long)objects.get(1);
                Long functions = (Long)objects.get(3);
                String engine = (String)parts.get(0);
                result.put(engine, new FunctionStats.Engine(libraries, functions));
                return result;
            }
            String name = (String)parts.get(1);
            List command = (List)parts.get(3);
            Long duration = (Long)parts.get(5);
            return new FunctionStats.RunningFunction(name, command, Duration.ofMillis(duration));
        }
    }, new ObjectDecoder<Object>(StringCodec.INSTANCE.getValueDecoder())));
    public static final RedisStrictCommand<Object> FUNCTION_LIST = new RedisStrictCommand<Object>("FUNCTION", "LIST", new ListMultiDecoder2(new CodecDecoder(), new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()){

        @Override
        public Object decode(List parts, State state) {
            String name = (String)parts.get(1);
            String engine = (String)parts.get(3);
            String code = null;
            if (parts.size() > 6) {
                code = (String)parts.get(6);
            }
            List functions = (List)parts.get(5);
            return new FunctionLibrary(name, engine, code, functions);
        }
    }, new CodecDecoder(), new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()){

        @Override
        public Object decode(List parts, State state) {
            String functionName = (String)parts.get(1);
            String functionDescription = (String)parts.get(3);
            List<FunctionLibrary.Flag> functionFlags = ((List)parts.get(5)).stream().map(s -> FunctionLibrary.Flag.valueOf(s.toUpperCase().replace("-", "_"))).collect(Collectors.toList());
            return new FunctionLibrary.Function(functionName, functionDescription, functionFlags);
        }
    }, new CodecDecoder()));
    public static final RedisStrictCommand<Boolean> FCALL_BOOLEAN_SAFE = new RedisStrictCommand<Boolean>("FCALL", new BooleanNullSafeReplayConvertor());
    public static final RedisStrictCommand<Long> FCALL_LONG = new RedisStrictCommand("FCALL");
    public static final RedisCommand<List<Object>> FCALL_LIST = new RedisCommand("FCALL", new ObjectListReplayDecoder());
    public static final RedisStrictCommand<String> FCALL_STRING = new RedisStrictCommand<Object>("FCALL", new ObjectDecoder<Object>(StringCodec.INSTANCE.getValueDecoder()));
    public static final RedisCommand<Object> FCALL_OBJECT = new RedisCommand("FCALL");
    public static final RedisCommand<Object> FCALL_MAP_VALUE = new RedisCommand<Object>("FCALL", new MapValueDecoder());
    public static final RedisCommand<List<Object>> FCALL_MAP_VALUE_LIST = new RedisCommand<Object>("FCALL", new MapValueDecoder(new ObjectListReplayDecoder()));
    public static final RedisStrictCommand<String> SCRIPT_LOAD = new RedisStrictCommand<Object>("SCRIPT", "LOAD", new ObjectDecoder<String>(new StringDataDecoder()));
    public static final RedisStrictCommand<Boolean> SCRIPT_KILL = new RedisStrictCommand<Boolean>("SCRIPT", "KILL", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> SCRIPT_FLUSH = new RedisStrictCommand<Boolean>("SCRIPT", "FLUSH", new BooleanReplayConvertor());
    public static final RedisStrictCommand<List<Boolean>> SCRIPT_EXISTS = new RedisStrictCommand("SCRIPT", "EXISTS", new ObjectListReplayDecoder(), new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> EVAL_BOOLEAN_AMOUNT = new RedisStrictCommand<Boolean>("EVAL", new BooleanAmountReplayConvertor());
    public static final RedisStrictCommand<Boolean> EVAL_BOOLEAN = new RedisStrictCommand<Boolean>("EVAL", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> EVAL_BOOLEAN_SAFE = new RedisStrictCommand<Boolean>("EVAL", new BooleanNullSafeReplayConvertor());
    public static final RedisStrictCommand<Boolean> EVAL_NULL_BOOLEAN = new RedisStrictCommand<Boolean>("EVAL", new BooleanNullReplayConvertor());
    public static final RedisStrictCommand<String> EVAL_STRING = new RedisStrictCommand<Object>("EVAL", new ObjectDecoder<Object>(StringCodec.INSTANCE.getValueDecoder()));
    public static final RedisStrictCommand<Integer> EVAL_INTEGER = new RedisStrictCommand<Integer>("EVAL", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Double> EVAL_DOUBLE = new RedisStrictCommand<Double>("EVAL", new DoubleNullSafeReplayConvertor());
    public static final RedisStrictCommand<Long> EVAL_LONG = new RedisStrictCommand("EVAL");
    public static final RedisStrictCommand<Long> EVAL_LONG_SAFE = new RedisStrictCommand<Long>("EVAL", new LongReplayConvertor());
    public static final RedisStrictCommand<Void> EVAL_VOID = new RedisStrictCommand<Void>("EVAL", new VoidReplayConvertor());
    public static final RedisCommand<Object> EVAL_FIRST_LIST = new RedisCommand<Object>("EVAL", new ListFirstObjectDecoder());
    public static final RedisCommand<Object> EVAL_FIRST_LIST_ENTRY = new RedisCommand<Object>("EVAL", new ListFirstObjectDecoder(new ScoredSortedSetReplayDecoder()));
    public static final RedisCommand<List<Object>> EVAL_LIST = new RedisCommand("EVAL", new ObjectListReplayDecoder());
    public static final RedisCommand<List<Object>> EVAL_LIST_ENTRY = new RedisCommand("EVAL", new ScoredSortedSetReplayDecoder());
    public static final RedisCommand<List<Object>> EVAL_LIST_REVERSE = new RedisCommand("EVAL", new ObjectListReplayDecoder(true));
    public static final RedisCommand<List<Integer>> EVAL_INT_LIST = new RedisCommand<Integer>("EVAL", new ObjectListReplayDecoder(), new IntegerReplayConvertor());
    public static final RedisCommand<List<Long>> EVAL_LONG_LIST = new RedisCommand("EVAL", new ObjectListReplayDecoder());
    public static final RedisCommand<Set<Object>> EVAL_SET = new RedisCommand("EVAL", new ObjectSetReplayDecoder());
    public static final RedisCommand<Object> EVAL_OBJECT = new RedisCommand("EVAL");
    public static final RedisCommand<Object> EVAL_MAP_VALUE = new RedisCommand<Object>("EVAL", new MapValueDecoder());
    public static final RedisCommand<Set<Map.Entry<Object, Object>>> EVAL_MAP_ENTRY = new RedisCommand<Set<Map.Entry<Object, Object>>>("EVAL", new ObjectMapEntryReplayDecoder());
    public static final RedisCommand<Map<Object, Object>> EVAL_MAP = new RedisCommand("EVAL", new ObjectMapReplayDecoder());
    public static final RedisCommand<List<Object>> EVAL_MAP_VALUE_LIST = new RedisCommand<Object>("EVAL", new MapValueDecoder(new ObjectListReplayDecoder()));
    public static final RedisCommand<Set<Object>> EVAL_MAP_VALUE_SET = new RedisCommand<Object>("EVAL", new MapValueDecoder(new ObjectSetReplayDecoder()));
    public static final RedisCommand<Set<Object>> EVAL_MAP_KEY_SET = new RedisCommand<Object>("EVAL", new MapKeyDecoder(new ObjectSetReplayDecoder()));
    public static final RedisStrictCommand<Long> INCR = new RedisStrictCommand("INCR");
    public static final RedisStrictCommand<Long> INCRBY = new RedisStrictCommand("INCRBY");
    public static final RedisStrictCommand<Double> INCRBYFLOAT = new RedisStrictCommand<Double>("INCRBYFLOAT", new DoubleNullSafeReplayConvertor());
    public static final RedisStrictCommand<Long> DECR = new RedisStrictCommand("DECR");
    public static final RedisStrictCommand<Map<String, String>> HELLO = new RedisStrictCommand<Map<String, String>>("HELLO", new StringMapReplayDecoder());
    public static final RedisStrictCommand<Void> AUTH = new RedisStrictCommand<Void>("AUTH", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> SELECT = new RedisStrictCommand<Void>("SELECT", new VoidReplayConvertor());
    public static final RedisStrictCommand<Long> CLIENT_ID = new RedisStrictCommand("CLIENT", "ID");
    public static final RedisStrictCommand<Void> CLIENT_TRACKING = new RedisStrictCommand<Void>("CLIENT", "TRACKING", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> CLIENT_SETNAME = new RedisStrictCommand<Void>("CLIENT", "SETNAME", new VoidReplayConvertor());
    public static final RedisStrictCommand<String> CLIENT_GETNAME = new RedisStrictCommand<Object>("CLIENT", "GETNAME", new ObjectDecoder<String>(new StringDataDecoder()));
    public static final RedisStrictCommand<Void> FLUSHDB = new RedisStrictCommand<Void>("FLUSHDB", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> SWAPDB = new RedisStrictCommand<Void>("SWAPDB", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FLUSHALL = new RedisStrictCommand<Void>("FLUSHALL", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> SAVE = new RedisStrictCommand<Void>("SAVE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Long> LASTSAVE = new RedisStrictCommand("LASTSAVE");
    public static final RedisStrictCommand<Instant> LASTSAVE_INSTANT = new RedisStrictCommand<Instant>("LASTSAVE", new InstantReplyConvertor());
    public static final RedisStrictCommand<Void> BGSAVE = new RedisStrictCommand<Void>("BGSAVE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> BGREWRITEAOF = new RedisStrictCommand<Void>("BGREWRITEAOF", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FLUSHDB_ASYNC = new RedisStrictCommand<Void>("FLUSHDB", "ASYNC", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FLUSHALL_ASYNC = new RedisStrictCommand<Void>("FLUSHALL", "ASYNC", new VoidReplayConvertor());
    public static final RedisStrictCommand<List<String>> KEYS = new RedisStrictCommand<List<String>>("KEYS", new StringListReplayDecoder());
    public static final RedisCommand<List<Object>> MGET = new RedisCommand("MGET", new ObjectListReplayDecoder());
    public static final RedisStrictCommand<Void> MSET = new RedisStrictCommand<Void>("MSET", new VoidReplayConvertor());
    public static final RedisStrictCommand<Boolean> MSETNX = new RedisStrictCommand<Boolean>("MSETNX", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> HPERSIST = new RedisStrictCommand<Boolean>("HPERSIST", new BooleanReplayConvertor());
    public static final RedisCommand<Long> HPTTL = new RedisCommand<Long>("HPTTL", new ListFirstObjectDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Boolean> HSETNX = new RedisStrictCommand<Boolean>("HSETNX", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> HSET = new RedisStrictCommand<Boolean>("HSET", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Void> HSET_VOID = new RedisStrictCommand<Void>("HSET", new VoidReplayConvertor());
    public static final RedisCommand<MapScanResult<Object, Object>> HSCAN = new RedisCommand<Object>("HSCAN", new ListMultiDecoder2(new MapScanResultReplayDecoder(), new ObjectMapReplayDecoder()));
    public static final RedisCommand<Map<Object, Object>> HRANDFIELD = new RedisCommand<Object>("HRANDFIELD", new ObjectMapReplayDecoder(), new EmptyMapConvertor());
    public static final RedisCommand<Map<Object, Object>> HRANDFIELD_V2 = new RedisCommand<Object>("HRANDFIELD", new ListMultiDecoder2(new MapMergeDecoder(), new ObjectMapReplayDecoder()), new EmptyMapConvertor());
    public static final RedisCommand<Set<Object>> HRANDFIELD_KEYS = new RedisCommand<Object>("HRANDFIELD", new MapKeyDecoder(new ObjectSetReplayDecoder()), new EmptySetConvertor());
    public static final RedisCommand<Map<Object, Object>> HGETALL = new RedisCommand("HGETALL", new ObjectMapReplayDecoder());
    public static final RedisCommand<Set<Map.Entry<Object, Object>>> HGETALL_ENTRY = new RedisCommand<Set<Map.Entry<Object, Object>>>("HGETALL", new ObjectMapEntryReplayDecoder());
    public static final RedisCommand<List<Object>> HVALS = new RedisCommand<Object>("HVALS", new MapValueDecoder(new ObjectListReplayDecoder()));
    public static final RedisCommand<Boolean> HEXISTS = new RedisCommand<Boolean>("HEXISTS", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Integer> HLEN = new RedisStrictCommand<Integer>("HLEN", new IntegerReplayConvertor());
    public static final RedisCommand<Integer> HSTRLEN = new RedisCommand<Integer>("HSTRLEN", new IntegerReplayConvertor());
    public static final RedisStrictCommand<Long> HLEN_LONG = new RedisStrictCommand("HLEN");
    public static final RedisCommand<Set<Object>> HKEYS = new RedisCommand<Object>("HKEYS", new MapKeyDecoder(new ObjectSetReplayDecoder()));
    public static final RedisCommand<List<Object>> HMGET = new RedisCommand("HMGET", new ObjectListReplayDecoder());
    public static final RedisCommand<Void> HMSET = new RedisCommand<Void>("HMSET", new VoidReplayConvertor());
    public static final RedisCommand<Object> HGET = new RedisCommand<Object>("HGET", new MapValueDecoder());
    public static final RedisCommand<Long> HDEL = new RedisStrictCommand<Long>("HDEL");
    public static final RedisStrictCommand<Long> DEL = new RedisStrictCommand("DEL");
    public static final RedisStrictCommand<Long> DBSIZE = new RedisStrictCommand("DBSIZE");
    public static final RedisStrictCommand<Boolean> DEL_BOOL = new RedisStrictCommand<Boolean>("DEL", new BooleanNullSafeReplayConvertor());
    public static final RedisStrictCommand<Boolean> DEL_OBJECTS = new RedisStrictCommand<Boolean>("DEL", new BooleanAmountReplayConvertor());
    public static final RedisStrictCommand<Void> DEL_VOID = new RedisStrictCommand<Void>("DEL", new VoidReplayConvertor());
    public static final RedisStrictCommand<Long> UNLINK = new RedisStrictCommand("UNLINK");
    public static final RedisStrictCommand<Boolean> UNLINK_BOOL = new RedisStrictCommand<Boolean>("UNLINK", new BooleanNullSafeReplayConvertor());
    public static final RedisCommand<Object> DUMP = new RedisCommand("DUMP");
    public static final RedisStrictCommand<Void> RESTORE = new RedisStrictCommand<Void>("RESTORE", new VoidReplayConvertor());
    public static final RedisCommand<Object> GET = new RedisCommand("GET");
    public static final RedisCommand<Object> GETEX = new RedisCommand("GETEX");
    public static final RedisCommand<Object> GETRANGE = new RedisCommand("GETRANGE");
    public static final RedisCommand<Long> SETRANGE = new RedisCommand("SETRANGE");
    public static final RedisStrictCommand<Long> GET_LONG = new RedisStrictCommand<Long>("GET", new LongReplayConvertor());
    public static final RedisStrictCommand<Integer> GET_INTEGER = new RedisStrictCommand<Integer>("GET", new IntegerReplayConvertor(0));
    public static final RedisStrictCommand<Double> GET_DOUBLE = new RedisStrictCommand<Double>("GET", new DoubleNullSafeReplayConvertor());
    public static final RedisCommand<Object> GETSET = new RedisCommand("GETSET");
    public static final RedisCommand<Long> GETSET_LONG = new RedisCommand<Long>("GETSET", new LongReplayConvertor());
    public static final RedisCommand<Double> GETSET_DOUBLE = new RedisCommand<Double>("GETSET", new DoubleReplayConvertor(0.0));
    public static final RedisCommand<Void> SET = new RedisCommand<Void>("SET", new VoidReplayConvertor());
    public static final RedisCommand<Void> APPEND = new RedisCommand<Void>("APPEND", new VoidReplayConvertor());
    public static final RedisCommand<Boolean> SET_BOOLEAN = new RedisCommand<Boolean>("SET", new BooleanNotNullReplayConvertor());
    public static final RedisCommand<Boolean> SETNX = new RedisCommand<Boolean>("SETNX", new BooleanReplayConvertor());
    public static final RedisCommand<Void> PSETEX = new RedisCommand<Void>("PSETEX", new VoidReplayConvertor());
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XRANGE = new RedisCommand<Object>("XRANGE", new ListMultiDecoder2(new ObjectMapReplayDecoder2(), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()));
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREVRANGE = new RedisCommand<Map<StreamMessageId, Map<Object, Object>>>("XREVRANGE", XRANGE.getReplayMultiDecoder());
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREAD = new RedisCommand<Object>("XREAD", new ListMultiDecoder2(new StreamResultDecoder(false), new ObjectDecoder<Object>(StringCodec.INSTANCE.getValueDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()));
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREAD_BLOCKING = new RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>>("XREAD", XREAD.getReplayMultiDecoder());
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREAD_V2 = new RedisCommand<Object>("XREAD", new ListMultiDecoder2(new StreamResultDecoderV2(false), new CodecDecoder(), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()), new EmptyMapConvertor());
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREAD_BLOCKING_V2 = new RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>>("XREAD", XREAD_V2.getReplayMultiDecoder());
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREAD_SINGLE_V2 = new RedisCommand<Object>("XREAD", new ListMultiDecoder2(new StreamResultDecoderV2(true), new CodecDecoder(), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()), new EmptyMapConvertor());
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREAD_BLOCKING_SINGLE_V2 = new RedisCommand<Map<StreamMessageId, Map<Object, Object>>>("XREAD", XREAD_SINGLE_V2.getReplayMultiDecoder());
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREAD_SINGLE = new RedisCommand<Object>("XREAD", new ListMultiDecoder2(new StreamResultDecoder(true), new ObjectDecoder<Object>(StringCodec.INSTANCE.getValueDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()));
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREAD_BLOCKING_SINGLE = new RedisCommand<Map<StreamMessageId, Map<Object, Object>>>("XREAD", XREAD_SINGLE.getReplayMultiDecoder());
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREADGROUP_V2 = new RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>>("XREADGROUP", XREAD_V2.getReplayMultiDecoder());
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREADGROUP_BLOCKING_V2 = new RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>>("XREADGROUP", XREADGROUP_V2.getReplayMultiDecoder());
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREADGROUP = new RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>>("XREADGROUP", XREAD.getReplayMultiDecoder());
    public static final RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>> XREADGROUP_BLOCKING = new RedisCommand<Map<String, Map<StreamMessageId, Map<Object, Object>>>>("XREADGROUP", XREADGROUP.getReplayMultiDecoder());
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREADGROUP_SINGLE = new RedisCommand<Object>("XREADGROUP", new ListMultiDecoder2(new StreamResultDecoder(true), new ObjectDecoder<Object>(StringCodec.INSTANCE.getValueDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()));
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREADGROUP_SINGLE_V2 = new RedisCommand<Object>("XREADGROUP", new ListMultiDecoder2(new StreamResultDecoderV2(true), new CodecDecoder(), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()));
    public static final RedisCommand<StreamInfo<Object, Object>> XINFO_GROUPS = new RedisCommand<Object>("XINFO", "GROUPS", new ListMultiDecoder2(new ObjectListReplayDecoder(), new StreamGroupInfoDecoder()));
    public static final RedisCommand<StreamInfo<Object, Object>> XINFO_CONSUMERS = new RedisCommand<Object>("XINFO", "CONSUMERS", new ListMultiDecoder2(new ObjectListReplayDecoder(), new StreamConsumerInfoDecoder()));
    public static final RedisCommand<Object> XCLAIM_IDS = new RedisCommand<Object>("XCLAIM", new ObjectDecoder<Object>(new StreamIdDecoder()));
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XCLAIM = new RedisCommand<Object>("XCLAIM", new ListMultiDecoder2(new ObjectMapReplayDecoder2(), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()));
    public static final RedisCommand<FastAutoClaimResult> XAUTOCLAIM_IDS = new RedisCommand<Object>("XAUTOCLAIM", new ListMultiDecoder2(new FastAutoClaimDecoder(), new ObjectListReplayDecoder(false, new StreamIdDecoder())));
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XAUTOCLAIM = new RedisCommand<Object>("XAUTOCLAIM", new ListMultiDecoder2(new AutoClaimDecoder(), new AutoClaimMapReplayDecoder(), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()));
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREADGROUP_BLOCKING_SINGLE = new RedisCommand<Map<StreamMessageId, Map<Object, Object>>>("XREADGROUP", XREADGROUP_SINGLE.getReplayMultiDecoder());
    public static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> XREADGROUP_BLOCKING_SINGLE_V2 = new RedisCommand<Map<StreamMessageId, Map<Object, Object>>>("XREADGROUP", XREADGROUP_SINGLE_V2.getReplayMultiDecoder());
    public static final Set<RedisCommand> BLOCKING_COMMANDS = new HashSet<RedisCommand>(Arrays.asList(XREAD_BLOCKING_SINGLE, XREAD_BLOCKING, XREADGROUP_BLOCKING_SINGLE, XREADGROUP_BLOCKING, XREAD_BLOCKING_SINGLE_V2, XREAD_BLOCKING_V2, XREADGROUP_BLOCKING_SINGLE_V2, XREADGROUP_BLOCKING_V2));
    public static final RedisStrictCommand<StreamMessageId> XADD = new RedisStrictCommand<StreamMessageId>("XADD", new StreamIdConvertor());
    public static final RedisStrictCommand<Void> XGROUP = new RedisStrictCommand<Void>("XGROUP", new VoidReplayConvertor());
    public static final RedisStrictCommand<Long> XGROUP_LONG = new RedisStrictCommand("XGROUP");
    public static final RedisStrictCommand<Void> XADD_VOID = new RedisStrictCommand<Void>("XADD", new VoidReplayConvertor());
    public static final RedisStrictCommand<Long> XLEN = new RedisStrictCommand("XLEN");
    public static final RedisStrictCommand<Long> XACK = new RedisStrictCommand("XACK");
    public static final RedisStrictCommand<Long> XDEL = new RedisStrictCommand("XDEL");
    public static final RedisStrictCommand<Long> XTRIM = new RedisStrictCommand("XTRIM");
    public static final RedisCommand<Object> XPENDING = new RedisCommand<Object>("XPENDING", new ListMultiDecoder2(new PendingResultDecoder(), new ObjectListReplayDecoder(), new ObjectListReplayDecoder()), new EmptyListConvertor());
    public static final RedisCommand<Object> XPENDING_ENTRIES = new RedisCommand<Object>("XPENDING", new PendingEntryDecoder());
    public static final RedisStrictCommand<Long> TOUCH_LONG = new RedisStrictCommand<Long>("TOUCH", new LongReplayConvertor());
    public static final RedisStrictCommand<Boolean> TOUCH = new RedisStrictCommand<Boolean>("TOUCH", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Long> EXISTS_LONG = new RedisStrictCommand<Long>("EXISTS", new LongReplayConvertor());
    public static final RedisStrictCommand<Boolean> EXISTS = new RedisStrictCommand<Boolean>("EXISTS", new BooleanAmountReplayConvertor());
    public static final RedisStrictCommand<Boolean> NOT_EXISTS = new RedisStrictCommand<Boolean>("EXISTS", new BooleanNumberReplayConvertor(1L));
    public static final RedisStrictCommand<Long> OBJECT_IDLETIME = new RedisStrictCommand<Long>("OBJECT", "IDLETIME", new LongReplayConvertor());
    public static final RedisStrictCommand<Long> MEMORY_USAGE = new RedisStrictCommand<Long>("MEMORY", "USAGE", new LongReplayConvertor());
    public static final RedisStrictCommand<Map<String, String>> MEMORY_STATS = new RedisStrictCommand<Map<String, String>>("MEMORY", "STATS", new StringMapReplayDecoder());
    public static final RedisStrictCommand<Boolean> RENAMENX = new RedisStrictCommand<Boolean>("RENAMENX", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Void> RENAME = new RedisStrictCommand<Void>("RENAME", new VoidReplayConvertor());
    public static final RedisStrictCommand<Boolean> MOVE = new RedisStrictCommand<Boolean>("MOVE", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Boolean> COPY = new RedisStrictCommand<Boolean>("COPY", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Void> MIGRATE = new RedisStrictCommand<Void>("MIGRATE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> QUIT = new RedisStrictCommand<Void>("QUIT", new VoidReplayConvertor());
    public static final RedisStrictCommand<Long> PUBLISH = new RedisStrictCommand("PUBLISH");
    public static final RedisStrictCommand<Long> SPUBLISH = new RedisStrictCommand("SPUBLISH");
    public static final RedisCommand<Long> PUBSUB_NUMSUB = new RedisCommand("PUBSUB", "NUMSUB", new ListObjectDecoder(1));
    public static final RedisCommand<List<String>> PUBSUB_CHANNELS = new RedisStrictCommand<List<String>>("PUBSUB", "CHANNELS", new StringListReplayDecoder());
    public static final RedisCommand<List<String>> PUBSUB_SHARDCHANNELS = new RedisStrictCommand<List<String>>("PUBSUB", "SHARDCHANNELS", new StringListReplayDecoder());
    public static final RedisCommand<Long> PUBSUB_SHARDNUMSUB = new RedisCommand("PUBSUB", "SHARDNUMSUB", new ListObjectDecoder(1));
    public static final RedisCommand<Object> SSUBSCRIBE = new RedisCommand<Object>("SSUBSCRIBE", new PubSubStatusDecoder());
    public static final RedisCommand<Object> SUBSCRIBE = new RedisCommand<Object>("SUBSCRIBE", new PubSubStatusDecoder());
    public static final RedisCommand<Object> UNSUBSCRIBE = new RedisCommand<Object>("UNSUBSCRIBE", new PubSubStatusDecoder());
    public static final RedisCommand<Object> SUNSUBSCRIBE = new RedisCommand<Object>("SUNSUBSCRIBE", new PubSubStatusDecoder());
    public static final RedisCommand<Object> PSUBSCRIBE = new RedisCommand<Object>("PSUBSCRIBE", new PubSubStatusDecoder());
    public static final RedisCommand<Object> PUNSUBSCRIBE = new RedisCommand<Object>("PUNSUBSCRIBE", new PubSubStatusDecoder());
    public static final Set<String> PUBSUB_COMMANDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(PSUBSCRIBE.getName(), SUBSCRIBE.getName(), PUNSUBSCRIBE.getName(), UNSUBSCRIBE.getName(), SSUBSCRIBE.getName(), SUNSUBSCRIBE.getName())));
    public static final Set<String> SCAN_COMMANDS = new HashSet<String>(Arrays.asList(HSCAN.getName(), SCAN.getName(), ZSCAN.getName(), SSCAN.getName()));
    public static final RedisStrictCommand<List<ClusterNodeInfo>> CLUSTER_NODES = new RedisStrictCommand<Object>("CLUSTER", "NODES", new ObjectDecoder<List<ClusterNodeInfo>>(new ClusterNodesDecoder(false)));
    public static final RedisStrictCommand<List<ClusterNodeInfo>> CLUSTER_NODES_SSL = new RedisStrictCommand<Object>("CLUSTER", "NODES", new ObjectDecoder<List<ClusterNodeInfo>>(new ClusterNodesDecoder(true)));
    public static final RedisStrictCommand<Long> TIME_LONG = new RedisStrictCommand<Long>("TIME", new TimeLongObjectDecoder());
    public static final RedisStrictCommand<Time> TIME = new RedisStrictCommand<Time>("TIME", new TimeObjectDecoder());
    public static final RedisStrictCommand<Map<String, String>> CLUSTER_INFO = new RedisStrictCommand<Map<String, String>>("CLUSTER", "INFO", new StringMapDataDecoder());
    public static final RedisStrictCommand<Void> SENTINEL_FAILOVER = new RedisStrictCommand<Void>("SENTINEL", "FAILOVER", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> SENTINEL_REMOVE = new RedisStrictCommand<Void>("SENTINEL", "REMOVE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> SENTINEL_MONITOR = new RedisStrictCommand<Void>("SENTINEL", "MONITOR", new VoidReplayConvertor());
    public static final RedisStrictCommand<RedisURI> SENTINEL_GET_MASTER_ADDR_BY_NAME = new RedisStrictCommand<RedisURI>("SENTINEL", "GET-MASTER-ADDR-BY-NAME", new RedisURIDecoder(false));
    public static final RedisStrictCommand<RedisURI> SENTINEL_GET_MASTER_ADDR_BY_NAME_SSL = new RedisStrictCommand<RedisURI>("SENTINEL", "GET-MASTER-ADDR-BY-NAME", new RedisURIDecoder(true));
    public static final RedisCommand<List<Map<String, String>>> SENTINEL_MASTERS = new RedisCommand<Object>("SENTINEL", "MASTERS", new ListMultiDecoder2(new ListResultReplayDecoder(), new ObjectMapReplayDecoder()));
    public static final RedisCommand<Map<String, String>> SENTINEL_MASTER = new RedisCommand("SENTINEL", "MASTER", new ObjectMapReplayDecoder());
    public static final RedisCommand<List<Map<String, String>>> SENTINEL_SLAVES = new RedisCommand<Object>("SENTINEL", "SLAVES", new ListMultiDecoder2(new ListResultReplayDecoder(), new ObjectMapReplayDecoder()));
    public static final RedisCommand<List<Map<String, String>>> SENTINEL_SENTINELS = new RedisCommand<Object>("SENTINEL", "SENTINELS", new ListMultiDecoder2(new ListResultReplayDecoder(), new ObjectMapReplayDecoder()));
    public static final RedisStrictCommand<String> CLUSTER_MYID = new RedisStrictCommand("CLUSTER", "MYID");
    public static final RedisStrictCommand<Void> CLUSTER_ADDSLOTS = new RedisStrictCommand("CLUSTER", "ADDSLOTS");
    public static final RedisStrictCommand<Void> CLUSTER_REPLICATE = new RedisStrictCommand("CLUSTER", "REPLICATE");
    public static final RedisStrictCommand<Void> CLUSTER_FORGET = new RedisStrictCommand("CLUSTER", "FORGET");
    public static final RedisCommand<Object> CLUSTER_SLOTS = new RedisCommand<Object>("CLUSTER", "SLOTS", new SlotsDecoder());
    public static final RedisStrictCommand<Void> CLUSTER_RESET = new RedisStrictCommand("CLUSTER", "RESET");
    public static final RedisStrictCommand<Void> CLUSTER_DELSLOTS = new RedisStrictCommand("CLUSTER", "DELSLOTS");
    public static final RedisStrictCommand<Void> CLUSTER_FLUSHSLOTS = new RedisStrictCommand("CLUSTER", "FLUSHSLOTS");
    public static final RedisStrictCommand<Long> CLUSTER_COUNTFAILUREREPORTS = new RedisStrictCommand("CLUSTER", "COUNT-FAILURE-REPORTS");
    public static final RedisStrictCommand<Long> CLUSTER_COUNTKEYSINSLOT = new RedisStrictCommand("CLUSTER", "COUNTKEYSINSLOT");
    public static final RedisStrictCommand<List<String>> CLUSTER_GETKEYSINSLOT = new RedisStrictCommand<List<String>>("CLUSTER", "GETKEYSINSLOT", new StringListReplayDecoder());
    public static final RedisStrictCommand<Void> CLUSTER_SETSLOT = new RedisStrictCommand("CLUSTER", "SETSLOT");
    public static final RedisStrictCommand<Void> CLUSTER_MEET = new RedisStrictCommand("CLUSTER", "MEET");
    public static final RedisStrictCommand<List<String>> CONFIG_GET = new RedisStrictCommand<List<String>>("CONFIG", "GET", new StringListReplayDecoder());
    public static final RedisStrictCommand<Map<String, String>> CONFIG_GET_MAP = new RedisStrictCommand("CONFIG", "GET", new ObjectMapReplayDecoder());
    public static final RedisStrictCommand<Void> CONFIG_SET = new RedisStrictCommand<Void>("CONFIG", "SET", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> CONFIG_RESETSTAT = new RedisStrictCommand<Void>("CONFIG", "RESETSTAT", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> CONFIG_REWRITE = new RedisStrictCommand<Void>("CONFIG", "REWRITE", new VoidReplayConvertor());
    public static final RedisStrictCommand<List<String>> CLIENT_LIST = new RedisStrictCommand<List<String>>("CLIENT", "LIST", new StringToListConvertor());
    public static final RedisStrictCommand<Map<String, String>> INFO_ALL = new RedisStrictCommand<Map<String, String>>("INFO", "ALL", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_DEFAULT = new RedisStrictCommand<Map<String, String>>("INFO", "DEFAULT", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_SERVER = new RedisStrictCommand<Map<String, String>>("INFO", "SERVER", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_CLIENTS = new RedisStrictCommand<Map<String, String>>("INFO", "CLIENTS", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_MEMORY = new RedisStrictCommand<Map<String, String>>("INFO", "MEMORY", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_PERSISTENCE = new RedisStrictCommand<Map<String, String>>("INFO", "PERSISTENCE", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_STATS = new RedisStrictCommand<Map<String, String>>("INFO", "STATS", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_REPLICATION = new RedisStrictCommand<Map<String, String>>("INFO", "REPLICATION", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_CPU = new RedisStrictCommand<Map<String, String>>("INFO", "CPU", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_COMMANDSTATS = new RedisStrictCommand<Map<String, String>>("INFO", "COMMANDSTATS", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_CLUSTER = new RedisStrictCommand<Map<String, String>>("INFO", "CLUSTER", new StringMapDataDecoder());
    public static final RedisStrictCommand<Map<String, String>> INFO_KEYSPACE = new RedisStrictCommand<Map<String, String>>("INFO", "KEYSPACE", new StringMapDataDecoder());
    public static final Set<RedisCommand> NO_RETRY_COMMANDS = new HashSet<RedisCommand>(Arrays.asList(SET_BOOLEAN));
    public static final Set<String> NO_RETRY = new HashSet<String>(Arrays.asList(RPOPLPUSH.getName(), LPOP.getName(), RPOP.getName(), LPUSH.getName(), RPUSH.getName(), LPUSHX.getName(), RPUSHX.getName(), GEOADD.getName(), XADD.getName(), APPEND.getName(), DECR.getName(), "DECRBY", INCR.getName(), INCRBY.getName(), ZINCRBY.getName(), "HINCRBYFLOAT", "HINCRBY", "INCRBYFLOAT", SETNX.getName(), MSETNX.getName(), HSETNX.getName()));
    public static final RedisStrictCommand<Long> JSON_STRLEN = new RedisStrictCommand("JSON.STRLEN");
    public static final RedisCommand<List<Long>> JSON_STRLEN_LIST = new RedisCommand<Long>("JSON.STRLEN", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Long> JSON_STRAPPEND = new RedisStrictCommand("JSON.STRAPPEND");
    public static final RedisCommand<List<Long>> JSON_STRAPPEND_LIST = new RedisCommand<Long>("JSON.STRAPPEND", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisCommand<Long> JSON_ARRAPPEND = new RedisCommand<Long>("JSON.ARRAPPEND", new ListFirstObjectDecoder(), new LongReplayConvertor());
    public static final RedisCommand<List<Long>> JSON_ARRAPPEND_LIST = new RedisCommand<Long>("JSON.ARRAPPEND", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Long> JSON_ARRINDEX = new RedisStrictCommand("JSON.ARRINDEX");
    public static final RedisCommand<List<Long>> JSON_ARRINDEX_LIST = new RedisCommand<Long>("JSON.ARRINDEX", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Long> JSON_ARRINSERT = new RedisStrictCommand("JSON.ARRINSERT");
    public static final RedisCommand<List<Long>> JSON_ARRINSERT_LIST = new RedisCommand<Long>("JSON.ARRINSERT", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Long> JSON_ARRLEN = new RedisStrictCommand("JSON.ARRLEN");
    public static final RedisCommand<List<Long>> JSON_ARRLEN_LIST = new RedisCommand<Long>("JSON.ARRLEN", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Object> JSON_ARRPOP = new RedisStrictCommand("JSON.ARRPOP");
    public static final RedisCommand<List<Object>> JSON_ARRPOP_LIST = new RedisCommand("JSON.ARRPOP", new ObjectListReplayDecoder());
    public static final RedisStrictCommand<Long> JSON_ARRTRIM = new RedisStrictCommand("JSON.ARRTRIM");
    public static final RedisCommand<List<Long>> JSON_ARRTRIM_LIST = new RedisCommand<Long>("JSON.ARRTRIM", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisStrictCommand<Long> JSON_OBJLEN = new RedisStrictCommand("JSON.OBJLEN");
    public static final RedisCommand<List<Long>> JSON_OBJLEN_LIST = new RedisCommand<Long>("JSON.OBJLEN", new ObjectListReplayDecoder(), new LongReplayConvertor());
    public static final RedisCommand<List<String>> JSON_OBJKEYS = new RedisCommand<List<String>>("JSON.OBJKEYS", new StringListListReplayDecoder());
    public static final RedisCommand<List<List<String>>> JSON_OBJKEYS_LIST = new RedisCommand<List<String>>("JSON.OBJKEYS", new StringListListReplayDecoder());
    public static final RedisCommand<Boolean> JSON_TOGGLE = new RedisCommand<Boolean>("JSON.TOGGLE", new BooleanReplayConvertor());
    public static final RedisCommand<List<Boolean>> JSON_TOGGLE_LIST = new RedisCommand<Boolean>("JSON.TOGGLE", new ObjectListReplayDecoder(), new BooleanReplayConvertor());
    public static final RedisCommand<JsonType> JSON_TYPE = new RedisCommand<JsonType>("JSON.TYPE", new JsonTypeConvertor());
    public static final RedisStrictCommand<Long> JSON_CLEAR = new RedisStrictCommand("JSON.CLEAR");
    public static final RedisStrictCommand<Object> JSON_GET = new RedisStrictCommand("JSON.GET");
    public static final RedisStrictCommand<Void> JSON_DEL = new RedisStrictCommand<Void>("JSON.DEL", new VoidReplayConvertor());
    public static final RedisStrictCommand<Long> JSON_DEL_LONG = new RedisStrictCommand("JSON.DEL");
    public static final RedisStrictCommand<Boolean> JSON_DEL_BOOLEAN = new RedisStrictCommand<Boolean>("JSON.DEL", new BooleanReplayConvertor());
    public static final RedisStrictCommand<Void> JSON_MSET = new RedisStrictCommand<Void>("JSON.MSET", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> JSON_SET = new RedisStrictCommand<Void>("JSON.SET", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> JSON_MERGE = new RedisStrictCommand<Void>("JSON.MERGE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Boolean> JSON_SET_BOOLEAN = new RedisStrictCommand<Boolean>("JSON.SET", new BooleanNotNullReplayConvertor());
    public static final RedisStrictCommand<Void> FT_CREATE = new RedisStrictCommand<Void>("FT.CREATE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FT_ALIASADD = new RedisStrictCommand<Void>("FT.ALIASADD", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FT_ALIASDEL = new RedisStrictCommand<Void>("FT.ALIASDEL", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FT_ALIASUPDATE = new RedisStrictCommand<Void>("FT.ALIASUPDATE", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FT_ALTER = new RedisStrictCommand<Void>("FT.ALTER", new VoidReplayConvertor());
    public static final RedisCommand<Map<String, Map<String, Object>>> FT_SPELLCHECK = new RedisCommand<Object>("FT.SPELLCHECK", new ListMultiDecoder2(new StreamObjectMapReplayDecoder(), new ObjectMapReplayDecoder(){

        @Override
        public Map decode(List parts, State state) {
            return super.decode(parts.subList(1, parts.size()), state);
        }
    }, new ListFirstObjectDecoder(new EmptyMapConvertor()), new ObjectMapReplayDecoder(true, new CompositeCodec(DoubleCodec.INSTANCE, StringCodec.INSTANCE))));
    public static final RedisStrictCommand<Long> FT_DICTADD = new RedisStrictCommand("FT.DICTADD");
    public static final RedisStrictCommand<Long> FT_DICTDEL = new RedisStrictCommand("FT.DICTDEL");
    public static final RedisStrictCommand<List<String>> FT_DICTDUMP = new RedisStrictCommand<List<String>>("FT.DICTDUMP", new StringListReplayDecoder());
    public static final RedisStrictCommand<List<String>> FT_LIST = new RedisStrictCommand<List<String>>("FT._LIST", new StringListReplayDecoder());
    public static final RedisStrictCommand<Void> FT_DROPINDEX = new RedisStrictCommand<Void>("FT.DROPINDEX", new VoidReplayConvertor());
    public static final RedisStrictCommand<Void> FT_CURSOR_DEL = new RedisStrictCommand<Void>("FT.CURSOR", "DEL", new VoidReplayConvertor());
    public static final RedisStrictCommand<Map<String, String>> FT_CONFIG_GET = new RedisStrictCommand("FT.CONFIG", "GET", new ObjectMapReplayDecoder());
    public static final RedisStrictCommand<Void> FT_CONFIG_SET = new RedisStrictCommand<Void>("FT.CONFIG", "SET", new VoidReplayConvertor());
    public static final RedisCommand<IndexInfo> FT_INFO = new RedisCommand<Object>("FT.INFO", new IndexInfoDecoder());
    public static final RedisCommand<Map<String, List<String>>> FT_SYNDUMP = new RedisCommand<Object>("FT.SYNDUMP", new ListMultiDecoder2(new ObjectMapReplayDecoder(), new ObjectListReplayDecoder()));
    public static final RedisCommand<Void> FT_SYNUPDATE = new RedisCommand<Void>("FT.SYNUPDATE", new VoidReplayConvertor());
}

