/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.redisson.jcache.JCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCachingProvider
implements CachingProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JCachingProvider.class);
    private final Map<ClassLoader, Map<URI, CacheManager>> managers = new ConcurrentHashMap<ClassLoader, Map<URI, CacheManager>>();
    private static final String DEFAULT_URI_PATH = "jsr107-default-config";
    private static URI defaulturi;

    @Override
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        CacheManager oldManager;
        Map value;
        CacheManager manager;
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        if (uri == null) {
            throw new CacheException("Uri is not defined. Can't load default configuration");
        }
        if (classLoader == null) {
            classLoader = this.getDefaultClassLoader();
        }
        if ((manager = (CacheManager)(value = this.managers.computeIfAbsent(classLoader, k -> new ConcurrentHashMap())).get(uri)) != null) {
            return manager;
        }
        Config config = this.loadConfig(uri);
        Redisson redisson = null;
        if (config != null) {
            redisson = (Redisson)Redisson.create(config);
        }
        if ((oldManager = value.putIfAbsent(uri, manager = new JCacheManager(redisson, classLoader, this, properties, uri))) != null) {
            if (redisson != null) {
                redisson.shutdown();
            }
            manager = oldManager;
        }
        LOG.info("JCacheManager created with uri: {} and properties: {}", (Object)uri, (Object)properties);
        return manager;
    }

    private Config loadConfig(URI uri) {
        Config config = null;
        try {
            URL yamlUrl = null;
            yamlUrl = DEFAULT_URI_PATH.equals(uri.getPath()) ? JCachingProvider.class.getResource("/redisson-jcache.yaml") : uri.toURL();
            if (yamlUrl == null) {
                throw new FileNotFoundException("/redisson-jcache.yaml");
            }
            config = Config.fromYAML(yamlUrl);
        }
        catch (JsonProcessingException e) {
            throw new CacheException(e);
        }
        catch (IOException e) {
            try {
                URL jsonUrl = null;
                jsonUrl = DEFAULT_URI_PATH.equals(uri.getPath()) ? JCachingProvider.class.getResource("/redisson-jcache.json") : uri.toURL();
                if (jsonUrl != null) {
                    config = Config.fromJSON(jsonUrl);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return config;
    }

    @Override
    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public URI getDefaultURI() {
        return defaulturi;
    }

    @Override
    public Properties getDefaultProperties() {
        return new Properties();
    }

    @Override
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    @Override
    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    @Override
    public void close() {
        for (ClassLoader classLoader : this.managers.keySet()) {
            this.close(classLoader);
        }
    }

    @Override
    public void close(ClassLoader classLoader) {
        Map<URI, CacheManager> uri2manager = this.managers.remove(classLoader);
        if (uri2manager != null) {
            for (Map.Entry<URI, CacheManager> entry : uri2manager.entrySet()) {
                entry.getValue().close();
                LOG.info("JCacheManager closed with uri: {} and properties: {}", (Object)entry.getKey(), (Object)entry.getValue().getProperties());
            }
        }
    }

    @Override
    public void close(URI uri, ClassLoader classLoader) {
        Map<URI, CacheManager> uri2manager = this.managers.get(classLoader);
        if (uri2manager == null) {
            return;
        }
        CacheManager manager = uri2manager.remove(uri);
        if (manager == null) {
            return;
        }
        manager.close();
        LOG.info("JCacheManager closed with uri: {} and properties: {}", (Object)uri, (Object)manager.getProperties());
        if (uri2manager.isEmpty()) {
            this.managers.remove(classLoader, Collections.emptyMap());
        }
    }

    @Override
    public boolean isSupported(OptionalFeature optionalFeature) {
        return false;
    }

    static {
        try {
            defaulturi = new URI(DEFAULT_URI_PATH);
        }
        catch (URISyntaxException e) {
            throw new CacheException(e);
        }
    }
}

