/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.NodeType;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.ConnectionsHolder;
import org.redisson.connection.IdleConnectionWatcher;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.TrackedConnectionsHolder;
import org.redisson.misc.WrappedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionsEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionsHolder<RedisConnection> connectionsHolder;
    private final ConnectionsHolder<RedisPubSubConnection> pubSubConnectionsHolder;
    private final TrackedConnectionsHolder trackedConnectionsHolder;
    private volatile FreezeReason freezeReason;
    final RedisClient client;
    private final NodeType nodeType;
    private final IdleConnectionWatcher idleConnectionWatcher;
    private final ConnectionManager connectionManager;
    private volatile boolean initialized = false;
    private final WrappedLock lock = new WrappedLock();
    private final Map<RedisConnection, ConnectionsHolder<?>> connection2holder = new ConcurrentHashMap();

    public ClientConnectionsEntry(RedisClient client, int poolMinSize, int poolMaxSize, ConnectionManager connectionManager, NodeType nodeType, MasterSlaveServersConfig config) {
        this.client = client;
        this.connectionsHolder = new ConnectionsHolder(client, poolMaxSize, r -> r.connectAsync(), connectionManager.getServiceManager(), true);
        this.idleConnectionWatcher = connectionManager.getServiceManager().getConnectionWatcher();
        this.connectionManager = connectionManager;
        this.nodeType = nodeType;
        this.pubSubConnectionsHolder = new ConnectionsHolder(client, config.getSubscriptionConnectionPoolSize(), r -> r.connectPubSubAsync(), connectionManager.getServiceManager(), false);
        if (config.getSubscriptionConnectionPoolSize() > 0) {
            this.idleConnectionWatcher.add(this, config.getSubscriptionConnectionMinimumIdleSize(), config.getSubscriptionConnectionPoolSize(), this.pubSubConnectionsHolder);
        }
        this.idleConnectionWatcher.add(this, poolMinSize, poolMaxSize, this.connectionsHolder);
        this.trackedConnectionsHolder = new TrackedConnectionsHolder(this.connectionsHolder);
    }

    public CompletableFuture<Void> initConnections(int minimumIdleSize) {
        return this.connectionsHolder.initConnections(minimumIdleSize);
    }

    public CompletableFuture<Void> initPubSubConnections(int minimumIdleSize) {
        return this.pubSubConnectionsHolder.initConnections(minimumIdleSize);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean isInited) {
        this.initialized = isInited;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public CompletableFuture<Void> shutdownAsync() {
        this.idleConnectionWatcher.remove(this);
        return this.client.shutdownAsync().toCompletableFuture();
    }

    public RedisClient getClient() {
        return this.client;
    }

    public boolean isFreezed() {
        return this.freezeReason != null;
    }

    public void setFreezeReason(FreezeReason freezeReason) {
        this.freezeReason = freezeReason;
        if (freezeReason != null) {
            this.initialized = false;
        }
    }

    public FreezeReason getFreezeReason() {
        return this.freezeReason;
    }

    public WrappedLock getLock() {
        return this.lock;
    }

    public void reattachPubSub() {
        this.pubSubConnectionsHolder.getFreeConnectionsCounter().removeListeners();
        for (RedisPubSubConnection connection : this.pubSubConnectionsHolder.getAllConnections()) {
            connection.closeAsync();
            this.connectionManager.getSubscribeService().reattachPubSub(connection);
        }
        this.log.debug("{} PubSub connections to {} have been closed", (Object)this.pubSubConnectionsHolder.getAllConnections().size(), (Object)this.client.getAddr());
        this.pubSubConnectionsHolder.getFreeConnections().clear();
        this.pubSubConnectionsHolder.getAllConnections().clear();
    }

    public void nodeDown() {
        this.nodeDown(this.connectionsHolder);
        this.reattachPubSub();
    }

    protected final void nodeDown(ConnectionsHolder<RedisConnection> connectionsHolder) {
        connectionsHolder.getFreeConnectionsCounter().removeListeners();
        for (RedisConnection connection : connectionsHolder.getAllConnections()) {
            connection.closeAsync();
            this.reattachBlockingQueue(connection.getCurrentCommand());
        }
        this.log.debug("{} connections to {} have been closed", (Object)connectionsHolder.getAllConnections().size(), (Object)this.client.getAddr());
        connectionsHolder.getFreeConnections().clear();
        connectionsHolder.getAllConnections().clear();
    }

    void reattachBlockingQueue(CommandData<?, ?> commandData) {
        MasterSlaveEntry entry;
        if (commandData == null || !commandData.isBlockingCommand() || commandData.getPromise().isDone()) {
            return;
        }
        String key = null;
        for (int i = 0; i < commandData.getParams().length; ++i) {
            Object param = commandData.getParams()[i];
            if (!"STREAMS".equals(param)) continue;
            Object k = commandData.getParams()[i + 1];
            if (k instanceof byte[]) {
                key = new String((byte[])k, StandardCharsets.UTF_8);
                break;
            }
            key = (String)k;
            break;
        }
        if (key == null) {
            Object k = commandData.getParams()[0];
            key = k instanceof byte[] ? new String((byte[])k, StandardCharsets.UTF_8) : (String)k;
        }
        if ((entry = this.connectionManager.getEntry(key)) == null) {
            this.log.debug("Unable to get entry for {} during blocking command reattach {}", (Object)key, (Object)commandData);
            this.connectionManager.getServiceManager().newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
            return;
        }
        CompletableFuture<RedisConnection> newConnectionFuture = entry.connectionWriteOp(commandData.getCommand());
        newConnectionFuture.whenComplete((newConnection, e) -> {
            if (e != null) {
                this.log.debug("Unable to acquire connection during blocking command reattach {}", (Object)commandData, e);
                this.connectionManager.getServiceManager().newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
                return;
            }
            commandData.getPromise().whenComplete((r, ex) -> entry.releaseWrite((RedisConnection)newConnection));
            ChannelFuture channelFuture = newConnection.send(commandData);
            channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess()) {
                    this.log.debug("Unable to send a command during blocking command reattach {}", (Object)commandData, (Object)future.cause());
                    this.connectionManager.getServiceManager().newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
                    return;
                }
                this.log.info("command '{}' has been resent to '{}'", (Object)commandData, (Object)newConnection.getRedisClient());
            }));
        });
    }

    public ConnectionsHolder<RedisConnection> getConnectionsHolder() {
        return this.connectionsHolder;
    }

    public TrackedConnectionsHolder getTrackedConnectionsHolder() {
        return this.trackedConnectionsHolder;
    }

    public ConnectionsHolder<RedisPubSubConnection> getPubSubConnectionsHolder() {
        return this.pubSubConnectionsHolder;
    }

    public void addHandler(RedisConnection connection, ConnectionsHolder<?> handler) {
        this.connection2holder.put(connection, handler);
    }

    public <T extends RedisConnection> void returnConnection(T connection) {
        ConnectionsHolder<?> handler = connection.getUsage() > 1 ? this.connection2holder.get(connection) : this.connection2holder.remove(connection);
        if (handler != null) {
            handler.releaseConnection(this, connection);
        }
    }

    public String toString() {
        return "ClientConnectionsEntry{connectionsHolder=" + this.connectionsHolder + ", pubSubConnectionsHolder=" + this.pubSubConnectionsHolder + ", freezeReason=" + (Object)((Object)this.freezeReason) + ", client=" + this.client + ", nodeType=" + (Object)((Object)this.nodeType) + ", initialized=" + this.initialized + '}';
    }

    public static enum FreezeReason {
        MANAGER,
        RECONNECT;

    }
}

