/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class URLBuilder {
    private static URLStreamHandlerFactory currentFactory;
    private static final URLStreamHandlerFactory newFactory;

    public static void restoreURLFactory() {
        try {
            Field field = URL.class.getDeclaredField("factory");
            field.setAccessible(true);
            field.set(null, currentFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void replaceURLFactory() {
        try {
            Field field = URL.class.getDeclaredField("factory");
            field.setAccessible(true);
            currentFactory = (URLStreamHandlerFactory)field.get(null);
            if (currentFactory != null && currentFactory != newFactory) {
                field.set(null, null);
            }
            if (currentFactory != newFactory) {
                URL.setURLStreamHandlerFactory(newFactory);
            } else {
                currentFactory = null;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static InetSocketAddress toAddress(String url) {
        String[] parts = url.split(":");
        if (parts.length - 1 >= 3) {
            String port = parts[parts.length - 1];
            String newPort = port.split("[^\\d]")[0];
            String host = url.replace(":" + port, "");
            return new InetSocketAddress(host, (int)Integer.valueOf(newPort));
        }
        String port = parts[parts.length - 1];
        String newPort = port.split("[^\\d]")[0];
        String host = url.replace(":" + port, "");
        return new InetSocketAddress(host, (int)Integer.valueOf(newPort));
    }

    public static URL create(String url) {
        URLBuilder.replaceURLFactory();
        try {
            String[] parts = url.split(":");
            if (parts.length - 1 >= 3) {
                String port = parts[parts.length - 1];
                String newPort = port.split("[^\\d]")[0];
                String host = url.replace(":" + port, "");
                URL uRL = new URL("redis://[" + host + "]:" + newPort);
                return uRL;
            }
            String port = parts[parts.length - 1];
            String newPort = port.split("[^\\d]")[0];
            String host = url.replace(":" + port, "");
            URL uRL = new URL("redis://" + host + ":" + newPort);
            return uRL;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            URLBuilder.restoreURLFactory();
        }
    }

    static {
        newFactory = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if ("redis".equals(protocol)) {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        protected boolean equals(URL u1, URL u2) {
                            return u1.toString().equals(u2.toString());
                        }

                        @Override
                        protected int hashCode(URL u) {
                            return u.toString().hashCode();
                        }
                    };
                }
                if (currentFactory != null) {
                    return currentFactory.createURLStreamHandler(protocol);
                }
                return null;
            }
        };
    }
}

