/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.concurrent.TimeUnit;

public class LocalCachedMapOptions {
    private boolean invalidateEntryOnChange;
    private EvictionPolicy evictionPolicy;
    private int cacheSize;
    private long timeToLiveInMillis;
    private long maxIdleInMillis;

    private LocalCachedMapOptions() {
    }

    protected LocalCachedMapOptions(LocalCachedMapOptions copy) {
        this.invalidateEntryOnChange = copy.invalidateEntryOnChange;
        this.evictionPolicy = copy.evictionPolicy;
        this.cacheSize = copy.cacheSize;
        this.timeToLiveInMillis = copy.timeToLiveInMillis;
        this.maxIdleInMillis = copy.maxIdleInMillis;
    }

    public static LocalCachedMapOptions defaults() {
        return new LocalCachedMapOptions().cacheSize(0).timeToLive(0L).maxIdle(0L).evictionPolicy(EvictionPolicy.NONE).invalidateEntryOnChange(true);
    }

    public boolean isInvalidateEntryOnChange() {
        return this.invalidateEntryOnChange;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getTimeToLiveInMillis() {
        return this.timeToLiveInMillis;
    }

    public long getMaxIdleInMillis() {
        return this.maxIdleInMillis;
    }

    public LocalCachedMapOptions cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public LocalCachedMapOptions invalidateEntryOnChange(boolean value) {
        this.invalidateEntryOnChange = value;
        return this;
    }

    public LocalCachedMapOptions evictionPolicy(EvictionPolicy evictionPolicy) {
        if (evictionPolicy == null) {
            throw new NullPointerException("evictionPolicy can't be null");
        }
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public LocalCachedMapOptions timeToLive(long timeToLiveInMillis) {
        this.timeToLiveInMillis = timeToLiveInMillis;
        return this;
    }

    public LocalCachedMapOptions timeToLive(long timeToLive, TimeUnit timeUnit) {
        return this.timeToLive(timeUnit.toMillis(timeToLive));
    }

    public LocalCachedMapOptions maxIdle(long maxIdleInMillis) {
        this.maxIdleInMillis = maxIdleInMillis;
        return this;
    }

    public LocalCachedMapOptions maxIdle(long maxIdle, TimeUnit timeUnit) {
        return this.timeToLive(timeUnit.toMillis(maxIdle));
    }

    public static enum EvictionPolicy {
        NONE,
        LRU,
        LFU,
        SOFT;

    }
}

