/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.PubSubEntry;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RBlockingFairQueue;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonBlockingFairQueue<V>
extends RedissonBlockingQueue<V>
implements RBlockingFairQueue<V> {
    public static final long TIMEOUT_SECONDS = 30L;
    private final UUID id;
    private final AtomicInteger instances = new AtomicInteger();
    private final SemaphorePubSub semaphorePubSub;

    protected RedissonBlockingFairQueue(CommandExecutor commandExecutor, String name, SemaphorePubSub semaphorePubSub, UUID id) {
        super(commandExecutor, name);
        this.semaphorePubSub = semaphorePubSub;
        this.id = id;
        this.instances.incrementAndGet();
    }

    protected RedissonBlockingFairQueue(Codec codec, CommandExecutor commandExecutor, String name, SemaphorePubSub semaphorePubSub, UUID id) {
        super(codec, commandExecutor, name);
        this.semaphorePubSub = semaphorePubSub;
        this.id = id;
        this.instances.incrementAndGet();
    }

    private String getIdsListName() {
        return this.suffixName(this.getName(), "list");
    }

    private String getTimeoutName() {
        return this.suffixName(this.getName(), "timeout");
    }

    private String getChannelName() {
        return this.suffixName(this.getName(), this.getCurrentId() + ":channel");
    }

    private RedissonLockEntry getEntry() {
        return (RedissonLockEntry)this.semaphorePubSub.getEntry(this.getName());
    }

    private RFuture<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    private void unsubscribe(RFuture<RedissonLockEntry> future) {
        this.semaphorePubSub.unsubscribe((PubSubEntry)future.getNow(), this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.getIdsListName(), this.getTimeoutName());
    }

    private Long tryAcquire() {
        return this.get(this.tryAcquireAsync());
    }

    private RFuture<Long> tryAcquireAsync() {
        long timeout = System.currentTimeMillis() + 30000L;
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local timeout = redis.call('get', KEYS[3]);if timeout ~= false and tonumber(timeout) <= tonumber(ARGV[3]) then redis.call('lpop', KEYS[2]); local nextValue = redis.call('lindex', KEYS[2], 0); if nextValue ~= false and nextValue ~= ARGV[1] then redis.call('set', KEYS[3], ARGV[2]);redis.call('publish', '{' .. KEYS[1] .. '}:' .. nextValue .. ':channel', 1);end; end; local items = redis.call('lrange', KEYS[2], 0, -1) local found = false; for i=1,#items do if items[i] == ARGV[1] then found = true; break;end; end; if found == false then redis.call('lpush', KEYS[2], ARGV[1]); end; local value = redis.call('lindex', KEYS[2], 0); if value == ARGV[1] then redis.call('set', KEYS[3], ARGV[2]);local size = redis.call('llen', KEYS[2]); if size > 1 then redis.call('lpop', KEYS[2]);redis.call('rpush', KEYS[2], value);local nextValue = redis.call('lindex', KEYS[2], 0); redis.call('publish', '{' .. KEYS[1] .. '}:' .. nextValue .. ':channel', 1);end; return nil;end;return tonumber(timeout) - tonumber(ARGV[3]);", Arrays.asList(this.getName(), this.getIdsListName(), this.getTimeoutName()), this.getCurrentId(), timeout, System.currentTimeMillis());
    }

    private String getCurrentId() {
        return this.id.toString();
    }

    @Override
    public V take() throws InterruptedException {
        Long currentTimeout = this.tryAcquire();
        if (currentTimeout == null) {
            return super.take();
        }
        RFuture<RedissonLockEntry> future = this.subscribe();
        this.commandExecutor.syncSubscription(future);
        try {
            while (true) {
                if ((currentTimeout = this.tryAcquire()) == null) {
                    Object v = super.take();
                    return v;
                }
                this.getEntry().getLatch().tryAcquire(currentTimeout, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public void destroy() {
        if (this.instances.decrementAndGet() == 0) {
            this.get(this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID_WITH_VALUES, "for i = 1, #ARGV, 1 do redis.call('lrem', KEYS[1], 0, ARGV[i]);end; ", Collections.singletonList(this.getIdsListName()), this.getCurrentId()));
        }
    }

    @Override
    public RFuture<V> takeAsync() {
        final RPromise promise = this.newPromise();
        RFuture<Long> tryAcquireFuture = this.tryAcquireAsync();
        tryAcquireFuture.addListener(new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Long currentTimeout = future.getNow();
                if (currentTimeout == null) {
                    RFuture pollFuture = RedissonBlockingFairQueue.super.takeAsync();
                    pollFuture.addListener(new FutureListener<V>(){

                        @Override
                        public void operationComplete(Future<V> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            promise.trySuccess(future.getNow());
                        }
                    });
                } else {
                    final RFuture subscribeFuture = RedissonBlockingFairQueue.this.subscribe();
                    final AtomicReference futureRef = new AtomicReference();
                    subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                        @Override
                        public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            if (futureRef.get() != null) {
                                ((Timeout)futureRef.get()).cancel();
                            }
                            RedissonBlockingFairQueue.this.tryTakeAsync(subscribeFuture, promise);
                        }
                    });
                }
            }
        });
        return promise;
    }

    @Override
    public V poll() {
        Long currentTimeout = this.tryAcquire();
        if (currentTimeout == null) {
            return super.poll();
        }
        return null;
    }

    @Override
    public RFuture<V> pollAsync() {
        final RPromise promise = this.newPromise();
        RFuture<Long> tryAcquireFuture = this.tryAcquireAsync();
        tryAcquireFuture.addListener(new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Long currentTimeout = future.getNow();
                if (currentTimeout == null) {
                    RFuture pollFuture = RedissonBlockingFairQueue.super.pollAsync();
                    pollFuture.addListener(new FutureListener<V>(){

                        @Override
                        public void operationComplete(Future<V> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            promise.trySuccess(future.getNow());
                        }
                    });
                } else {
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        Long currentTimeout = this.tryAcquire();
        if (currentTimeout == null) {
            long spentTime = System.currentTimeMillis() - startTime;
            long remainTime = unit.toMillis(timeout) - spentTime;
            if (remainTime > 0L) {
                return super.poll(remainTime, TimeUnit.MILLISECONDS);
            }
            return null;
        }
        RFuture<RedissonLockEntry> future = this.subscribe();
        long spentTime = System.currentTimeMillis() - startTime;
        long remainTime = unit.toMillis(timeout) - spentTime;
        if (!future.awaitUninterruptibly(remainTime, TimeUnit.MILLISECONDS)) {
            return null;
        }
        try {
            do {
                if ((currentTimeout = this.tryAcquire()) == null) {
                    spentTime = System.currentTimeMillis() - startTime;
                    remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        Object v = super.poll(remainTime, TimeUnit.MILLISECONDS);
                        return v;
                    }
                    V v = null;
                    return v;
                }
                spentTime = System.currentTimeMillis() - startTime;
                remainTime = unit.toMillis(timeout) - spentTime;
            } while ((remainTime = Math.min(remainTime, currentTimeout)) > 0L && this.getEntry().getLatch().tryAcquire(remainTime, TimeUnit.MILLISECONDS));
            V v = null;
            return v;
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<V> pollAsync(final long timeout, final TimeUnit unit) {
        final long startTime = System.currentTimeMillis();
        final RPromise promise = this.newPromise();
        RFuture<Long> tryAcquireFuture = this.tryAcquireAsync();
        tryAcquireFuture.addListener(new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Long currentTimeout = future.getNow();
                if (currentTimeout == null) {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        RFuture pollFuture = RedissonBlockingFairQueue.super.pollAsync(remainTime, TimeUnit.MILLISECONDS);
                        pollFuture.addListener(new FutureListener<V>(){

                            @Override
                            public void operationComplete(Future<V> future) throws Exception {
                                if (!future.isSuccess()) {
                                    promise.tryFailure(future.cause());
                                    return;
                                }
                                promise.trySuccess(future.getNow());
                            }
                        });
                    } else {
                        promise.trySuccess(null);
                    }
                } else {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if ((remainTime = Math.min(remainTime, currentTimeout)) <= 0L) {
                        promise.trySuccess(null);
                        return;
                    }
                    final RFuture subscribeFuture = RedissonBlockingFairQueue.this.subscribe();
                    final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                    subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                        @Override
                        public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            if (futureRef.get() != null) {
                                ((Timeout)futureRef.get()).cancel();
                            }
                            RedissonBlockingFairQueue.this.tryPollAsync(startTime, timeout, unit, subscribeFuture, promise);
                        }
                    });
                    if (!subscribeFuture.isDone()) {
                        Timeout scheduledFuture = RedissonBlockingFairQueue.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                            @Override
                            public void run(Timeout timeout) throws Exception {
                                if (!subscribeFuture.isDone()) {
                                    subscribeFuture.cancel(false);
                                    promise.trySuccess(null);
                                }
                            }
                        }, remainTime, TimeUnit.MILLISECONDS);
                        futureRef.set(scheduledFuture);
                    }
                }
            }
        });
        return promise;
    }

    private void tryTakeAsync(final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<V> promise) {
        if (promise.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        RFuture<Long> tryAcquireFuture = this.tryAcquireAsync();
        tryAcquireFuture.addListener(new FutureListener<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                    promise.tryFailure(future.cause());
                    return;
                }
                Long currentTimeout = future.getNow();
                if (currentTimeout == null) {
                    RFuture pollFuture = RedissonBlockingFairQueue.super.takeAsync();
                    pollFuture.addListener(new FutureListener<V>(){

                        @Override
                        public void operationComplete(Future<V> future) throws Exception {
                            RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            promise.trySuccess(future.getNow());
                        }
                    });
                } else {
                    RedissonLockEntry entry;
                    RedissonLockEntry redissonLockEntry = entry = RedissonBlockingFairQueue.this.getEntry();
                    synchronized (redissonLockEntry) {
                        if (entry.getLatch().tryAcquire()) {
                            RedissonBlockingFairQueue.this.tryTakeAsync(subscribeFuture, promise);
                        } else {
                            final AtomicBoolean executed = new AtomicBoolean();
                            final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                            final Runnable listener = new Runnable(){

                                @Override
                                public void run() {
                                    executed.set(true);
                                    if (futureRef.get() != null) {
                                        ((Timeout)futureRef.get()).cancel();
                                    }
                                    RedissonBlockingFairQueue.this.tryTakeAsync(subscribeFuture, promise);
                                }
                            };
                            entry.addListener(listener);
                            if (!executed.get()) {
                                Timeout scheduledFuture = RedissonBlockingFairQueue.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run(Timeout t) throws Exception {
                                        RedissonLockEntry redissonLockEntry = entry;
                                        synchronized (redissonLockEntry) {
                                            if (entry.removeListener(listener)) {
                                                RedissonBlockingFairQueue.this.tryTakeAsync(subscribeFuture, promise);
                                            }
                                        }
                                    }
                                }, currentTimeout, TimeUnit.MILLISECONDS);
                                futureRef.set(scheduledFuture);
                            }
                        }
                    }
                }
            }
        });
    }

    private void tryPollAsync(final long startTime, final long timeout, final TimeUnit unit, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<V> promise) {
        if (promise.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        long spentTime = System.currentTimeMillis() - startTime;
        long remainTime = unit.toMillis(timeout) - spentTime;
        if (remainTime <= 0L) {
            this.unsubscribe(subscribeFuture);
            promise.trySuccess(null);
            return;
        }
        RFuture<Long> tryAcquireFuture = this.tryAcquireAsync();
        tryAcquireFuture.addListener(new FutureListener<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                    promise.tryFailure(future.cause());
                    return;
                }
                Long currentTimeout = future.getNow();
                if (currentTimeout == null) {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        RFuture pollFuture = RedissonBlockingFairQueue.super.pollAsync(remainTime, TimeUnit.MILLISECONDS);
                        pollFuture.addListener(new FutureListener<V>(){

                            @Override
                            public void operationComplete(Future<V> future) throws Exception {
                                RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                                if (!future.isSuccess()) {
                                    promise.tryFailure(future.cause());
                                    return;
                                }
                                promise.trySuccess(future.getNow());
                            }
                        });
                    } else {
                        RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                        promise.trySuccess(null);
                    }
                } else {
                    RedissonLockEntry entry;
                    RedissonLockEntry redissonLockEntry = entry = RedissonBlockingFairQueue.this.getEntry();
                    synchronized (redissonLockEntry) {
                        if (entry.getLatch().tryAcquire()) {
                            RedissonBlockingFairQueue.this.tryPollAsync(startTime, timeout, unit, subscribeFuture, promise);
                        } else {
                            final AtomicBoolean executed = new AtomicBoolean();
                            final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                            final Runnable listener = new Runnable(){

                                @Override
                                public void run() {
                                    executed.set(true);
                                    if (futureRef.get() != null) {
                                        ((Timeout)futureRef.get()).cancel();
                                    }
                                    RedissonBlockingFairQueue.this.tryPollAsync(startTime, timeout, unit, subscribeFuture, promise);
                                }
                            };
                            entry.addListener(listener);
                            if (!executed.get()) {
                                long spentTime = System.currentTimeMillis() - startTime;
                                long remainTime = unit.toMillis(timeout) - spentTime;
                                Timeout scheduledFuture = RedissonBlockingFairQueue.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run(Timeout t) throws Exception {
                                        RedissonLockEntry redissonLockEntry = entry;
                                        synchronized (redissonLockEntry) {
                                            if (entry.removeListener(listener)) {
                                                RedissonBlockingFairQueue.this.tryPollAsync(startTime, timeout, unit, subscribeFuture, promise);
                                            }
                                        }
                                    }
                                }, remainTime, TimeUnit.MILLISECONDS);
                                futureRef.set(scheduledFuture);
                            }
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        Long currentTimeout = this.tryAcquire();
        if (currentTimeout == null) {
            long spentTime = System.currentTimeMillis() - startTime;
            long remainTime = unit.toMillis(timeout) - spentTime;
            if (remainTime > 0L) {
                return super.pollLastAndOfferFirstTo(queueName, remainTime, TimeUnit.MILLISECONDS);
            }
            return null;
        }
        RFuture<RedissonLockEntry> future = this.subscribe();
        long spentTime = System.currentTimeMillis() - startTime;
        long remainTime = unit.toMillis(timeout) - spentTime;
        if (!future.awaitUninterruptibly(remainTime, TimeUnit.MILLISECONDS)) {
            return null;
        }
        try {
            do {
                if ((currentTimeout = this.tryAcquire()) == null) {
                    spentTime = System.currentTimeMillis() - startTime;
                    remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        Object v = super.pollLastAndOfferFirstTo(queueName, remainTime, TimeUnit.MILLISECONDS);
                        return v;
                    }
                    V v = null;
                    return v;
                }
                spentTime = System.currentTimeMillis() - startTime;
                remainTime = unit.toMillis(timeout) - spentTime;
            } while ((remainTime = Math.min(remainTime, currentTimeout)) > 0L && this.getEntry().getLatch().tryAcquire(remainTime, TimeUnit.MILLISECONDS));
            V v = null;
            return v;
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(final String queueName, final long timeout, final TimeUnit unit) {
        final long startTime = System.currentTimeMillis();
        final RPromise promise = this.newPromise();
        RFuture<Long> tryAcquireFuture = this.tryAcquireAsync();
        tryAcquireFuture.addListener(new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Long currentTimeout = future.getNow();
                if (currentTimeout == null) {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        RFuture pollFuture = RedissonBlockingFairQueue.super.pollLastAndOfferFirstToAsync(queueName, remainTime, TimeUnit.MILLISECONDS);
                        pollFuture.addListener(new FutureListener<V>(){

                            @Override
                            public void operationComplete(Future<V> future) throws Exception {
                                if (!future.isSuccess()) {
                                    promise.tryFailure(future.cause());
                                    return;
                                }
                                promise.trySuccess(future.getNow());
                            }
                        });
                    } else {
                        promise.trySuccess(null);
                    }
                } else {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if ((remainTime = Math.min(remainTime, currentTimeout)) <= 0L) {
                        promise.trySuccess(null);
                        return;
                    }
                    final RFuture subscribeFuture = RedissonBlockingFairQueue.this.subscribe();
                    final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                    subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                        @Override
                        public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            if (futureRef.get() != null) {
                                ((Timeout)futureRef.get()).cancel();
                            }
                            RedissonBlockingFairQueue.this.tryPollLastAndOfferFirstToAsync(startTime, timeout, unit, subscribeFuture, promise, queueName);
                        }
                    });
                    if (!subscribeFuture.isDone()) {
                        Timeout scheduledFuture = RedissonBlockingFairQueue.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                            @Override
                            public void run(Timeout timeout) throws Exception {
                                if (!subscribeFuture.isDone()) {
                                    subscribeFuture.cancel(false);
                                    promise.trySuccess(null);
                                }
                            }
                        }, remainTime, TimeUnit.MILLISECONDS);
                        futureRef.set(scheduledFuture);
                    }
                }
            }
        });
        return promise;
    }

    private void tryPollLastAndOfferFirstToAsync(final long startTime, final long timeout, final TimeUnit unit, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<V> promise, final String queueName) {
        if (promise.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        long spentTime = System.currentTimeMillis() - startTime;
        long remainTime = unit.toMillis(timeout) - spentTime;
        if (remainTime <= 0L) {
            this.unsubscribe(subscribeFuture);
            promise.trySuccess(null);
            return;
        }
        RFuture<Long> tryAcquireFuture = this.tryAcquireAsync();
        tryAcquireFuture.addListener(new FutureListener<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                    promise.tryFailure(future.cause());
                    return;
                }
                Long currentTimeout = future.getNow();
                if (currentTimeout == null) {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        RFuture pollFuture = RedissonBlockingFairQueue.super.pollLastAndOfferFirstToAsync(queueName, remainTime, TimeUnit.MILLISECONDS);
                        pollFuture.addListener(new FutureListener<V>(){

                            @Override
                            public void operationComplete(Future<V> future) throws Exception {
                                RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                                if (!future.isSuccess()) {
                                    promise.tryFailure(future.cause());
                                    return;
                                }
                                promise.trySuccess(future.getNow());
                            }
                        });
                    } else {
                        RedissonBlockingFairQueue.this.unsubscribe(subscribeFuture);
                        promise.trySuccess(null);
                    }
                } else {
                    RedissonLockEntry entry;
                    RedissonLockEntry redissonLockEntry = entry = RedissonBlockingFairQueue.this.getEntry();
                    synchronized (redissonLockEntry) {
                        if (entry.getLatch().tryAcquire()) {
                            RedissonBlockingFairQueue.this.tryPollAsync(startTime, timeout, unit, subscribeFuture, promise);
                        } else {
                            final AtomicBoolean executed = new AtomicBoolean();
                            final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                            final Runnable listener = new Runnable(){

                                @Override
                                public void run() {
                                    executed.set(true);
                                    if (futureRef.get() != null) {
                                        ((Timeout)futureRef.get()).cancel();
                                    }
                                    RedissonBlockingFairQueue.this.tryPollLastAndOfferFirstToAsync(startTime, timeout, unit, subscribeFuture, promise, queueName);
                                }
                            };
                            entry.addListener(listener);
                            if (!executed.get()) {
                                long spentTime = System.currentTimeMillis() - startTime;
                                long remainTime = unit.toMillis(timeout) - spentTime;
                                Timeout scheduledFuture = RedissonBlockingFairQueue.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run(Timeout t) throws Exception {
                                        RedissonLockEntry redissonLockEntry = entry;
                                        synchronized (redissonLockEntry) {
                                            if (entry.removeListener(listener)) {
                                                RedissonBlockingFairQueue.this.tryPollLastAndOfferFirstToAsync(startTime, timeout, unit, subscribeFuture, promise, queueName);
                                            }
                                        }
                                    }
                                }, remainTime, TimeUnit.MILLISECONDS);
                                futureRef.set(scheduledFuture);
                            }
                        }
                    }
                }
            }
        });
    }
}

