/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.misc.URLBuilder;

public class ClusterNodeInfo {
    private final String nodeInfo;
    private String nodeId;
    private URL address;
    private final Set<Flag> flags = new HashSet<Flag>();
    private String slaveOf;
    private final Set<ClusterSlotRange> slotRanges = new HashSet<ClusterSlotRange>();

    public ClusterNodeInfo(String nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public URL getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = URLBuilder.create(address);
    }

    public void addSlotRange(ClusterSlotRange range) {
        this.slotRanges.add(range);
    }

    public Set<ClusterSlotRange> getSlotRanges() {
        return this.slotRanges;
    }

    public boolean containsFlag(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public void addFlag(Flag flag) {
        this.flags.add(flag);
    }

    public String getSlaveOf() {
        return this.slaveOf;
    }

    public void setSlaveOf(String slaveOf) {
        this.slaveOf = slaveOf;
    }

    public String getNodeInfo() {
        return this.nodeInfo;
    }

    public String toString() {
        return "ClusterNodeInfo [nodeId=" + this.nodeId + ", address=" + this.address + ", flags=" + this.flags + ", slaveOf=" + this.slaveOf + ", slotRanges=" + this.slotRanges + "]";
    }

    public static enum Flag {
        NOFLAGS,
        SLAVE,
        MASTER,
        MYSELF,
        FAIL,
        HANDSHAKE,
        NOADDR;

    }
}

