/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.map;

import java.util.Collection;
import java.util.Map;
import org.redisson.api.MapOptions;
import org.redisson.api.map.MapWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableMapWriter<K, V>
implements MapWriter<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RetryableMapWriter.class);
    private final MapOptions<K, V> options;
    private final MapWriter<K, V> mapWriter;

    public RetryableMapWriter(MapOptions<K, V> options, MapWriter<K, V> mapWriter) {
        this.options = options;
        this.mapWriter = mapWriter;
    }

    @Override
    public void write(Map<K, V> addedMap) {
        int leftAddAttempts = Math.max(1, this.options.getWriterRetryAttempts());
        while (leftAddAttempts > 0) {
            try {
                this.mapWriter.write(addedMap);
                break;
            }
            catch (Exception exception) {
                if (--leftAddAttempts == 0) {
                    throw exception;
                }
                log.warn("Unable to add keys: {}, will retry after {}ms", addedMap, this.options.getWriterRetryInterval(), exception);
                try {
                    Thread.sleep(this.options.getWriterRetryInterval());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void delete(Collection<K> keys) {
        int leftDeleteAttempts = Math.max(1, this.options.getWriterRetryAttempts());
        while (leftDeleteAttempts > 0) {
            try {
                this.mapWriter.delete(keys);
                break;
            }
            catch (Exception exception) {
                if (--leftDeleteAttempts == 0) {
                    throw exception;
                }
                log.warn("Unable to delete keys: {}, will retry after {}ms", keys, this.options.getWriterRetryInterval(), exception);
                try {
                    Thread.sleep(this.options.getWriterRetryInterval());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

