/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import org.redisson.RedissonKeys;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.IteratorConsumer;
import reactor.core.publisher.Flux;

public class RedissonKeysReactive {
    private final CommandReactiveExecutor commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysReactive(CommandReactiveExecutor commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public Flux<String> getKeys() {
        return this.getKeysByPattern(null);
    }

    public Flux<String> getKeys(int count) {
        return this.getKeysByPattern(null, count);
    }

    public Flux<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    public Flux<String> getKeysByPattern(String pattern, int count) {
        ArrayList<Flux<String>> publishers = new ArrayList<Flux<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, pattern, count));
        }
        return Flux.merge(publishers);
    }

    private Flux<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count) {
        return Flux.create(emitter -> emitter.onRequest(new IteratorConsumer<String>(emitter){

            @Override
            protected boolean tryAgain() {
                return false;
            }

            @Override
            protected RFuture<ScanResult<Object>> scanIterator(RedisClient client, String nextIterPos) {
                return RedissonKeysReactive.this.instance.scanIteratorAsync(client, entry, nextIterPos, pattern, count);
            }
        }));
    }
}

