/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBaseLock;
import org.redisson.api.LockOptions;
import org.redisson.api.RFuture;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonSpinLock
extends RedissonBaseLock {
    protected long internalLockLeaseTime;
    protected final LockOptions.BackOff backOff;
    final CommandAsyncExecutor commandExecutor;

    public RedissonSpinLock(CommandAsyncExecutor commandExecutor, String name, LockOptions.BackOff backOff) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.internalLockLeaseTime = this.getServiceManager().getCfg().getLockWatchdogTimeout();
        this.backOff = backOff;
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly(-1L, null);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return;
        }
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        while (ttl != null) {
            long nextSleepPeriod = backOffPolicy.getNextSleepPeriod();
            Thread.sleep(nextSleepPeriod);
            ttl = this.tryAcquire(leaseTime, unit, threadId);
        }
    }

    private Long tryAcquire(long leaseTime, TimeUnit unit, long threadId) {
        return this.get(this.tryAcquireAsync(leaseTime, unit, threadId));
    }

    private <T> RFuture<Long> tryAcquireAsync(long leaseTime, TimeUnit unit, long threadId) {
        if (leaseTime > 0L) {
            RFuture<Long> acquiredFuture = this.tryLockInnerAsync(leaseTime, unit, threadId, RedisCommands.EVAL_LONG);
            CompletionStage<Long> s = this.handleNoSync(threadId, acquiredFuture);
            return new CompletableFutureWrapper<Long>(s);
        }
        RFuture<Long> ttlRemainingFuture = this.tryLockInnerAsync(this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_LONG);
        CompletionStage<Long> s = this.handleNoSync(threadId, ttlRemainingFuture);
        ttlRemainingFuture = new CompletableFutureWrapper<Long>(s);
        ttlRemainingFuture.thenAccept(ttlRemaining -> {
            if (ttlRemaining == null) {
                this.scheduleExpirationRenewal(threadId);
            }
        });
        return ttlRemainingFuture;
    }

    @Override
    public boolean tryLock() {
        return this.get(this.tryLockAsync());
    }

    <T> RFuture<T> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, command, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return redis.call('pttl', KEYS[1]);", Collections.singletonList(this.getRawName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return true;
        }
        if (System.currentTimeMillis() - current >= time) {
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        do {
            Thread.sleep(backOffPolicy.getNextSleepPeriod());
            ttl = this.tryAcquire(leaseTime, unit, threadId);
            if (ttl != null) continue;
            return true;
        } while (System.currentTimeMillis() - current < time);
        this.acquireFailed(waitTime, unit, threadId);
        return false;
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    @Override
    protected void cancelExpirationRenewal(Long threadId) {
        super.cancelExpirationRenewal(threadId);
        this.internalLockLeaseTime = this.getServiceManager().getCfg().getLockWatchdogTimeout();
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null);
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('del', KEYS[1]) == 1) then return 1 else return 0 end", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId, String requestId, int timeout) {
        return this.evalWriteSyncedAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local val = redis.call('get', KEYS[2]); if val ~= false then return tonumber(val);end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[1]); redis.call('set', KEYS[2], 0, 'px', ARGV[3]); return 0; else redis.call('del', KEYS[1]); redis.call('set', KEYS[2], 1, 'px', ARGV[3]); return 1; end; ", Arrays.asList(this.getRawName(), this.getUnlockLatchName(requestId)), this.internalLockLeaseTime, this.getLockName(threadId), timeout);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long currentThreadId) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        this.lockAsync(leaseTime, unit, currentThreadId, result, backOffPolicy);
        return new CompletableFutureWrapper<Void>(result);
    }

    private void lockAsync(long leaseTime, TimeUnit unit, long currentThreadId, CompletableFuture<Void> result, LockOptions.BackOffPolicy backOffPolicy) {
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((ttl, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.complete(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long nextSleepPeriod = backOffPolicy.getNextSleepPeriod();
            this.getServiceManager().newTimeout(timeout -> this.lockAsync(leaseTime, unit, currentThreadId, result, backOffPolicy), nextSleepPeriod, TimeUnit.MILLISECONDS);
        });
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        RFuture<Long> longRFuture = this.tryAcquireAsync(-1L, null, threadId);
        CompletionStage<Boolean> f = longRFuture.thenApply(res -> res == null);
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, long currentThreadId) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        this.tryLock(System.currentTimeMillis(), leaseTime, unit, currentThreadId, result, unit.toMillis(waitTime), backOffPolicy);
        return new CompletableFutureWrapper<Boolean>(result);
    }

    private void tryLock(long startTime, long leaseTime, TimeUnit unit, long currentThreadId, CompletableFuture<Boolean> result, long waitTime, LockOptions.BackOffPolicy backOffPolicy) {
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((ttl, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.complete(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            if (System.currentTimeMillis() - startTime >= waitTime) {
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            long nextSleepPeriod = backOffPolicy.getNextSleepPeriod();
            this.getServiceManager().newTimeout(timeout -> this.tryLock(startTime, leaseTime, unit, currentThreadId, result, waitTime, backOffPolicy), nextSleepPeriod, TimeUnit.MILLISECONDS);
        });
    }
}

