/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.RedissonTopic;
import org.redisson.api.NameMapper;
import org.redisson.api.RFuture;
import org.redisson.api.RShardedTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.PubSubConnectionEntry;

public class RedissonShardedTopic
extends RedissonTopic
implements RShardedTopic {
    public RedissonShardedTopic(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonShardedTopic(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    public RedissonShardedTopic(Codec codec, CommandAsyncExecutor commandExecutor, NameMapper nameMapper, String name) {
        super(codec, commandExecutor, nameMapper, name);
    }

    public static RedissonTopic createRaw(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        return new RedissonShardedTopic(codec, commandExecutor, NameMapper.direct(), name);
    }

    @Override
    protected RFuture<Integer> addListenerAsync(RedisPubSubListener<?> pubSubListener) {
        CompletableFuture<PubSubConnectionEntry> future = this.subscribeService.ssubscribe(this.codec, this.channelName, pubSubListener);
        CompletionStage f = future.thenApply(res -> System.identityHashCode(pubSubListener));
        return new CompletableFutureWrapper<Integer>((CompletableFuture<Integer>)f);
    }

    @Override
    public RFuture<Long> publishAsync(Object message) {
        String name = this.getName(message);
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.SPUBLISH, name, this.commandExecutor.encode(this.codec, message));
    }

    @Override
    public RFuture<Void> removeListenerAsync(MessageListener<?> listener) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.SUNSUBSCRIBE, this.channelName, listener);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> removeListenerAsync(Integer ... listenerIds) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.SUNSUBSCRIBE, this.channelName, listenerIds);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> removeAllListenersAsync() {
        CompletableFuture<Void> f = this.subscribeService.removeAllListenersAsync(PubSubType.SUNSUBSCRIBE, this.channelName);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Long> countSubscribersAsync() {
        throw new UnsupportedOperationException("Sharded PUBSUB doesn't support this operation");
    }
}

