/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.options;

import java.time.Duration;
import org.redisson.api.MapOptions;
import org.redisson.api.map.MapLoader;
import org.redisson.api.map.MapLoaderAsync;
import org.redisson.api.map.MapWriter;
import org.redisson.api.map.MapWriterAsync;
import org.redisson.api.map.RetryableMapWriter;
import org.redisson.api.map.RetryableMapWriterAsync;
import org.redisson.api.map.WriteMode;
import org.redisson.api.options.BaseOptions;
import org.redisson.api.options.ExMapOptions;
import org.redisson.client.codec.Codec;

class BaseMapOptions<T extends ExMapOptions<T, K, V>, K, V>
extends BaseOptions<T, Codec>
implements ExMapOptions<T, K, V> {
    private int writeRetryAttempts;
    private MapWriter<K, V> writer;
    private MapWriterAsync<K, V> writerAsync;
    private int writeBehindBatchSize;
    private int writeBehindDelay;
    private WriteMode writeMode;
    private long writeRetryInterval;
    private MapLoader<K, V> loader;
    private MapLoaderAsync<K, V> loaderAsync;

    BaseMapOptions() {
    }

    @Override
    public T writer(MapWriter<K, V> writer) {
        if (writer != null) {
            MapOptions options = MapOptions.defaults().writerRetryAttempts(this.getWriteRetryAttempts()).writerRetryInterval(Duration.ofMillis(this.getWriteRetryInterval()));
            this.writer = new RetryableMapWriter(options, writer);
        }
        return (T)this;
    }

    public MapWriter<K, V> getWriter() {
        return this.writer;
    }

    @Override
    public T writerAsync(MapWriterAsync<K, V> writer) {
        if (writer != null) {
            MapOptions options = MapOptions.defaults().writerRetryAttempts(this.getWriteRetryAttempts()).writerRetryInterval(Duration.ofMillis(this.getWriteRetryInterval()));
            this.writerAsync = new RetryableMapWriterAsync(options, writer);
        }
        return (T)this;
    }

    public MapWriterAsync<K, V> getWriterAsync() {
        return this.writerAsync;
    }

    @Override
    public T writeBehindBatchSize(int writeBehindBatchSize) {
        this.writeBehindBatchSize = writeBehindBatchSize;
        return (T)this;
    }

    public int getWriteBehindBatchSize() {
        return this.writeBehindBatchSize;
    }

    @Override
    public T writeBehindDelay(int writeBehindDelay) {
        this.writeBehindDelay = writeBehindDelay;
        return (T)this;
    }

    public int getWriteBehindDelay() {
        return this.writeBehindDelay;
    }

    @Override
    public T writeMode(WriteMode writeMode) {
        this.writeMode = writeMode;
        return (T)this;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public int getWriteRetryAttempts() {
        return this.writeRetryAttempts;
    }

    @Override
    public T writeRetryAttempts(int writerRetryAttempts) {
        if (writerRetryAttempts <= 0) {
            throw new IllegalArgumentException("writerRetryAttempts must be bigger than 0");
        }
        this.writeRetryAttempts = writerRetryAttempts;
        return (T)this;
    }

    public long getWriteRetryInterval() {
        return this.writeRetryInterval;
    }

    @Override
    public T writeRetryInterval(Duration writerRetryInterval) {
        if (writerRetryInterval.isNegative()) {
            throw new IllegalArgumentException("writerRetryInterval must be positive");
        }
        this.writeRetryInterval = writerRetryInterval.toMillis();
        return (T)this;
    }

    @Override
    public T loader(MapLoader<K, V> loader) {
        this.loader = loader;
        return (T)this;
    }

    public MapLoader<K, V> getLoader() {
        return this.loader;
    }

    @Override
    public T loaderAsync(MapLoaderAsync<K, V> loaderAsync) {
        this.loaderAsync = loaderAsync;
        return (T)this;
    }

    public MapLoaderAsync<K, V> getLoaderAsync() {
        return this.loaderAsync;
    }
}

