/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class WrappedLock {
    private final Lock lock = new ReentrantLock();

    public void execute(Runnable r) {
        this.lock.lock();
        try {
            r.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> T execute(Supplier<T> r) {
        this.lock.lock();
        try {
            T t = r.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

