/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.redisson.client.FailedNodeDetector;

public class FailedCommandsDetector
implements FailedNodeDetector {
    private final long checkInterval;
    private long failedCommandsLimit;
    private final NavigableSet<Long> failedCommands = new ConcurrentSkipListSet<Long>();

    public FailedCommandsDetector(long checkInterval, int failedCommandsLimit) {
        this.checkInterval = checkInterval;
        this.failedCommandsLimit = failedCommandsLimit;
    }

    @Override
    public void onConnectFailed() {
    }

    @Override
    public void onConnectSuccessful() {
    }

    @Override
    public void onPingSuccessful() {
    }

    @Override
    public void onCommandSuccessful() {
    }

    @Override
    public void onPingFailed() {
    }

    @Override
    public void onCommandFailed(Throwable cause) {
        this.failedCommands.add(System.currentTimeMillis());
    }

    @Override
    public boolean isNodeFailed() {
        long start = System.currentTimeMillis() - this.checkInterval;
        this.failedCommands.headSet(start).clear();
        if ((long)this.failedCommands.tailSet(start).size() >= this.failedCommandsLimit) {
            this.failedCommands.clear();
            return true;
        }
        return false;
    }
}

