/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.redisson.api.SortOrder;
import org.redisson.api.search.query.HighlightOptions;
import org.redisson.api.search.query.QueryFilter;
import org.redisson.api.search.query.ReturnAttribute;
import org.redisson.api.search.query.SummarizeOptions;

public final class QueryOptions {
    private boolean noContent;
    private boolean verbatim;
    private boolean noStopwords;
    private boolean withScores;
    private boolean withSortKeys;
    private Integer slop;
    private Long timeout;
    private boolean inOrder;
    private String language;
    private String expander;
    private String scorer;
    private boolean explainScore;
    private String sortBy;
    private SortOrder sortOrder;
    private Integer offset;
    private Integer count;
    private Map<String, Object> params = Collections.emptyMap();
    private Integer dialect;
    private List<QueryFilter> filters = Collections.emptyList();
    private SummarizeOptions summarize;
    private HighlightOptions highlight;
    private List<String> inKeys = Collections.emptyList();
    private List<String> inFields = Collections.emptyList();
    private List<ReturnAttribute> returnAttributes = Collections.emptyList();

    private QueryOptions() {
    }

    public static QueryOptions defaults() {
        return new QueryOptions();
    }

    public QueryOptions filters(QueryFilter ... filters) {
        this.filters = Arrays.asList(filters);
        return this;
    }

    public QueryOptions noContent(boolean noContent) {
        this.noContent = noContent;
        return this;
    }

    public QueryOptions verbatim(boolean verbatim) {
        this.verbatim = verbatim;
        return this;
    }

    public QueryOptions noStopwords(boolean noStopwords) {
        this.noStopwords = noStopwords;
        return this;
    }

    public QueryOptions withScores(boolean withScores) {
        this.withScores = withScores;
        return this;
    }

    public QueryOptions withSortKeys(boolean withSortKeys) {
        this.withSortKeys = withSortKeys;
        return this;
    }

    public QueryOptions slop(Integer slop) {
        this.slop = slop;
        return this;
    }

    public QueryOptions timeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    public QueryOptions inOrder(boolean inOrder) {
        this.inOrder = inOrder;
        return this;
    }

    public QueryOptions language(String language) {
        this.language = language;
        return this;
    }

    public QueryOptions expander(String expander) {
        this.expander = expander;
        return this;
    }

    public QueryOptions scorer(String scorer) {
        this.scorer = scorer;
        return this;
    }

    public QueryOptions explainScore(boolean explainScore) {
        this.explainScore = explainScore;
        return this;
    }

    public QueryOptions sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public QueryOptions sortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public QueryOptions limit(int offset, int count) {
        this.offset = offset;
        this.count = count;
        return this;
    }

    public QueryOptions params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public QueryOptions dialect(Integer dialect) {
        this.dialect = dialect;
        return this;
    }

    public QueryOptions summarize(SummarizeOptions summarize) {
        this.summarize = summarize;
        return this;
    }

    public QueryOptions highlight(HighlightOptions highlight) {
        this.highlight = highlight;
        return this;
    }

    public QueryOptions inKeys(List<String> inKeys) {
        this.inKeys = inKeys;
        return this;
    }

    public QueryOptions inFields(List<String> inFields) {
        this.inFields = inFields;
        return this;
    }

    public QueryOptions returnAttributes(ReturnAttribute ... returnAttributes) {
        return this.returnAttributes(Arrays.asList(returnAttributes));
    }

    public QueryOptions returnAttributes(List<ReturnAttribute> returnAttributes) {
        this.returnAttributes = returnAttributes;
        return this;
    }

    public boolean isNoContent() {
        return this.noContent;
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public boolean isNoStopwords() {
        return this.noStopwords;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public boolean isWithSortKeys() {
        return this.withSortKeys;
    }

    public Integer getSlop() {
        return this.slop;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getExpander() {
        return this.expander;
    }

    public String getScorer() {
        return this.scorer;
    }

    public boolean isExplainScore() {
        return this.explainScore;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getCount() {
        return this.count;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Integer getDialect() {
        return this.dialect;
    }

    public List<QueryFilter> getFilters() {
        return this.filters;
    }

    public SummarizeOptions getSummarize() {
        return this.summarize;
    }

    public HighlightOptions getHighlight() {
        return this.highlight;
    }

    public List<String> getInKeys() {
        return this.inKeys;
    }

    public List<String> getInFields() {
        return this.inFields;
    }

    public List<ReturnAttribute> getReturnAttributes() {
        return this.returnAttributes;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }
}

