/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonLock;
import org.redisson.RedissonReadLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.LockPubSub;

public class RedissonWriteLock
extends RedissonLock
implements RLock {
    protected RedissonWriteLock(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    String getChannelName() {
        return RedissonWriteLock.prefixName("redisson_rwlock", this.getRawName());
    }

    @Override
    protected String getLockName(long threadId) {
        return super.getLockName(threadId) + ":write";
    }

    @Override
    <T> RFuture<T> tryLockInnerAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, command, "local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call('hset', KEYS[1], 'mode', 'write'); redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (mode == 'write') then if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); local currentExpire = redis.call('pttl', KEYS[1]); redis.call('pexpire', KEYS[1], currentExpire + ARGV[1]); return nil; end; end;return redis.call('pttl', KEYS[1]);", Arrays.asList(this.getRawName()), unit.toMillis(leaseTime), this.getLockName(threadId));
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId, String requestId, int timeout) {
        return this.evalWriteSyncedAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local val = redis.call('get', KEYS[3]); if val ~= false then return tonumber(val);end; local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call(ARGV[4], KEYS[2], ARGV[1]); redis.call('set', KEYS[3], 1, 'px', ARGV[5]); return 1; end;if (mode == 'write') then local lockExists = redis.call('hexists', KEYS[1], ARGV[3]); if (lockExists == 0) then return nil;else local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); redis.call('set', KEYS[3], 0, 'px', ARGV[5]); return 0; else redis.call('hdel', KEYS[1], ARGV[3]); if (redis.call('hlen', KEYS[1]) == 1) then redis.call('del', KEYS[1]); redis.call(ARGV[4], KEYS[2], ARGV[1]); else redis.call('hset', KEYS[1], 'mode', 'read'); end; redis.call('set', KEYS[3], 1, 'px', ARGV[5]); return 1; end; end; end; return nil;", Arrays.asList(this.getRawName(), this.getChannelName(), this.getUnlockLatchName(requestId)), LockPubSub.READ_UNLOCK_MESSAGE, this.internalLockLeaseTime, this.getLockName(threadId), this.getSubscribeService().getPublishCommand(), timeout);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CompletionStage<Boolean> renewExpirationAsync(long threadId) {
        CompletionStage<Boolean> f = super.renewExpirationAsync(threadId);
        return f.thenCompose(r -> {
            if (!r.booleanValue()) {
                RedissonReadLock lock = new RedissonReadLock(this.commandExecutor, this.getRawName());
                return lock.renewExpirationAsync(threadId);
            }
            return CompletableFuture.completedFuture(r);
        });
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null);
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hget', KEYS[1], 'mode') == 'write') then redis.call('del', KEYS[1]); redis.call(ARGV[2], KEYS[2], ARGV[1]); return 1; end; return 0; ", Arrays.asList(this.getRawName(), this.getChannelName()), LockPubSub.READ_UNLOCK_MESSAGE, this.getSubscribeService().getPublishCommand());
    }

    @Override
    public boolean isLocked() {
        RFuture future = this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.HGET, this.getRawName(), "mode");
        String res = (String)this.get(future);
        return "write".equals(res);
    }
}

