/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonLock;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFencedLock;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonFencedLock
extends RedissonLock
implements RFencedLock {
    private final String tokenName = RedissonFencedLock.prefixName("redisson_lock_token", this.getRawName());

    public RedissonFencedLock(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public Long getToken() {
        return this.get(this.getTokenAsync());
    }

    @Override
    public RFuture<Long> getTokenAsync() {
        return this.commandExecutor.writeAsync(this.tokenName, (Codec)StringCodec.INSTANCE, RedisCommands.GET_LONG, this.tokenName);
    }

    @Override
    public Long lockAndGetToken() {
        return this.get(this.lockAndGetTokenAsync());
    }

    @Override
    public RFuture<Long> lockAndGetTokenAsync() {
        return this.tryLockAndGetTokenAsync(-1L, -1L, null);
    }

    @Override
    public Long lockAndGetToken(long leaseTime, TimeUnit unit) {
        return this.get(this.lockAndGetTokenAsync());
    }

    @Override
    public RFuture<Long> lockAndGetTokenAsync(long leaseTime, TimeUnit unit) {
        return this.tryLockAndGetTokenAsync(-1L, leaseTime, unit);
    }

    private <T> RFuture<List<Long>> tryAcquireAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        RFuture<List<Long>> ttlRemainingFuture = leaseTime > 0L ? this.tryLockInnerAsync(leaseTime, unit, threadId) : this.tryLockInnerAsync(this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId);
        CompletionStage<List> f = ttlRemainingFuture.thenApply(res -> {
            Long ttl = (Long)res.get(0);
            if (ttl == -1L) {
                if (leaseTime > 0L) {
                    this.internalLockLeaseTime = unit.toMillis(leaseTime);
                } else {
                    this.scheduleExpirationRenewal(threadId);
                }
            }
            return res;
        });
        return new CompletableFutureWrapper<List<Long>>(f);
    }

    RFuture<List<Long>> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId) {
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_LONG_LIST, "if (redis.call('exists', KEYS[1]) == 0 or (redis.call('hexists', KEYS[1], ARGV[2]) == 1)) then local token = redis.call('incr', KEYS[2]);redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return {-1, token}; end; return {redis.call('pttl', KEYS[1]), -1};", Arrays.asList(this.getRawName(), this.tokenName), unit.toMillis(leaseTime), this.getLockName(threadId));
    }

    @Override
    public Long tryLockAndGetToken() {
        return this.get(this.tryLockAndGetTokenAsync());
    }

    @Override
    public RFuture<Long> tryLockAndGetTokenAsync() {
        return this.tryLockAndGetTokenAsync(-1L, null);
    }

    @Override
    public Long tryLockAndGetToken(long waitTime, long leaseTime, TimeUnit unit) {
        return this.get(this.tryLockAndGetTokenAsync(waitTime, leaseTime, unit));
    }

    @Override
    public RFuture<Long> tryLockAndGetTokenAsync(long waitTime, long leaseTime, TimeUnit unit) {
        return this.tryLockAndGetTokenAsync(waitTime, leaseTime, unit, Thread.currentThread().getId());
    }

    @Override
    public Long tryLockAndGetToken(long waitTime, TimeUnit unit) {
        return this.get(this.tryLockAndGetTokenAsync(waitTime, unit));
    }

    @Override
    public RFuture<Long> tryLockAndGetTokenAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAndGetTokenAsync(waitTime, -1L, unit);
    }

    public RFuture<Long> tryLockAndGetTokenAsync(long waitTime, long leaseTime, TimeUnit unit, long currentThreadId) {
        final CompletableFuture result = new CompletableFuture();
        AtomicLong time = waitTime < 0L ? new AtomicLong(Long.MAX_VALUE) : new AtomicLong(unit.toMillis(waitTime));
        long currentTime = System.currentTimeMillis();
        RFuture<List<Long>> ttlFuture = this.tryAcquireAsync(waitTime, leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((res, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            Long ttl = (Long)res.get(0);
            if (ttl == -1L) {
                if (!result.complete((Long)res.get(1))) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - currentTime;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                result.complete(null);
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe(currentThreadId);
            this.pubSub.timeout((CompletableFuture)subscribeFuture, time.get());
            subscribeFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.tryLockAsync(time, waitTime, leaseTime, unit, (RedissonLockEntry)r, result, currentThreadId);
            });
            if (!subscribeFuture.isDone()) {
                Timeout scheduledFuture = this.commandExecutor.getServiceManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (!subscribeFuture.isDone()) {
                            subscribeFuture.cancel(false);
                            result.complete(null);
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(scheduledFuture);
            }
        });
        return new CompletableFutureWrapper<Long>(result);
    }

    private void tryLockAsync(AtomicLong time, long waitTime, long leaseTime, TimeUnit unit, RedissonLockEntry entry, CompletableFuture<Long> result, long currentThreadId) {
        if (result.isDone()) {
            this.unsubscribe(entry, currentThreadId);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(entry, currentThreadId);
            result.complete(null);
            return;
        }
        long curr = System.currentTimeMillis();
        RFuture<List<Long>> ttlFuture = this.tryAcquireAsync(waitTime, leaseTime, unit, currentThreadId);
        ttlFuture.whenComplete((res, e) -> {
            if (e != null) {
                this.unsubscribe(entry, currentThreadId);
                result.completeExceptionally((Throwable)e);
                return;
            }
            Long ttl = (Long)res.get(0);
            if (ttl == -1L) {
                this.unsubscribe(entry, currentThreadId);
                if (!result.complete((Long)res.get(1))) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(entry, currentThreadId);
                result.complete(null);
                return;
            }
            long current = System.currentTimeMillis();
            if (entry.getLatch().tryAcquire()) {
                this.tryLockAsync(time, waitTime, leaseTime, unit, entry, result, currentThreadId);
            } else {
                AtomicBoolean executed = new AtomicBoolean();
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                Runnable listener = () -> {
                    executed.set(true);
                    if (futureRef.get() != null) {
                        ((Timeout)futureRef.get()).cancel();
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryLockAsync(time, waitTime, leaseTime, unit, entry, result, currentThreadId);
                };
                entry.addListener(listener);
                long t = time.get();
                if (ttl < time.get()) {
                    t = ttl;
                }
                if (!executed.get()) {
                    Timeout scheduledFuture = this.commandExecutor.getServiceManager().newTimeout(timeout -> {
                        if (entry.removeListener(listener)) {
                            long elapsed = System.currentTimeMillis() - current;
                            time.addAndGet(-elapsed);
                            this.tryLockAsync(time, waitTime, leaseTime, unit, entry, result, currentThreadId);
                        }
                    }, t, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }

    @Override
    <T> RFuture<T> tryLockInnerAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, command, "if ((redis.call('exists', KEYS[1]) == 0) or (redis.call('hexists', KEYS[1], ARGV[2]) == 1)) then redis.call('incr', KEYS[2]);redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return redis.call('pttl', KEYS[1]);", Arrays.asList(this.getRawName(), this.tokenName), unit.toMillis(leaseTime), this.getLockName(threadId));
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.tokenName);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.tokenName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.tokenName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.tokenName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.tokenName);
    }
}

