/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.redisson.RedissonBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.ClearExpireOperation;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.ExpireAtOperation;
import org.redisson.transaction.operation.ExpireOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.bucket.BucketCompareAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndDeleteOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketSetOperation;
import org.redisson.transaction.operation.bucket.BucketTrySetOperation;

public class RedissonTransactionalBucket<V>
extends RedissonBucket<V> {
    static final Object NULL = new Object();
    private long timeout;
    private final AtomicBoolean executed;
    private final List<TransactionalOperation> operations;
    private Object state;
    private boolean hasExpiration;
    private final String transactionId;

    public RedissonTransactionalBucket(CommandAsyncExecutor commandExecutor, long timeout, String name, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
        this.timeout = timeout;
    }

    public RedissonTransactionalBucket(Codec codec, CommandAsyncExecutor commandExecutor, long timeout, String name, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(codec, commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
        this.timeout = timeout;
    }

    @Override
    protected RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new ExpireOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId, timeToLive, timeUnit, param, keys));
                this.hasExpiration = true;
                return CompletableFuture.completedFuture(this.state != NULL);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new ExpireOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId, timeToLive, timeUnit, param, keys));
                this.hasExpiration = res;
                return res;
            });
        });
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new ExpireAtOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId, timestamp, param, keys));
                this.hasExpiration = true;
                return CompletableFuture.completedFuture(this.state != NULL);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new ExpireAtOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId, timestamp, param, keys));
                this.hasExpiration = res;
                return res;
            });
        });
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.hasExpiration) {
                this.operations.add(new ClearExpireOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId));
                this.hasExpiration = false;
                return CompletableFuture.completedFuture(true);
            }
            return this.remainTimeToLiveAsync().thenApply(res -> {
                this.operations.add(new ClearExpireOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId));
                this.hasExpiration = false;
                return res > 0L;
            });
        });
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("moveAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        throw new UnsupportedOperationException("migrateAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Long> sizeAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return new CompletableFutureWrapper<Long>(0L);
            }
            ByteBuf buf = this.encode(this.state);
            long size = buf.readableBytes();
            buf.release();
            return new CompletableFutureWrapper<Long>(size);
        }
        return super.sizeAsync();
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        this.checkState();
        if (this.state != null) {
            return new CompletableFutureWrapper<Boolean>(this.state != NULL);
        }
        return super.isExistsAsync();
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new TouchOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId));
                return CompletableFuture.completedFuture(this.state != NULL);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new TouchOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId));
                return res;
            });
        });
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new UnlinkOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId));
                if (this.state == NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.state = NULL;
                return CompletableFuture.completedFuture(true);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new UnlinkOperation(this.getName(), this.getLockName(), currentThreadId, this.transactionId));
                this.state = NULL;
                return res;
            });
        });
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.checkState();
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new DeleteOperation(this.getName(), this.getLockName(), this.transactionId, threadId));
                if (this.state == NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.state = NULL;
                return CompletableFuture.completedFuture(true);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new DeleteOperation(this.getName(), this.getLockName(), this.transactionId, threadId));
                this.state = NULL;
                return res;
            });
        });
    }

    @Override
    public RFuture<V> getAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return new CompletableFutureWrapper<Object>(null);
            }
            return new CompletableFutureWrapper<Object>(this.state);
        }
        return super.getAsync();
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(V expect, V update) {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new BucketCompareAndSetOperation<Object>(this.getName(), this.getLockName(), this.getCodec(), expect, update, this.transactionId, currentThreadId));
                if (this.state == NULL && expect == null || this.isEquals(this.state, expect)) {
                    this.state = Optional.ofNullable(update).orElse(NULL);
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.getAsync().thenApply(res -> {
                this.operations.add(new BucketCompareAndSetOperation<Object>(this.getName(), this.getLockName(), this.getCodec(), expect, update, this.transactionId, currentThreadId));
                if (res == null && expect == null || this.isEquals(res, expect)) {
                    this.state = Optional.ofNullable(update).orElse(NULL);
                    return true;
                }
                return false;
            });
        });
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.getAndSet(value, new BucketGetAndSetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId));
    }

    @Override
    public RFuture<V> getAndSetAsync(V value) {
        return this.getAndSet(value, new BucketGetAndSetOperation(this.getName(), this.getLockName(), this.getCodec(), value, this.transactionId));
    }

    private RFuture<V> getAndSet(V newValue, TransactionalOperation operation) {
        this.checkState();
        return this.executeLocked(() -> {
            if (this.state != null) {
                Object prevValue = Optional.of(this.state).filter(s -> s != NULL).orElse(null);
                this.operations.add(operation);
                this.state = Optional.ofNullable(newValue).orElse(NULL);
                return CompletableFuture.completedFuture(prevValue);
            }
            return this.getAsync().thenApply(res -> {
                this.state = Optional.ofNullable(newValue).orElse(NULL);
                this.operations.add(operation);
                return res;
            });
        });
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                Object prevValue = Optional.of(this.state).filter(s -> s != NULL).orElse(null);
                this.operations.add(new BucketGetAndDeleteOperation(this.getName(), this.getLockName(), this.getCodec(), this.transactionId, currentThreadId));
                this.state = NULL;
                return CompletableFuture.completedFuture(prevValue);
            }
            return this.getAsync().thenApply(res -> {
                this.state = NULL;
                this.operations.add(new BucketGetAndDeleteOperation(this.getName(), this.getLockName(), this.getCodec(), this.transactionId, currentThreadId));
                return res;
            });
        });
    }

    @Override
    public RFuture<Void> setAsync(V newValue) {
        long currentThreadId = Thread.currentThread().getId();
        return this.setAsync(newValue, new BucketSetOperation(this.getName(), this.getLockName(), this.getCodec(), newValue, this.transactionId, currentThreadId));
    }

    private RFuture<Void> setAsync(V newValue, BucketSetOperation operation) {
        this.checkState();
        return this.executeLocked(() -> {
            this.hasExpiration = operation.getTimeUnit() != null;
            this.operations.add(operation);
            this.state = Optional.ofNullable(newValue).orElse(NULL);
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.setAsync(value, new BucketSetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId, currentThreadId));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V newValue) {
        long currentThreadId = Thread.currentThread().getId();
        return this.trySet(newValue, new BucketTrySetOperation(this.getName(), this.getLockName(), this.getCodec(), newValue, this.transactionId, currentThreadId));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.trySet(value, new BucketTrySetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId, currentThreadId));
    }

    private RFuture<Boolean> trySet(V newValue, BucketTrySetOperation operation) {
        this.checkState();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(operation);
                if (this.state == NULL) {
                    this.state = Optional.ofNullable(newValue).orElse(NULL);
                    this.hasExpiration = operation.getTimeUnit() != null;
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.getAsync().thenApply(res -> {
                this.operations.add(operation);
                if (res == null) {
                    this.hasExpiration = operation.getTimeUnit() != null;
                    this.state = Optional.ofNullable(newValue).orElse(NULL);
                    return true;
                }
                return false;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEquals(Object value, Object oldValue) {
        ByteBuf valueBuf = this.encode(value);
        ByteBuf oldValueBuf = this.encode(oldValue);
        try {
            boolean bl = valueBuf.equals(oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected <R> RFuture<R> executeLocked(Supplier<CompletionStage<R>> runnable) {
        RLock lock = this.getLock();
        CompletionStage f = lock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).thenCompose(res -> (CompletionStage)runnable.get());
        return new CompletableFutureWrapper(f);
    }

    private RLock getLock() {
        return new RedissonTransactionalLock(this.commandExecutor, this.getLockName(), this.transactionId);
    }

    private String getLockName() {
        return this.getName() + ":transaction_lock";
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

