/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.BaseRedissonList;
import org.redisson.api.RBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RPriorityQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonPriorityQueue<V>
extends BaseRedissonList<V>
implements RPriorityQueue<V> {
    private Comparator comparator = Comparator.naturalOrder();
    CommandAsyncExecutor commandExecutor;
    RLock lock;
    private RBucket<String> comparatorHolder;

    public RedissonPriorityQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
        this.commandExecutor = commandExecutor;
        this.comparatorHolder = redisson.getBucket(this.getComparatorKeyName(), StringCodec.INSTANCE);
        this.lock = redisson.getLock(this.getLockName());
    }

    public RedissonPriorityQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.commandExecutor = commandExecutor;
        this.comparatorHolder = redisson.getBucket(this.getComparatorKeyName(), StringCodec.INSTANCE);
        this.lock = redisson.getLock(this.getLockName());
    }

    private String getLockName() {
        return RedissonPriorityQueue.prefixName("redisson_sortedset_lock", this.getName());
    }

    private void loadComparator() {
        try {
            String className;
            String comparatorSign = this.comparatorHolder.get();
            if (comparatorSign != null) {
                String[] parts = comparatorSign.split(":");
                className = parts[0];
                String sign = parts[1];
                String result = RedissonPriorityQueue.calcClassSign(className);
                if (!result.equals(sign)) {
                    throw new IllegalStateException("Local class signature of " + className + " differs from used by this SortedSet!");
                }
            } else {
                throw new IllegalStateException("Comparator is not set!");
            }
            Class<?> clazz = Class.forName(className);
            this.comparator = (Comparator)clazz.newInstance();
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String calcClassSign(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(result);
            outputStream.writeObject(clazz);
            outputStream.close();
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(result.toByteArray());
            return new BigInteger(1, crypt.digest()).toString(16);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't calculate sign of " + name, e);
        }
    }

    @Override
    public boolean offer(V e) {
        return this.add(e);
    }

    @Override
    public boolean contains(Object o) {
        this.checkComparator();
        return this.binarySearch(o).getIndex() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V value) {
        this.lock.lock();
        try {
            this.checkComparator();
            BinarySearchResult<V> res = this.binarySearch(value);
            int index = 0;
            index = res.getIndex() < 0 ? -(res.getIndex() + 1) : res.getIndex() + 1;
            this.get(this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "local len = redis.call('llen', KEYS[1]);if tonumber(ARGV[1]) < len then local pivot = redis.call('lindex', KEYS[1], ARGV[1]);redis.call('linsert', KEYS[1], 'before', pivot, ARGV[2]);return;end;redis.call('rpush', KEYS[1], ARGV[2]);", Arrays.asList(this.getRawName()), index, this.encode(value)));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkComparator() {
        String comparatorSign = this.comparatorHolder.get();
        if (comparatorSign != null) {
            String[] vals = comparatorSign.split(":");
            String className = vals[0];
            if (!this.comparator.getClass().getName().equals(className)) {
                this.loadComparator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        this.lock.lock();
        try {
            this.checkComparator();
            BinarySearchResult<Object> res = this.binarySearch(value);
            if (res.getIndex() < 0) {
                boolean bl = false;
                return bl;
            }
            this.remove(res.getIndex());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkComparator();
        for (Object object : c) {
            if (this.binarySearch(object).getIndex() >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            if (!this.add(v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (c.contains(object)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    @Override
    public RFuture<V> pollAsync() {
        return this.wrapLockedAsync(RedisCommands.LPOP, this.getRawName());
    }

    protected <T> RFuture<V> wrapLockedAsync(RedisCommand<T> command, Object ... params) {
        return this.wrapLockedAsync(() -> this.commandExecutor.writeAsync(this.getRawName(), this.codec, command, params));
    }

    protected final <T, R> RFuture<R> wrapLockedAsync(Supplier<RFuture<R>> callable) {
        long threadId = Thread.currentThread().getId();
        CompletionStage f = this.lock.lockAsync(threadId).thenCompose(r -> {
            RFuture callback = (RFuture)callable.get();
            return callback.thenCompose(value -> this.lock.unlockAsync(threadId).thenApply(res -> value));
        });
        return new CompletableFutureWrapper(f);
    }

    public V getFirst() {
        Object value = this.getValue(0);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V poll() {
        return this.get(this.pollAsync());
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    @Override
    public RFuture<V> peekAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peek() {
        return this.getValue(0);
    }

    private String getComparatorKeyName() {
        return RedissonPriorityQueue.suffixName(this.getRawName(), "redisson_sortedset_comparator");
    }

    @Override
    public boolean trySetComparator(Comparator<? super V> comparator) {
        String className = comparator.getClass().getName();
        String comparatorSign = className + ":" + RedissonPriorityQueue.calcClassSign(className);
        Boolean res = (Boolean)this.get(this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.SETNX, this.getComparatorKeyName(), comparatorSign));
        if (res.booleanValue()) {
            this.comparator = comparator;
        }
        return res;
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    public V removeFirst() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    public BinarySearchResult<V> binarySearch(V value) {
        int size = this.size();
        int upperIndex = size - 1;
        int lowerIndex = 0;
        while (lowerIndex <= upperIndex) {
            int index = lowerIndex + (upperIndex - lowerIndex) / 2;
            Object res = this.getValue(index);
            if (res == null) {
                return new BinarySearchResult();
            }
            int cmp = this.comparator.compare(value, res);
            if (cmp == 0) {
                BinarySearchResult indexRes = new BinarySearchResult();
                indexRes.setIndex(index);
                return indexRes;
            }
            if (cmp < 0) {
                upperIndex = index - 1;
                continue;
            }
            lowerIndex = index + 1;
        }
        BinarySearchResult indexRes = new BinarySearchResult();
        indexRes.setIndex(-(lowerIndex + 1));
        return indexRes;
    }

    @Override
    public String toString() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName) {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName) {
        return this.wrapLockedAsync(RedisCommands.RPOPLPUSH, this.getRawName(), queueName);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.getComparatorKeyName());
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.getComparatorKeyName());
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.getComparatorKeyName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.getComparatorKeyName());
    }

    @Override
    public List<V> poll(int limit) {
        return this.get(this.pollAsync(limit));
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<List<V>> pollAsync(int limit) {
        return this.wrapLockedAsync(() -> this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "local result = {};for i = 1, ARGV[1], 1 do local value = redis.call('lpop', KEYS[1]);if value ~= false then table.insert(result, value);else return result;end;end; return result;", Collections.singletonList(this.getRawName()), limit));
    }

    public static class BinarySearchResult<V> {
        private V value;
        private int index = -1;

        public BinarySearchResult(V value) {
            this.value = value;
        }

        public BinarySearchResult() {
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public V getValue() {
            return this.value;
        }
    }
}

