/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.MapCacheOptions;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionTask;
import org.redisson.eviction.JCacheEvictionTask;
import org.redisson.eviction.MapCacheEvictionTask;
import org.redisson.eviction.MultimapEvictionTask;
import org.redisson.eviction.ScoredSetEvictionTask;
import org.redisson.eviction.TimeSeriesEvictionTask;

public class EvictionScheduler {
    private final ConcurrentMap<String, EvictionTask> tasks = new ConcurrentHashMap<String, EvictionTask>();
    private final CommandAsyncExecutor executor;

    public EvictionScheduler(CommandAsyncExecutor executor) {
        this.executor = executor;
    }

    public void scheduleCleanMultimap(String name, String timeoutSetName) {
        MultimapEvictionTask task = new MultimapEvictionTask(name, timeoutSetName, this.executor);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void scheduleJCache(String name, String timeoutSetName, String expiredChannelName) {
        JCacheEvictionTask task = new JCacheEvictionTask(name, timeoutSetName, expiredChannelName, this.executor);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void scheduleTimeSeries(String name, String timeoutSetName) {
        TimeSeriesEvictionTask task = new TimeSeriesEvictionTask(name, timeoutSetName, this.executor);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void schedule(String name, long shiftInMilliseconds) {
        ScoredSetEvictionTask task = new ScoredSetEvictionTask(name, this.executor, shiftInMilliseconds);
        EvictionTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void schedule(String name, String timeoutSetName, String maxIdleSetName, String expiredChannelName, String lastAccessTimeSetName, MapCacheOptions<?, ?> options) {
        MapCacheEvictionTask task;
        EvictionTask prevTask;
        boolean removeEmpty = false;
        if (options != null) {
            removeEmpty = options.isRemoveEmptyEvictionTask();
        }
        if ((prevTask = this.tasks.putIfAbsent(name, task = new MapCacheEvictionTask(name, timeoutSetName, maxIdleSetName, expiredChannelName, lastAccessTimeSetName, this.executor, removeEmpty, this))) == null) {
            ((EvictionTask)task).schedule();
        }
    }

    public void remove(String name) {
        EvictionTask task = (EvictionTask)this.tasks.remove(name);
        if (task != null && task.getScheduledFuture() != null) {
            task.getScheduledFuture().cancel(false);
        }
    }
}

