/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.JsonType;
import org.redisson.api.RFuture;
import org.redisson.api.RJsonBucket;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.codec.JsonCodec;
import org.redisson.codec.JsonCodecWrapper;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonJsonBucket<V>
extends RedissonExpirable
implements RJsonBucket<V> {
    public RedissonJsonBucket(JsonCodec<V> codec, CommandAsyncExecutor connectionManager, String name) {
        super(new JsonCodecWrapper(codec), connectionManager, name);
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Long> stringSizeMulti(String path) {
        return this.get(this.stringSizeMultiAsync(path));
    }

    @Override
    public RFuture<List<Long>> stringSizeMultiAsync(String path) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_STRLEN_LIST, this.getRawName(), path);
    }

    @Override
    public Long stringSize(String path) {
        return this.get(this.stringSizeAsync(path));
    }

    @Override
    public RFuture<Long> stringSizeAsync(String path) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_STRLEN, this.getRawName(), path);
    }

    @Override
    public V get() {
        return this.get(this.getAsync());
    }

    @Override
    public RFuture<V> getAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.JSON_GET, this.getRawName());
    }

    @Override
    public <T> T get(JsonCodec<T> codec, String ... paths) {
        return this.get(this.getAsync(codec, paths));
    }

    @Override
    public <T> RFuture<T> getAsync(JsonCodec<T> codec, String ... paths) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getRawName());
        args.addAll(Arrays.asList(paths));
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.JSON_GET, args.toArray());
    }

    @Override
    public V getAndDelete() {
        return this.get(this.getAndDeleteAsync());
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1]); redis.call('del', KEYS[1]); return currValue; ", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public boolean setIfAbsent(V value) {
        return this.get(this.setIfAbsentAsync(value));
    }

    @Override
    public boolean setIfAbsent(V value, Duration duration) {
        return this.get(this.setIfAbsentAsync(value, duration));
    }

    @Override
    public RFuture<Boolean> setIfAbsentAsync(V value) {
        return this.setIfAbsentAsync("$", value);
    }

    @Override
    public RFuture<Boolean> setIfAbsentAsync(V value, Duration duration) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('json.set', KEYS[1], '$', ARGV[1], 'NX'); if currValue ~= false then redis.call('pexpire', KEYS[1], ARGV[2]); return 1;end;return 0; ", Collections.singletonList(this.getRawName()), this.encode(value), duration.toMillis());
    }

    @Override
    public boolean trySet(V value) {
        return this.get(this.trySetAsync(value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value) {
        return this.trySetAsync("$", value);
    }

    @Override
    public boolean setIfAbsent(String path, Object value) {
        return this.get(this.setIfAbsentAsync(path, value));
    }

    @Override
    public RFuture<Boolean> setIfAbsentAsync(String path, Object value) {
        if (value == null) {
            return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.NOT_EXISTS, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.JSON_SET_BOOLEAN, this.getRawName(), path, this.encode(value), "NX");
    }

    @Override
    public boolean trySet(String path, Object value) {
        return this.get(this.trySetAsync(path, value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(String path, Object value) {
        if (value == null) {
            return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.NOT_EXISTS, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.JSON_SET_BOOLEAN, this.getRawName(), path, this.encode(value), "NX");
    }

    @Override
    public boolean trySet(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.trySetAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('json.set', KEYS[1], '$', ARGV[1], 'NX'); if currValue ~= false then redis.call('pexpire', KEYS[1], ARGV[2]); return 1;end;return 0; ", Collections.singletonList(this.getRawName()), this.encode(value), timeUnit.toMillis(timeToLive));
    }

    @Override
    public boolean setIfExists(V value) {
        return this.get(this.setIfExistsAsync(value));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value) {
        return this.setIfExistsAsync("$", value);
    }

    @Override
    public boolean setIfExists(String path, Object value) {
        return this.get(this.setIfExistsAsync(path, value));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(String path, Object value) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.JSON_SET_BOOLEAN, this.getRawName(), path, this.encode(value), "XX");
    }

    @Override
    public boolean setIfExists(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.setIfExistsAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('json.set', KEYS[1], '$', ARGV[1], 'XX'); if currValue ~= false then redis.call('pexpire', KEYS[1], ARGV[2]); return 1;end;return 0; ", Collections.singletonList(this.getRawName()), this.encode(value), timeUnit.toMillis(timeToLive));
    }

    @Override
    public boolean setIfExists(V value, Duration duration) {
        return this.get(this.setIfExistsAsync(value, duration));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value, Duration duration) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('json.set', KEYS[1], '$', ARGV[1], 'XX'); if currValue ~= false then redis.call('pexpire', KEYS[1], ARGV[2]); return 1;end;return 0; ", Collections.singletonList(this.getRawName()), this.encode(value), duration.toMillis());
    }

    @Override
    public boolean compareAndSet(V expect, V update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(V expect, V update) {
        if (expect == null && update == null) {
            return this.trySetAsync(null);
        }
        if (expect == null) {
            return this.trySetAsync(update);
        }
        return this.compareAndSetUpdateAsync("$", expect, update);
    }

    @Override
    public boolean compareAndSet(String path, Object expect, Object update) {
        return this.get(this.compareAndSetAsync(path, expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(String path, Object expect, Object update) {
        if (path == null) {
            throw new NullPointerException("path can't be null");
        }
        if (expect == null && update == null) {
            return this.trySetAsync(path, null);
        }
        if (expect == null) {
            return this.trySetAsync(path, update);
        }
        if (path.startsWith("$")) {
            expect = Arrays.asList(expect);
        }
        return this.compareAndSetUpdateAsync(path, expect, update);
    }

    protected RFuture<Boolean> compareAndSetUpdateAsync(String path, Object expect, Object update) {
        if (update == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('json.get', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('json.del', KEYS[1], ARGV[1]); return 1 else return 0 end;", Collections.singletonList(this.getRawName()), path, this.encode(expect));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('json.get', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('json.set', KEYS[1], ARGV[1], ARGV[3]); return 1 else return 0 end", Collections.singletonList(this.getRawName()), path, this.encode(expect), this.encode(update));
    }

    @Override
    public V getAndSet(V newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<V> getAndSetAsync(V newValue) {
        if (newValue == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('json.get', KEYS[1]); redis.call('json.del', KEYS[1]); return v", Collections.singletonList(this.getRawName()), new Object[0]);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1]); redis.call('json.set', KEYS[1], '$', ARGV[1]); return currValue; ", Collections.singletonList(this.getRawName()), this.encode(newValue));
    }

    @Override
    public <T> T getAndSet(JsonCodec<T> codec, String path, Object newValue) {
        return this.get(this.getAndSetAsync(codec, path, newValue));
    }

    @Override
    public <T> RFuture<T> getAndSetAsync(JsonCodec<T> codec, String path, Object newValue) {
        if (newValue == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.EVAL_OBJECT, "local v = redis.call('json.get', KEYS[1], ARGV[1]); redis.call('json.del', KEYS[1]); return v", Collections.singletonList(this.getRawName()), path);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1], ARGV[1]); redis.call('json.set', KEYS[1], ARGV[1], ARGV[2]); return currValue; ", Collections.singletonList(this.getRawName()), path, this.encode(newValue));
    }

    @Override
    public V getAndSet(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.getAndSetAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('json.get', KEYS[1]); redis.call('json.del', KEYS[1]); return v", Collections.singletonList(this.getRawName()), new Object[0]);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1]); redis.call('json.set', KEYS[1], '$', ARGV[1]); redis.call('pexpire', KEYS[1], ARGV[2]); return currValue; ", Collections.singletonList(this.getRawName()), this.encode(value), timeUnit.toMillis(timeToLive));
    }

    @Override
    public V getAndSet(V value, Duration duration) {
        return this.get(this.getAndSetAsync(value, duration));
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, Duration duration) {
        if (value == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('json.get', KEYS[1]); redis.call('json.del', KEYS[1]); return v", Collections.singletonList(this.getRawName()), new Object[0]);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1]); redis.call('json.set', KEYS[1], '$', ARGV[1]); redis.call('pexpire', KEYS[1], ARGV[2]); return currValue; ", Collections.singletonList(this.getRawName()), this.encode(value), duration.toMillis());
    }

    @Override
    public V getAndExpire(Duration duration) {
        return this.get(this.getAndExpireAsync(duration));
    }

    @Override
    public RFuture<V> getAndExpireAsync(Duration duration) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1]); redis.call('pexpire', KEYS[1], ARGV[1]); return currValue; ", Collections.singletonList(this.getRawName()), duration.toMillis());
    }

    @Override
    public V getAndExpire(Instant time) {
        return this.get(this.getAndExpireAsync(time));
    }

    @Override
    public RFuture<V> getAndExpireAsync(Instant time) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1]); redis.call('pexpireat', KEYS[1], ARGV[1]); return currValue; ", Collections.singletonList(this.getRawName()), time.toEpochMilli());
    }

    @Override
    public V getAndClearExpire() {
        return this.get(this.getAndClearExpireAsync());
    }

    @Override
    public RFuture<V> getAndClearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('json.get', KEYS[1]); redis.call('persist', KEYS[1]); return currValue; ", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public void set(V value) {
        this.get(this.setAsync(value));
    }

    @Override
    public RFuture<Void> setAsync(V value) {
        return this.setAsync("$", value);
    }

    @Override
    public void set(String path, Object value) {
        this.get(this.setAsync(path, value));
    }

    @Override
    public RFuture<Void> setAsync(String path, Object value) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.JSON_SET, this.getRawName(), path, this.encode(value));
    }

    @Override
    public void set(V value, long timeToLive, TimeUnit timeUnit) {
        this.get(this.setAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "redis.call('json.set', KEYS[1], '$', ARGV[1]); redis.call('pexpire', KEYS[1], ARGV[2]); ", Collections.singletonList(this.getRawName()), this.encode(value), timeUnit.toMillis(timeToLive));
    }

    @Override
    public void set(V value, Duration duration) {
        this.get(this.setAsync(value, duration));
    }

    @Override
    public RFuture<Void> setAsync(V value, Duration duration) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "redis.call('json.set', KEYS[1], '$', ARGV[1]); redis.call('pexpire', KEYS[1], ARGV[2]); ", Collections.singletonList(this.getRawName()), this.encode(value), duration.toMillis());
    }

    @Override
    public void setAndKeepTTL(V value) {
        this.get(this.setAndKeepTTLAsync(value));
    }

    @Override
    public RFuture<Void> setAndKeepTTLAsync(V value) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "local ttl = redis.call('pttl', KEYS[1]);redis.call('json.set', KEYS[1], '$', ARGV[1]); if ttl > 0 thenredis.call('pexpire', KEYS[1], ttl); end;", Collections.singletonList(this.getRawName()), this.encode(value));
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.JSON_DEL_BOOLEAN, this.getRawName());
    }

    @Override
    public long stringAppend(String path, Object value) {
        return this.get(this.stringAppendAsync(path, value));
    }

    @Override
    public RFuture<Long> stringAppendAsync(String path, Object value) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_STRAPPEND, this.getRawName(), path, this.encode(value));
    }

    @Override
    public List<Long> stringAppendMulti(String path, Object value) {
        return this.get(this.stringAppendMultiAsync(path, value));
    }

    @Override
    public RFuture<List<Long>> stringAppendMultiAsync(String path, Object value) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_STRAPPEND_LIST, this.getRawName(), path, this.encode(value));
    }

    @Override
    public long arrayAppend(String path, Object ... values) {
        return this.get(this.arrayAppendAsync(path, values));
    }

    @Override
    public RFuture<Long> arrayAppendAsync(String path, Object ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 2);
        args.add(this.getRawName());
        args.add(path);
        this.encode(args, Arrays.asList(values));
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRAPPEND, args.toArray());
    }

    @Override
    public List<Long> arrayAppendMulti(String path, Object ... values) {
        return this.get(this.arrayAppendMultiAsync(path, values));
    }

    @Override
    public RFuture<List<Long>> arrayAppendMultiAsync(String path, Object ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 2);
        args.add(this.getRawName());
        args.add(path);
        this.encode(args, Arrays.asList(values));
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRAPPEND_LIST, args.toArray());
    }

    @Override
    public long arrayIndex(String path, Object value) {
        return this.get(this.arrayIndexAsync(path, value));
    }

    @Override
    public RFuture<Long> arrayIndexAsync(String path, Object value) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRINDEX, this.getRawName(), path, this.encode(value));
    }

    @Override
    public List<Long> arrayIndexMulti(String path, Object value) {
        return this.get(this.arrayIndexMultiAsync(path, value));
    }

    @Override
    public RFuture<List<Long>> arrayIndexMultiAsync(String path, Object value) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRINDEX_LIST, this.getRawName(), path, this.encode(value));
    }

    @Override
    public long arrayIndex(String path, Object value, long start, long end) {
        return this.get(this.arrayIndexAsync(path, value, start, end));
    }

    @Override
    public RFuture<Long> arrayIndexAsync(String path, Object value, long start, long end) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRINDEX, this.getRawName(), path, this.encode(value), start, end);
    }

    @Override
    public List<Long> arrayIndexMulti(String path, Object value, long start, long end) {
        return this.get(this.arrayIndexMultiAsync(path, value, start, end));
    }

    @Override
    public RFuture<List<Long>> arrayIndexMultiAsync(String path, Object value, long start, long end) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRINDEX_LIST, this.getRawName(), path, this.encode(value), start, end);
    }

    @Override
    public long arrayInsert(String path, long index, Object ... values) {
        return this.get(this.arrayInsertAsync(path, index, values));
    }

    @Override
    public RFuture<Long> arrayInsertAsync(String path, long index, Object ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 3);
        args.add(this.getRawName());
        args.add(path);
        args.add(index);
        this.encode(args, Arrays.asList(values));
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRINSERT, args.toArray());
    }

    @Override
    public List<Long> arrayInsertMulti(String path, long index, Object ... values) {
        return this.get(this.arrayInsertMultiAsync(path, index, values));
    }

    @Override
    public RFuture<List<Long>> arrayInsertMultiAsync(String path, long index, Object ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 3);
        args.add(this.getRawName());
        args.add(path);
        args.add(index);
        this.encode(args, Arrays.asList(values));
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRINSERT_LIST, args.toArray());
    }

    @Override
    public long arraySize(String path) {
        return this.get(this.arraySizeAsync(path));
    }

    @Override
    public RFuture<Long> arraySizeAsync(String path) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRLEN, this.getRawName(), path);
    }

    @Override
    public List<Long> arraySizeMulti(String path) {
        return this.get(this.arraySizeMultiAsync(path));
    }

    @Override
    public RFuture<List<Long>> arraySizeMultiAsync(String path) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRLEN_LIST, this.getRawName(), path);
    }

    @Override
    public <T> T arrayPollLast(JsonCodec<T> codec, String path) {
        return this.get(this.arrayPollLastAsync(codec, path));
    }

    @Override
    public <T> RFuture<T> arrayPollLastAsync(JsonCodec<T> codec, String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.JSON_ARRPOP, this.getRawName(), path);
    }

    @Override
    public <T> List<T> arrayPollLastMulti(JsonCodec<T> codec, String path) {
        return this.get(this.arrayPollLastMultiAsync(codec, path));
    }

    @Override
    public <T> RFuture<List<T>> arrayPollLastMultiAsync(JsonCodec<T> codec, String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.JSON_ARRPOP_LIST, this.getRawName(), path);
    }

    @Override
    public <T> T arrayPollFirst(JsonCodec<T> codec, String path) {
        return this.get(this.arrayPollFirstAsync(codec, path));
    }

    @Override
    public <T> RFuture<T> arrayPollFirstAsync(JsonCodec<T> codec, String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.JSON_ARRPOP, this.getRawName(), path, 0);
    }

    @Override
    public <T> List<T> arrayPollFirstMulti(JsonCodec<T> codec, String path) {
        return this.get(this.arrayPollFirstMultiAsync(codec, path));
    }

    @Override
    public <T> RFuture<List<T>> arrayPollFirstMultiAsync(JsonCodec<T> codec, String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.JSON_ARRPOP_LIST, this.getRawName(), path, 0);
    }

    @Override
    public <T> T arrayPop(JsonCodec<T> codec, String path, long index) {
        return this.get(this.arrayPopAsync(codec, path, index));
    }

    @Override
    public <T> RFuture<T> arrayPopAsync(JsonCodec<T> codec, String path, long index) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.JSON_ARRPOP, this.getRawName(), path, index);
    }

    @Override
    public <T> List<T> arrayPopMulti(JsonCodec<T> codec, String path, long index) {
        return this.get(this.arrayPopMultiAsync(codec, path, index));
    }

    @Override
    public <T> RFuture<List<T>> arrayPopMultiAsync(JsonCodec<T> codec, String path, long index) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)new JsonCodecWrapper(codec), RedisCommands.JSON_ARRPOP_LIST, this.getRawName(), path, index);
    }

    @Override
    public long arrayTrim(String path, long start, long end) {
        return this.get(this.arrayTrimAsync(path, start, end));
    }

    @Override
    public RFuture<Long> arrayTrimAsync(String path, long start, long end) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRTRIM, this.getRawName(), path, start, end);
    }

    @Override
    public List<Long> arrayTrimMulti(String path, long start, long end) {
        return this.get(this.arrayTrimMultiAsync(path, start, end));
    }

    @Override
    public RFuture<List<Long>> arrayTrimMultiAsync(String path, long start, long end) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_ARRTRIM_LIST, this.getRawName(), path, start, end);
    }

    @Override
    public long clear() {
        return this.get(this.clearAsync());
    }

    @Override
    public RFuture<Long> clearAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_CLEAR, this.getRawName());
    }

    @Override
    public long clear(String path) {
        return this.get(this.clearAsync(path));
    }

    @Override
    public RFuture<Long> clearAsync(String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_CLEAR, this.getRawName(), path);
    }

    @Override
    public <T extends Number> T incrementAndGet(String path, T delta) {
        return this.get(this.incrementAndGetAsync(path, delta));
    }

    @Override
    public <T extends Number> RFuture<T> incrementAndGetAsync(String path, T delta) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("JSON.NUMINCRBY", new NumberConvertor(delta.getClass())), this.getRawName(), path, new BigDecimal(delta.toString()).toPlainString());
    }

    @Override
    public <T extends Number> List<T> incrementAndGetMulti(String path, T delta) {
        return this.get(this.incrementAndGetMultiAsync(path, delta));
    }

    @Override
    public <T extends Number> RFuture<List<T>> incrementAndGetMultiAsync(String path, T delta) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("JSON.NUMINCRBY", new ObjectListReplayDecoder(), new NumberConvertor(delta.getClass())), this.getRawName(), path, new BigDecimal(delta.toString()).toPlainString());
    }

    @Override
    public long countKeys() {
        return this.get(this.countKeysAsync());
    }

    @Override
    public RFuture<Long> countKeysAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_OBJLEN, this.getRawName());
    }

    @Override
    public long countKeys(String path) {
        return this.get(this.countKeysAsync(path));
    }

    @Override
    public RFuture<Long> countKeysAsync(String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_OBJLEN, this.getRawName(), path);
    }

    @Override
    public List<Long> countKeysMulti(String path) {
        return this.get(this.countKeysMultiAsync(path));
    }

    @Override
    public RFuture<List<Long>> countKeysMultiAsync(String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_OBJLEN_LIST, this.getRawName(), path);
    }

    @Override
    public List<String> getKeys() {
        return this.get(this.getKeysAsync());
    }

    @Override
    public RFuture<List<String>> getKeysAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_OBJKEYS, this.getRawName());
    }

    @Override
    public List<String> getKeys(String path) {
        return this.get(this.getKeysAsync(path));
    }

    @Override
    public RFuture<List<String>> getKeysAsync(String path) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_OBJKEYS, this.getRawName(), path);
    }

    @Override
    public List<List<String>> getKeysMulti(String path) {
        return this.get(this.getKeysMultiAsync(path));
    }

    @Override
    public RFuture<List<List<String>>> getKeysMultiAsync(String path) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_OBJKEYS_LIST, this.getRawName(), path);
    }

    @Override
    public boolean toggle(String path) {
        return this.get(this.toggleAsync(path));
    }

    @Override
    public RFuture<Boolean> toggleAsync(String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_TOGGLE, this.getRawName(), path);
    }

    @Override
    public List<Boolean> toggleMulti(String path) {
        return this.get(this.toggleMultiAsync(path));
    }

    @Override
    public RFuture<List<Boolean>> toggleMultiAsync(String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.JSON_TOGGLE_LIST, this.getRawName(), path);
    }

    @Override
    public JsonType getType() {
        return this.get(this.getTypeAsync());
    }

    @Override
    public RFuture<JsonType> getTypeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.JSON_TYPE, this.getRawName());
    }

    @Override
    public JsonType getType(String path) {
        return this.get(this.getTypeAsync(path));
    }

    @Override
    public RFuture<JsonType> getTypeAsync(String path) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.JSON_TYPE, this.getRawName(), path);
    }

    @Override
    public long delete(String path) {
        return this.get(this.deleteAsync(path));
    }

    @Override
    public RFuture<Long> deleteAsync(String path) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.JSON_DEL_LONG, this.getRawName(), path);
    }
}

