/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.JsonJacksonCodec;

public class ProtobufCodec
extends BaseCodec {
    private final Class<?> mapKeyClass;
    private final Class<?> mapValueClass;
    private final Class<?> valueClass;
    private final Set<String> protobufBlacklist;
    private final Codec blacklistCodec;

    public ProtobufCodec(Class<?> mapKeyClass, Class<?> mapValueClass) {
        this(mapKeyClass, mapValueClass, null, null);
    }

    public ProtobufCodec(Class<?> mapKeyClass, Class<?> mapValueClass, Codec blacklistCodec) {
        this(mapKeyClass, mapValueClass, null, blacklistCodec);
    }

    public ProtobufCodec(Class<?> valueClass) {
        this(null, null, valueClass, null);
    }

    public ProtobufCodec(Class<?> valueClass, Codec blacklistCodec) {
        this(null, null, valueClass, blacklistCodec);
    }

    private ProtobufCodec(Class<?> mapKeyClass, Class<?> mapValueClass, Class<?> valueClass, Codec blacklistCodec) {
        this.mapKeyClass = mapKeyClass;
        this.mapValueClass = mapValueClass;
        this.valueClass = valueClass;
        if (blacklistCodec == null) {
            this.blacklistCodec = new JsonJacksonCodec();
        } else {
            if (blacklistCodec instanceof ProtobufCodec) {
                throw new IllegalArgumentException("BlacklistCodec can not be ProtobufCodec");
            }
            this.blacklistCodec = blacklistCodec;
        }
        this.protobufBlacklist = new HashSet<String>();
        this.protobufBlacklist.addAll(BasicSerializerFactoryConcreteGetter.getConcreteKeySet());
        this.protobufBlacklist.add(ArrayList.class.getName());
        this.protobufBlacklist.add(HashSet.class.getName());
        this.protobufBlacklist.add(HashMap.class.getName());
    }

    public void addBlacklist(Class<?> clazz) {
        this.protobufBlacklist.add(clazz.getName());
    }

    public void removeBlacklist(Class<?> clazz) {
        this.protobufBlacklist.remove(clazz.getName());
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.createDecoder(this.valueClass, this.blacklistCodec.getValueDecoder());
    }

    @Override
    public Encoder getValueEncoder() {
        return this.createEncoder(this.valueClass, this.blacklistCodec.getValueEncoder());
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.createDecoder(this.mapValueClass, this.blacklistCodec.getMapValueDecoder());
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.createEncoder(this.mapValueClass, this.blacklistCodec.getMapValueEncoder());
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.createDecoder(this.mapKeyClass, this.blacklistCodec.getMapKeyDecoder());
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.createEncoder(this.mapKeyClass, this.blacklistCodec.getMapKeyEncoder());
    }

    private Decoder<Object> createDecoder(final Class<?> clazz, final Decoder<Object> blacklistDecoder) {
        if (clazz == null) {
            throw new IllegalArgumentException("class to create protobuf decoder can not be null");
        }
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                if (ProtobufCodec.this.protobufBlacklist.contains(clazz.getName())) {
                    return blacklistDecoder.decode(buf, state);
                }
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                if (MessageLite.class.isAssignableFrom(clazz)) {
                    try {
                        return clazz.getDeclaredMethod("parseFrom", byte[].class).invoke((Object)clazz, new Object[]{bytes});
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                return ProtostuffUtils.deserialize(bytes, clazz);
            }
        };
    }

    private Encoder createEncoder(final Class<?> clazz, final Encoder blacklistEncoder) {
        if (clazz == null) {
            throw new IllegalArgumentException("class to create protobuf encoder can not be null");
        }
        return new Encoder(){

            @Override
            public ByteBuf encode(Object in) throws IOException {
                if (ProtobufCodec.this.protobufBlacklist.contains(clazz.getName())) {
                    return blacklistEncoder.encode(in);
                }
                ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
                if (MessageLite.class.isAssignableFrom(clazz)) {
                    out.writeBytes(((MessageLite)in).toByteArray());
                } else {
                    out.writeBytes(ProtostuffUtils.serialize(in));
                }
                return out;
            }
        };
    }

    private static abstract class BasicSerializerFactoryConcreteGetter
    extends BasicSerializerFactory {
        protected BasicSerializerFactoryConcreteGetter(SerializerFactoryConfig config) {
            super(config);
        }

        private static Set<String> getConcreteKeySet() {
            HashSet<String> concreteKeySet = new HashSet<String>();
            if (_concrete != null && !_concrete.isEmpty()) {
                concreteKeySet.addAll(_concrete.keySet());
            }
            if (_concreteLazy != null && !_concreteLazy.isEmpty()) {
                concreteKeySet.addAll(_concreteLazy.keySet());
            }
            return concreteKeySet;
        }
    }

    private static class ProtostuffUtils {
        private ProtostuffUtils() {
        }

        public static <T> byte[] serialize(T obj) {
            LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
            try {
                byte[] byArray = ProtostuffIOUtil.toByteArray(obj, (Schema)RuntimeSchema.getSchema(obj.getClass()), (LinkedBuffer)buffer);
                return byArray;
            }
            finally {
                buffer.clear();
            }
        }

        public static <T> T deserialize(byte[] data, Class<T> clazz) {
            Schema schema = RuntimeSchema.getSchema(clazz);
            Object obj = schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)obj, (Schema)schema);
            return (T)obj;
        }
    }
}

