/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

public class ClusterSlotRange {
    private final int startSlot;
    private final int endSlot;

    public ClusterSlotRange(int startSlot, int endSlot) {
        this.startSlot = startSlot;
        this.endSlot = endSlot;
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    public int getEndSlot() {
        return this.endSlot;
    }

    public boolean hasSlot(int slot) {
        return slot >= this.startSlot && slot <= this.endSlot;
    }

    public int size() {
        return this.endSlot - this.startSlot + 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endSlot;
        result = 31 * result + this.startSlot;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterSlotRange other = (ClusterSlotRange)obj;
        if (this.endSlot != other.endSlot) {
            return false;
        }
        return this.startSlot == other.startSlot;
    }

    public String toString() {
        return "[" + this.startSlot + "-" + this.endSlot + "]";
    }
}

