/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import io.netty.util.Timeout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.redisson.PubSubPatternStatusListener;
import org.redisson.PubSubStatusListener;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisNodeNotFoundException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.SubscribeListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.AsyncSemaphore;
import org.redisson.pubsub.CountDownLatchPubSub;
import org.redisson.pubsub.LockPubSub;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.SemaphorePubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishSubscribeService {
    private static final Logger log = LoggerFactory.getLogger(PublishSubscribeService.class);
    private final ConnectionManager connectionManager;
    private final MasterSlaveServersConfig config;
    private final AsyncSemaphore[] locks = new AsyncSemaphore[50];
    private final AsyncSemaphore freePubSubLock = new AsyncSemaphore(1);
    private final Map<ChannelName, Collection<MasterSlaveEntry>> name2entry = new ConcurrentHashMap<ChannelName, Collection<MasterSlaveEntry>>();
    private final ConcurrentMap<PubSubKey, PubSubConnectionEntry> name2PubSubConnection = new ConcurrentHashMap<PubSubKey, PubSubConnectionEntry>();
    private final ConcurrentMap<MasterSlaveEntry, PubSubEntry> entry2PubSubConnection = new ConcurrentHashMap<MasterSlaveEntry, PubSubEntry>();
    private final SemaphorePubSub semaphorePubSub = new SemaphorePubSub(this);
    private final CountDownLatchPubSub countDownLatchPubSub = new CountDownLatchPubSub(this);
    private final LockPubSub lockPubSub = new LockPubSub(this);
    private boolean shardingSupported = false;
    private final Map<PubSubType, PubSubType> subscribe2unsubscribe = new HashMap<PubSubType, PubSubType>();

    public PublishSubscribeService(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.config = connectionManager.getServiceManager().getConfig();
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new AsyncSemaphore(1);
        }
        this.subscribe2unsubscribe.put(PubSubType.SUBSCRIBE, PubSubType.UNSUBSCRIBE);
        this.subscribe2unsubscribe.put(PubSubType.SSUBSCRIBE, PubSubType.SUNSUBSCRIBE);
        this.subscribe2unsubscribe.put(PubSubType.PSUBSCRIBE, PubSubType.PUNSUBSCRIBE);
    }

    public LockPubSub getLockPubSub() {
        return this.lockPubSub;
    }

    public CountDownLatchPubSub getCountDownLatchPubSub() {
        return this.countDownLatchPubSub;
    }

    public SemaphorePubSub getSemaphorePubSub() {
        return this.semaphorePubSub;
    }

    private PubSubConnectionEntry getPubSubEntry(ChannelName channelName) {
        return (PubSubConnectionEntry)this.name2PubSubConnection.get(this.createKey(channelName));
    }

    public int countListeners(ChannelName channelName) {
        PubSubConnectionEntry entry = this.getPubSubEntry(channelName);
        if (entry != null) {
            return entry.countListeners(channelName);
        }
        return 0;
    }

    public boolean hasEntry(ChannelName channelName) {
        return this.getPubSubEntry(channelName) != null;
    }

    public CompletableFuture<Collection<PubSubConnectionEntry>> psubscribe(ChannelName channelName, Codec codec, RedisPubSubListener<?> ... listeners) {
        if (this.isMultiEntity(channelName)) {
            Collection<MasterSlaveEntry> entrySet = this.connectionManager.getEntrySet();
            final AtomicInteger statusCounter = new AtomicInteger(entrySet.size());
            RedisPubSubListener[] ls = (RedisPubSubListener[])Arrays.stream(listeners).map(l -> {
                if (l instanceof PubSubPatternStatusListener) {
                    return new PubSubPatternStatusListener((PubSubPatternStatusListener)l){

                        @Override
                        public void onStatus(PubSubType type, CharSequence channel) {
                            if (statusCounter.decrementAndGet() == 0) {
                                super.onStatus(type, channel);
                            }
                        }
                    };
                }
                return l;
            }).toArray(RedisPubSubListener[]::new);
            ArrayList<CompletableFuture<PubSubConnectionEntry>> futures = new ArrayList<CompletableFuture<PubSubConnectionEntry>>();
            for (MasterSlaveEntry entry : entrySet) {
                CompletableFuture<PubSubConnectionEntry> future = this.subscribe(PubSubType.PSUBSCRIBE, codec, channelName, entry, null, ls);
                futures.add(future);
            }
            CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return future.thenApply(r -> futures.stream().map(v -> v.getNow(null)).collect(Collectors.toList()));
        }
        MasterSlaveEntry entry = this.getEntry(channelName);
        if (entry == null) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for name: " + channelName + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.");
            CompletableFuture<Collection<PubSubConnectionEntry>> promise = new CompletableFuture<Collection<PubSubConnectionEntry>>();
            promise.completeExceptionally(ex);
            return promise;
        }
        CompletableFuture<PubSubConnectionEntry> f = this.subscribe(PubSubType.PSUBSCRIBE, codec, channelName, entry, null, listeners);
        return f.thenApply(res -> Collections.singletonList(res));
    }

    public boolean isMultiEntity(ChannelName channelName) {
        return this.connectionManager.isClusterMode() && (channelName.toString().startsWith("__keyspace@") || channelName.toString().startsWith("__keyevent@"));
    }

    public CompletableFuture<PubSubConnectionEntry> subscribe(MasterSlaveEntry entry, ClientConnectionsEntry clientEntry, Codec codec, ChannelName channelName, RedisPubSubListener<?> ... listeners) {
        return this.subscribe(PubSubType.SUBSCRIBE, codec, channelName, entry, clientEntry, listeners);
    }

    public CompletableFuture<List<PubSubConnectionEntry>> subscribe(Codec codec, ChannelName channelName, RedisPubSubListener<?> ... listeners) {
        if (this.isMultiEntity(channelName)) {
            Collection<MasterSlaveEntry> entrySet = this.connectionManager.getEntrySet();
            final AtomicInteger statusCounter = new AtomicInteger(entrySet.size());
            RedisPubSubListener[] ls = (RedisPubSubListener[])Arrays.stream(listeners).map(l -> {
                if (l instanceof PubSubStatusListener) {
                    return new PubSubStatusListener(((PubSubStatusListener)l).getListener(), ((PubSubStatusListener)l).getName()){

                        @Override
                        public void onStatus(PubSubType type, CharSequence channel) {
                            if (statusCounter.decrementAndGet() == 0) {
                                super.onStatus(type, channel);
                            }
                        }
                    };
                }
                return l;
            }).toArray(RedisPubSubListener[]::new);
            ArrayList<CompletableFuture<PubSubConnectionEntry>> futures = new ArrayList<CompletableFuture<PubSubConnectionEntry>>();
            for (MasterSlaveEntry entry : entrySet) {
                CompletableFuture<PubSubConnectionEntry> future = this.subscribe(PubSubType.SUBSCRIBE, codec, channelName, entry, null, ls);
                futures.add(future);
            }
            CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return future.thenApply(r -> futures.stream().map(v -> v.getNow(null)).collect(Collectors.toList()));
        }
        MasterSlaveEntry entry = this.getEntry(channelName);
        if (entry == null) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for name: " + channelName + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.");
            CompletableFuture<List<PubSubConnectionEntry>> promise = new CompletableFuture<List<PubSubConnectionEntry>>();
            promise.completeExceptionally(ex);
            return promise;
        }
        CompletableFuture<PubSubConnectionEntry> f = this.subscribe(PubSubType.SUBSCRIBE, codec, channelName, entry, null, listeners);
        return f.thenApply(res -> Collections.singletonList(res));
    }

    public CompletableFuture<PubSubConnectionEntry> ssubscribe(Codec codec, ChannelName channelName, RedisPubSubListener<?> ... listeners) {
        MasterSlaveEntry entry = this.getEntry(channelName);
        if (entry == null) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for name: " + channelName + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.");
            CompletableFuture<PubSubConnectionEntry> promise = new CompletableFuture<PubSubConnectionEntry>();
            promise.completeExceptionally(ex);
            return promise;
        }
        return this.subscribe(PubSubType.SSUBSCRIBE, codec, channelName, entry, null, listeners);
    }

    private CompletableFuture<PubSubConnectionEntry> subscribe(PubSubType type, Codec codec, ChannelName channelName, MasterSlaveEntry entry, ClientConnectionsEntry clientEntry, RedisPubSubListener<?> ... listeners) {
        CompletableFuture<PubSubConnectionEntry> promise = new CompletableFuture<PubSubConnectionEntry>();
        AsyncSemaphore lock = this.getSemaphore(channelName);
        int timeout = this.config.getTimeout() + this.config.getRetryInterval() * this.config.getRetryAttempts();
        Timeout lockTimeout = this.connectionManager.getServiceManager().newTimeout(t -> promise.completeExceptionally(new RedisTimeoutException("Unable to acquire subscription lock after " + timeout + "ms. Try to increase 'timeout', 'subscriptionsPerConnection', 'subscriptionConnectionPoolSize' parameters.")), timeout, TimeUnit.MILLISECONDS);
        lock.acquire().thenAccept(r -> {
            if (!lockTimeout.cancel() || promise.isDone()) {
                lock.release();
                return;
            }
            this.subscribeNoTimeout(codec, channelName, entry, clientEntry, promise, type, lock, new AtomicInteger(), listeners);
            this.timeout(promise);
        });
        return promise;
    }

    public CompletableFuture<PubSubConnectionEntry> subscribeNoTimeout(Codec codec, String channelName, AsyncSemaphore semaphore, RedisPubSubListener<?> ... listeners) {
        MasterSlaveEntry entry = this.getEntry(new ChannelName(channelName));
        if (entry == null) {
            CompletableFuture<PubSubConnectionEntry> promise = new CompletableFuture<PubSubConnectionEntry>();
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for name: " + channelName + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.");
            promise.completeExceptionally(ex);
            return promise;
        }
        PubSubType type = this.shardingSupported ? PubSubType.SSUBSCRIBE : PubSubType.SUBSCRIBE;
        CompletableFuture<PubSubConnectionEntry> promise = new CompletableFuture<PubSubConnectionEntry>();
        this.subscribeNoTimeout(codec, new ChannelName(channelName), entry, null, promise, type, semaphore, new AtomicInteger(), listeners);
        return promise;
    }

    public AsyncSemaphore getSemaphore(ChannelName channelName) {
        return this.locks[Math.abs(channelName.hashCode() % this.locks.length)];
    }

    private PubSubKey createKey(ChannelName channelName) {
        MasterSlaveEntry entry = this.getEntry(channelName);
        return new PubSubKey(channelName, entry);
    }

    public void timeout(CompletableFuture<?> promise) {
        int timeout = this.config.getTimeout() + this.config.getRetryInterval() * this.config.getRetryAttempts();
        this.timeout(promise, timeout);
    }

    public void timeout(CompletableFuture<?> promise, long timeout) {
        Timeout task = this.connectionManager.getServiceManager().newTimeout(t -> promise.completeExceptionally(new RedisTimeoutException("Unable to acquire subscription lock after " + timeout + "ms. Try to increase 'timeout', 'subscriptionsPerConnection', 'subscriptionConnectionPoolSize' parameters.")), timeout, TimeUnit.MILLISECONDS);
        promise.whenComplete((r, e) -> task.cancel());
    }

    private void trySubscribe(Codec codec, ChannelName channelName, CompletableFuture<PubSubConnectionEntry> promise, PubSubType type, AsyncSemaphore lock, AtomicInteger attempts, RedisPubSubListener<?> ... listeners) {
        if (attempts.get() == this.config.getRetryAttempts()) {
            lock.release();
            MasterSlaveEntry entry = this.getEntry(channelName);
            if (entry == null) {
                RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for name: " + channelName + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.");
                promise.completeExceptionally(ex);
                return;
            }
            promise.completeExceptionally(new RedisTimeoutException("Unable to acquire connection for subscription after " + attempts.get() + " attempts. Increase 'subscriptionsPerConnection' and/or 'subscriptionConnectionPoolSize' parameters."));
            return;
        }
        attempts.incrementAndGet();
        MasterSlaveEntry entry = this.getEntry(channelName);
        if (entry == null) {
            this.connectionManager.getServiceManager().newTimeout(tt -> this.trySubscribe(codec, channelName, promise, type, lock, attempts, listeners), this.config.getRetryInterval(), TimeUnit.MILLISECONDS);
            return;
        }
        this.subscribeNoTimeout(codec, channelName, entry, null, promise, type, lock, attempts, listeners);
    }

    private void subscribeNoTimeout(Codec codec, ChannelName channelName, MasterSlaveEntry entry, ClientConnectionsEntry clientEntry, CompletableFuture<PubSubConnectionEntry> promise, PubSubType type, AsyncSemaphore lock, AtomicInteger attempts, RedisPubSubListener<?> ... listeners) {
        PubSubConnectionEntry connEntry = (PubSubConnectionEntry)this.name2PubSubConnection.get(new PubSubKey(channelName, entry));
        if (connEntry != null) {
            this.addListeners(channelName, promise, type, lock, connEntry, listeners);
            return;
        }
        this.freePubSubLock.acquire().thenAccept(c -> {
            if (promise.isDone()) {
                lock.release();
                this.freePubSubLock.release();
                return;
            }
            PubSubEntry freePubSubConnections = this.entry2PubSubConnection.getOrDefault(entry, new PubSubEntry());
            PubSubConnectionEntry freeEntry = freePubSubConnections.getEntries().peek();
            if (freeEntry == null) {
                this.freePubSubLock.release();
                this.connect(codec, channelName, entry, clientEntry, promise, type, lock, attempts, listeners);
                return;
            }
            int remainFreeAmount = freeEntry.tryAcquire();
            if (remainFreeAmount == -1) {
                throw new IllegalStateException();
            }
            PubSubKey key = new PubSubKey(channelName, entry);
            PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(key, freeEntry);
            if (oldEntry != null) {
                freeEntry.release();
                this.freePubSubLock.release();
                this.addListeners(channelName, promise, type, lock, oldEntry, listeners);
                return;
            }
            Collection coll = this.name2entry.computeIfAbsent(channelName, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
            coll.add(entry);
            if (remainFreeAmount == 0) {
                freePubSubConnections.getEntries().poll();
            }
            this.freePubSubLock.release();
            CompletableFuture<PubSubConnectionEntry> pp = new CompletableFuture<PubSubConnectionEntry>();
            pp.whenComplete((r, e) -> {
                if (e != null) {
                    PubSubType unsubscribeType = this.subscribe2unsubscribe.get((Object)type);
                    CompletableFuture<Codec> f = this.unsubscribe(channelName, unsubscribeType);
                    f.whenComplete((rr, ee) -> promise.completeExceptionally((Throwable)e));
                    return;
                }
                promise.complete((PubSubConnectionEntry)r);
            });
            CompletableFuture<Void> subscribeFuture = this.addListeners(channelName, pp, type, lock, freeEntry, listeners);
            freeEntry.subscribe(codec, type, channelName, subscribeFuture);
        });
    }

    private MasterSlaveEntry getEntry(ChannelName channelName) {
        int slot = this.connectionManager.calcSlot(channelName.getName());
        return this.connectionManager.getWriteEntry(slot);
    }

    private CompletableFuture<Void> addListeners(ChannelName channelName, CompletableFuture<PubSubConnectionEntry> promise, PubSubType type, AsyncSemaphore lock, PubSubConnectionEntry connEntry, RedisPubSubListener<?> ... listeners) {
        for (RedisPubSubListener<?> listener : listeners) {
            connEntry.addListener(channelName, listener);
        }
        SubscribeListener list = connEntry.getSubscribeFuture(channelName, type);
        CompletableFuture<Void> subscribeFuture = list.getSuccessFuture();
        subscribeFuture.whenComplete((res, e) -> {
            if (e != null) {
                promise.completeExceptionally((Throwable)e);
                lock.release();
                return;
            }
            if (!promise.complete(connEntry)) {
                for (RedisPubSubListener listener : listeners) {
                    connEntry.removeListener(channelName, listener);
                }
                if (!connEntry.hasListeners(channelName)) {
                    this.unsubscribeLocked(type, channelName).whenComplete((r, ex) -> lock.release());
                } else {
                    lock.release();
                }
            } else {
                lock.release();
            }
        });
        return subscribeFuture;
    }

    private void connect(Codec codec, ChannelName channelName, MasterSlaveEntry msEntry, ClientConnectionsEntry clientEntry, CompletableFuture<PubSubConnectionEntry> promise, PubSubType type, AsyncSemaphore lock, AtomicInteger attempts, RedisPubSubListener<?> ... listeners) {
        CompletableFuture<RedisPubSubConnection> connFuture = msEntry.nextPubSubConnection(clientEntry);
        this.connectionManager.getServiceManager().newTimeout(t -> {
            if (!connFuture.cancel(false) && !connFuture.isCompletedExceptionally()) {
                return;
            }
            this.trySubscribe(codec, channelName, promise, type, lock, attempts, listeners);
        }, this.config.getRetryInterval(), TimeUnit.MILLISECONDS);
        promise.whenComplete((res, e) -> {
            if (e != null) {
                connFuture.completeExceptionally((Throwable)e);
            }
        });
        connFuture.thenAccept(conn -> this.freePubSubLock.acquire().thenAccept(c -> {
            PubSubConnectionEntry entry = new PubSubConnectionEntry((RedisPubSubConnection)conn, this.connectionManager.getServiceManager());
            int remainFreeAmount = entry.tryAcquire();
            PubSubKey key = new PubSubKey(channelName, msEntry);
            PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(key, entry);
            if (oldEntry != null) {
                msEntry.returnPubSubConnection((RedisPubSubConnection)conn);
                this.freePubSubLock.release();
                this.addListeners(channelName, promise, type, lock, oldEntry, listeners);
                return;
            }
            Collection coll = this.name2entry.computeIfAbsent(channelName, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
            coll.add(msEntry);
            if (remainFreeAmount > 0) {
                PubSubEntry psEntry = this.entry2PubSubConnection.computeIfAbsent(msEntry, e -> new PubSubEntry());
                psEntry.getEntries().add(entry);
            }
            this.freePubSubLock.release();
            CompletableFuture<PubSubConnectionEntry> pp = new CompletableFuture<PubSubConnectionEntry>();
            pp.whenComplete((r, e) -> {
                if (e != null) {
                    PubSubType unsubscribeType = this.subscribe2unsubscribe.get((Object)type);
                    CompletableFuture<Codec> f = this.unsubscribe(channelName, unsubscribeType);
                    f.whenComplete((rr, ee) -> promise.completeExceptionally((Throwable)e));
                    return;
                }
                promise.complete((PubSubConnectionEntry)r);
            });
            CompletableFuture<Void> subscribeFuture = this.addListeners(channelName, pp, type, lock, entry, listeners);
            entry.subscribe(codec, type, channelName, subscribeFuture);
        }));
    }

    public CompletableFuture<Void> unsubscribeLocked(ChannelName channelName) {
        PubSubType type = PubSubType.UNSUBSCRIBE;
        if (this.shardingSupported) {
            type = PubSubType.SUNSUBSCRIBE;
        }
        return this.unsubscribeLocked(type, channelName);
    }

    public CompletableFuture<Void> unsubscribeLocked(PubSubType topicType, ChannelName channelName) {
        Collection<MasterSlaveEntry> coll = this.name2entry.get(channelName);
        if (coll == null || coll.isEmpty()) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for name: " + channelName + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.");
            CompletableFuture<Void> promise = new CompletableFuture<Void>();
            promise.completeExceptionally(ex);
            return promise;
        }
        return this.unsubscribeLocked(topicType, channelName, coll.iterator().next());
    }

    private CompletableFuture<Void> unsubscribeLocked(final PubSubType topicType, final ChannelName channelName, final MasterSlaveEntry msEntry) {
        final PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.remove(new PubSubKey(channelName, msEntry));
        if (entry == null || this.connectionManager.getServiceManager().isShuttingDown()) {
            return CompletableFuture.completedFuture(null);
        }
        this.remove(channelName, msEntry);
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        BaseRedisPubSubListener listener = new BaseRedisPubSubListener(){

            @Override
            public void onStatus(PubSubType type, CharSequence channel) {
                if (type == topicType && channel.equals(channelName)) {
                    PublishSubscribeService.this.freePubSubLock.acquire().thenAccept(c -> {
                        PublishSubscribeService.this.release(entry, msEntry);
                        PublishSubscribeService.this.freePubSubLock.release();
                        result.complete(null);
                    });
                }
            }
        };
        entry.unsubscribe(topicType, channelName, listener);
        return result;
    }

    private void remove(ChannelName channelName, MasterSlaveEntry entry) {
        Collection<MasterSlaveEntry> ee = this.name2entry.get(channelName);
        if (ee == null) {
            return;
        }
        ee.remove(entry);
        if (ee.isEmpty()) {
            this.name2entry.remove(channelName);
        }
    }

    private void release(PubSubConnectionEntry entry, MasterSlaveEntry msEntry) {
        PubSubEntry ee;
        entry.release();
        if (entry.isFree()) {
            if (msEntry != null) {
                PubSubEntry ee2 = (PubSubEntry)this.entry2PubSubConnection.get(msEntry);
                if (ee2 != null) {
                    ee2.getEntries().remove(entry);
                }
                msEntry.returnPubSubConnection(entry.getConnection());
            } else {
                entry.getConnection().closeAsync();
            }
            return;
        }
        if (msEntry != null && !(ee = this.entry2PubSubConnection.computeIfAbsent(msEntry, e -> new PubSubEntry())).getEntries().contains(entry)) {
            ee.getEntries().add(entry);
        }
    }

    public void remove(MasterSlaveEntry entry) {
        this.entry2PubSubConnection.remove(entry);
        this.name2entry.values().forEach(v -> v.remove(entry));
    }

    public CompletableFuture<Codec> unsubscribe(ChannelName channelName, PubSubType topicType) {
        Collection<MasterSlaveEntry> coll = this.name2entry.get(channelName);
        if (coll == null || coll.isEmpty()) {
            RedisNodeNotFoundException ex = new RedisNodeNotFoundException("Node for name: " + channelName + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.");
            CompletableFuture<Codec> promise = new CompletableFuture<Codec>();
            promise.completeExceptionally(ex);
            return promise;
        }
        return this.unsubscribe(channelName, coll.iterator().next(), topicType);
    }

    private CompletableFuture<Codec> unsubscribe(final ChannelName channelName, final MasterSlaveEntry e, final PubSubType topicType) {
        if (this.connectionManager.getServiceManager().isShuttingDown()) {
            return CompletableFuture.completedFuture(null);
        }
        final AsyncSemaphore lock = this.getSemaphore(channelName);
        CompletableFuture<Void> f = lock.acquire();
        return f.thenCompose(v -> {
            final PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.remove(new PubSubKey(channelName, e));
            if (entry == null) {
                lock.release();
                return CompletableFuture.completedFuture(null);
            }
            this.remove(channelName, e);
            final Codec entryCodec = topicType == PubSubType.PUNSUBSCRIBE ? entry.getConnection().getPatternChannels().get(channelName) : (topicType == PubSubType.SUNSUBSCRIBE ? entry.getConnection().getShardedChannels().get(channelName) : entry.getConnection().getChannels().get(channelName));
            final CompletableFuture result = new CompletableFuture();
            BaseRedisPubSubListener listener = new BaseRedisPubSubListener(){

                @Override
                public void onStatus(PubSubType type, CharSequence channel) {
                    if (type == topicType && channel.equals(channelName)) {
                        lock.release();
                        PublishSubscribeService.this.freePubSubLock.acquire().thenAccept(c -> {
                            PublishSubscribeService.this.release(entry, e);
                            PublishSubscribeService.this.freePubSubLock.release();
                            result.complete(entryCodec);
                        });
                    }
                }
            };
            entry.unsubscribe(topicType, channelName, listener);
            return result;
        });
    }

    public void reattachPubSub(int slot) {
        this.name2PubSubConnection.entrySet().stream().filter(e -> this.connectionManager.calcSlot(((PubSubKey)e.getKey()).getChannelName().getName()) == slot).forEach(entry -> {
            Codec patternCodec;
            Codec scodec;
            PubSubConnectionEntry pubSubEntry = (PubSubConnectionEntry)entry.getValue();
            MasterSlaveEntry ee = ((PubSubKey)entry.getKey()).getEntry();
            Codec codec = pubSubEntry.getConnection().getChannels().get(((PubSubKey)entry.getKey()).getChannelName());
            if (codec != null) {
                Queue<RedisPubSubListener<?>> listeners = pubSubEntry.getListeners(((PubSubKey)entry.getKey()).getChannelName());
                this.unsubscribe(((PubSubKey)entry.getKey()).getChannelName(), ee, PubSubType.UNSUBSCRIBE);
                this.subscribe(codec, ((PubSubKey)entry.getKey()).getChannelName(), listeners.toArray(new RedisPubSubListener[0]));
            }
            if ((scodec = pubSubEntry.getConnection().getShardedChannels().get(((PubSubKey)entry.getKey()).getChannelName())) != null) {
                Queue<RedisPubSubListener<?>> listeners = pubSubEntry.getListeners(((PubSubKey)entry.getKey()).getChannelName());
                this.unsubscribe(((PubSubKey)entry.getKey()).getChannelName(), ee, PubSubType.SUNSUBSCRIBE);
                this.subscribe(codec, ((PubSubKey)entry.getKey()).getChannelName(), listeners.toArray(new RedisPubSubListener[0]));
            }
            if ((patternCodec = pubSubEntry.getConnection().getPatternChannels().get(((PubSubKey)entry.getKey()).getChannelName())) != null) {
                Queue<RedisPubSubListener<?>> listeners = pubSubEntry.getListeners(((PubSubKey)entry.getKey()).getChannelName());
                this.unsubscribe(((PubSubKey)entry.getKey()).getChannelName(), ee, PubSubType.PUNSUBSCRIBE);
                this.psubscribe(((PubSubKey)entry.getKey()).getChannelName(), patternCodec, listeners.toArray(new RedisPubSubListener[0]));
            }
        });
    }

    public void reattachPubSub(RedisPubSubConnection redisPubSubConnection) {
        MasterSlaveEntry en = this.connectionManager.getEntry(redisPubSubConnection.getRedisClient());
        if (en == null) {
            return;
        }
        this.reattachPubSubListeners(redisPubSubConnection.getChannels().keySet(), en, PubSubType.UNSUBSCRIBE);
        this.reattachPubSubListeners(redisPubSubConnection.getShardedChannels().keySet(), en, PubSubType.SUNSUBSCRIBE);
        this.reattachPubSubListeners(redisPubSubConnection.getPatternChannels().keySet(), en, PubSubType.PUNSUBSCRIBE);
    }

    private void reattachPubSubListeners(Set<ChannelName> channels, MasterSlaveEntry en, PubSubType topicType) {
        for (ChannelName channelName : channels) {
            PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.get(new PubSubKey(channelName, en));
            if (entry == null) continue;
            Queue<RedisPubSubListener<?>> listeners = entry.getListeners(channelName);
            CompletableFuture<Codec> subscribeCodecFuture = this.unsubscribe(channelName, en, topicType);
            if (listeners.isEmpty()) continue;
            subscribeCodecFuture.whenComplete((subscribeCodec, e) -> {
                if (subscribeCodec == null) {
                    return;
                }
                if (topicType == PubSubType.PUNSUBSCRIBE) {
                    this.psubscribe(en, channelName, (Collection<RedisPubSubListener<?>>)listeners, (Codec)subscribeCodec);
                } else if (topicType == PubSubType.SUNSUBSCRIBE) {
                    this.ssubscribe(channelName, (Collection<RedisPubSubListener<?>>)listeners, (Codec)subscribeCodec);
                } else {
                    this.subscribe(channelName, (Collection<RedisPubSubListener<?>>)listeners, (Codec)subscribeCodec);
                }
            });
        }
    }

    private void subscribe(ChannelName channelName, Collection<RedisPubSubListener<?>> listeners, Codec subscribeCodec) {
        MasterSlaveEntry entry = this.getEntry(channelName);
        if (this.isMultiEntity(channelName)) {
            entry = this.connectionManager.getEntrySet().stream().filter(e -> !this.name2PubSubConnection.containsKey(new PubSubKey(channelName, (MasterSlaveEntry)e))).findFirst().orElse(null);
        }
        CompletableFuture<PubSubConnectionEntry> subscribeFuture = entry != null ? this.subscribe(PubSubType.SUBSCRIBE, subscribeCodec, channelName, entry, null, listeners.toArray(new RedisPubSubListener[0])) : this.subscribe(subscribeCodec, channelName, listeners.toArray(new RedisPubSubListener[0])).thenApply(r -> (PubSubConnectionEntry)r.iterator().next());
        subscribeFuture.whenComplete((res, e) -> {
            if (e != null) {
                this.connectionManager.getServiceManager().newTimeout(task -> this.subscribe(channelName, listeners, subscribeCodec), 1L, TimeUnit.SECONDS);
                return;
            }
            log.info("listeners of '{}' channel have been resubscribed to '{}'", (Object)channelName, res);
        });
    }

    private void ssubscribe(ChannelName channelName, Collection<RedisPubSubListener<?>> listeners, Codec subscribeCodec) {
        CompletableFuture<PubSubConnectionEntry> subscribeFuture = this.ssubscribe(subscribeCodec, channelName, listeners.toArray(new RedisPubSubListener[0]));
        subscribeFuture.whenComplete((res, e) -> {
            if (e != null) {
                this.connectionManager.getServiceManager().newTimeout(task -> this.ssubscribe(channelName, listeners, subscribeCodec), 1L, TimeUnit.SECONDS);
                return;
            }
            log.info("listeners of '{}' channel have been resubscribed to '{}'", (Object)channelName, res);
        });
    }

    private void psubscribe(MasterSlaveEntry oldEntry, ChannelName channelName, Collection<RedisPubSubListener<?>> listeners, Codec subscribeCodec) {
        MasterSlaveEntry entry = this.getEntry(channelName);
        if (this.isMultiEntity(channelName)) {
            entry = this.connectionManager.getEntrySet().stream().filter(e -> !this.name2PubSubConnection.containsKey(new PubSubKey(channelName, (MasterSlaveEntry)e)) && e != oldEntry).findFirst().orElse(null);
        }
        if (entry == null) {
            this.connectionManager.getServiceManager().newTimeout(task -> this.psubscribe(oldEntry, channelName, listeners, subscribeCodec), 1L, TimeUnit.SECONDS);
            return;
        }
        CompletableFuture<PubSubConnectionEntry> subscribeFuture = this.subscribe(PubSubType.PSUBSCRIBE, subscribeCodec, channelName, entry, null, listeners.toArray(new RedisPubSubListener[0]));
        subscribeFuture.whenComplete((res, e) -> {
            if (e != null) {
                this.connectionManager.getServiceManager().newTimeout(task -> this.psubscribe(oldEntry, channelName, listeners, subscribeCodec), 1L, TimeUnit.SECONDS);
                return;
            }
            log.info("listeners of '{}' channel-pattern have been resubscribed to '{}'", (Object)channelName, res);
        });
    }

    public CompletableFuture<Void> removeListenerAsync(PubSubType type, ChannelName channelName, EventListener listener) {
        return this.removeListenerAsync(type, channelName, (PubSubConnectionEntry entry) -> entry.removeListener(channelName, listener));
    }

    public CompletableFuture<Void> removeListenerAsync(PubSubType type, ChannelName channelName, Integer ... listenerIds) {
        return this.removeListenerAsync(type, channelName, (PubSubConnectionEntry entry) -> {
            Integer[] integerArray = listenerIds;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int id = integerArray[i];
                entry.removeListener(channelName, id);
            }
        });
    }

    private CompletableFuture<Void> removeListenerAsync(PubSubType type, ChannelName channelName, Consumer<PubSubConnectionEntry> consumer) {
        if (!this.name2entry.containsKey(channelName)) {
            return CompletableFuture.completedFuture(null);
        }
        AsyncSemaphore semaphore = this.getSemaphore(channelName);
        CompletableFuture<Void> sf = semaphore.acquire();
        int timeout = this.config.getTimeout() + this.config.getRetryInterval() * this.config.getRetryAttempts();
        this.connectionManager.getServiceManager().newTimeout(t -> sf.completeExceptionally(new RedisTimeoutException("Remove listeners operation timeout: (" + timeout + "ms) for " + channelName + " topic")), timeout, TimeUnit.MILLISECONDS);
        return sf.thenCompose(res -> {
            Collection<MasterSlaveEntry> entries = this.name2entry.get(channelName);
            if (entries == null || entries.isEmpty()) {
                semaphore.release();
                return CompletableFuture.completedFuture(null);
            }
            ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>(entries.size());
            for (MasterSlaveEntry e2 : entries) {
                PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.get(new PubSubKey(channelName, e2));
                if (entry == null) {
                    futures.add(CompletableFuture.completedFuture(null));
                    continue;
                }
                consumer.accept(entry);
                CompletionStage<Object> f = !entry.hasListeners(channelName) ? this.unsubscribeLocked(type, channelName, e2).exceptionally(ex -> null) : CompletableFuture.completedFuture(null);
                futures.add((CompletableFuture<Object>)f);
            }
            CompletableFuture<Void> ff = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return ff.whenComplete((v, e) -> semaphore.release());
        });
    }

    public CompletableFuture<Void> removeAllListenersAsync(PubSubType type, ChannelName channelName) {
        if (!this.name2entry.containsKey(channelName)) {
            return CompletableFuture.completedFuture(null);
        }
        AsyncSemaphore semaphore = this.getSemaphore(channelName);
        CompletableFuture<Void> sf = semaphore.acquire();
        int timeout = this.config.getTimeout() + this.config.getRetryInterval() * this.config.getRetryAttempts();
        this.connectionManager.getServiceManager().newTimeout(t -> sf.completeExceptionally(new RedisTimeoutException("Remove listeners operation timeout: (" + timeout + "ms) for " + channelName + " topic")), timeout, TimeUnit.MILLISECONDS);
        CompletionStage f = sf.thenCompose(r -> {
            PubSubConnectionEntry entry = this.getPubSubEntry(channelName);
            if (entry == null) {
                semaphore.release();
                return CompletableFuture.completedFuture(null);
            }
            if (entry.hasListeners(channelName)) {
                CompletableFuture<Void> ff = this.unsubscribeLocked(type, channelName);
                return ff.whenComplete((r1, e1) -> semaphore.release());
            }
            semaphore.release();
            return CompletableFuture.completedFuture(null);
        });
        return f;
    }

    public void setShardingSupported(boolean value) {
        this.shardingSupported = value;
    }

    public boolean isShardingSupported() {
        return this.shardingSupported;
    }

    public String getPublishCommand() {
        if (this.shardingSupported) {
            return RedisCommands.SPUBLISH.getName();
        }
        return RedisCommands.PUBLISH.getName();
    }

    public String toString() {
        return "PublishSubscribeService [name2PubSubConnection=" + this.name2PubSubConnection + ", entry2PubSubConnection=" + this.entry2PubSubConnection + "]";
    }

    public static class PubSubKey {
        private final ChannelName channelName;
        private final MasterSlaveEntry entry;

        public PubSubKey(ChannelName channelName, MasterSlaveEntry entry) {
            this.channelName = channelName;
            this.entry = entry;
        }

        public ChannelName getChannelName() {
            return this.channelName;
        }

        public MasterSlaveEntry getEntry() {
            return this.entry;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PubSubKey key = (PubSubKey)o;
            return Objects.equals(this.channelName, key.channelName) && Objects.equals(this.entry, key.entry);
        }

        public int hashCode() {
            return Objects.hash(this.channelName, this.entry);
        }

        public String toString() {
            return "PubSubKey{channelName=" + this.channelName + ", entry=" + this.entry + '}';
        }
    }

    public static class PubSubEntry {
        Queue<PubSubConnectionEntry> entries = new ConcurrentLinkedQueue<PubSubConnectionEntry>();

        public Queue<PubSubConnectionEntry> getEntries() {
            return this.entries;
        }
    }
}

