/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

public class DoubleConverter
implements TypeConverter<Double> {
    @Override
    public Double convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Double.class) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
        }
        try {
            String stringValue = value.toString().trim();
            if (StringUtil.startsWithChar(stringValue, '+')) {
                stringValue = stringValue.substring(1);
            }
            return Double.valueOf(stringValue);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

