/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.misc;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatchers;
import org.redisson.api.annotation.RId;
import org.redisson.cache.LRUCacheMap;

public class Introspectior {
    private static final Map<Class<?>, String> ID_FIELD_NAME_CACHE = new LRUCacheMap(500, 0L, 0L);

    public static TypeDescription.ForLoadedType getTypeDescription(Class<?> c) {
        return new TypeDescription.ForLoadedType(c);
    }

    public static FieldList<FieldDescription.InDefinedShape> getFieldsWithAnnotation(Class<?> c, Class<? extends Annotation> a) {
        return (FieldList)Introspectior.getAllFields(c).filter(ElementMatchers.isAnnotatedWith(a));
    }

    public static FieldList<FieldDescription.InDefinedShape> getAllFields(Class<?> cls) {
        ArrayList fields = new ArrayList();
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            Collections.addAll(fields, c.getDeclaredFields());
        }
        return new FieldList.ForLoadedFields(fields);
    }

    public static String getREntityIdFieldName(Class<?> cls) {
        String name = ID_FIELD_NAME_CACHE.get(cls);
        if (name == null) {
            name = ((FieldDescription.InDefinedShape)Introspectior.getFieldsWithAnnotation(cls, RId.class).getOnly()).getName();
            ID_FIELD_NAME_CACHE.put(cls, name);
        }
        return name;
    }
}

