/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import java.util.Arrays;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionTask;

public class TimeSeriesEvictionTask
extends EvictionTask {
    private final String name;
    private final String timeoutSetName;

    public TimeSeriesEvictionTask(String name, String timeoutSetName, CommandAsyncExecutor executor) {
        super(executor);
        this.name = name;
        this.timeoutSetName = timeoutSetName;
    }

    @Override
    RFuture<Integer> execute() {
        return this.executor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredKeys = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); if #expiredKeys > 0 then redis.call('zrem', KEYS[2], unpack(expiredKeys)); redis.call('zrem', KEYS[1], unpack(expiredKeys)); end; return #expiredKeys;", Arrays.asList(this.name, this.timeoutSetName), System.currentTimeMillis(), this.keysLimit);
    }

    @Override
    String getName() {
        return this.name;
    }
}

