/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.misc.RedisURI;

public class ClusterPartition {
    private Type type = Type.MASTER;
    private final String nodeId;
    private boolean masterFail;
    private RedisURI masterAddress;
    private final Set<RedisURI> slaveAddresses = new HashSet<RedisURI>();
    private final Set<RedisURI> failedSlaves = new HashSet<RedisURI>();
    private final BitSet slots = new BitSet(16384);
    private final Set<ClusterSlotRange> slotRanges = new HashSet<ClusterSlotRange>();
    private ClusterPartition parent;

    public ClusterPartition(String nodeId) {
        this.nodeId = nodeId;
    }

    public ClusterPartition getParent() {
        return this.parent;
    }

    public void setParent(ClusterPartition parent) {
        this.parent = parent;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setMasterFail(boolean masterFail) {
        this.masterFail = masterFail;
    }

    public boolean isMasterFail() {
        return this.masterFail;
    }

    public void addSlots(BitSet slots) {
        this.slots.or(slots);
    }

    public void removeSlots(BitSet slots) {
        this.slots.andNot(slots);
    }

    public void addSlotRanges(Set<ClusterSlotRange> ranges) {
        for (ClusterSlotRange clusterSlotRange : ranges) {
            this.slots.set(clusterSlotRange.getStartSlot(), clusterSlotRange.getEndSlot() + 1);
        }
        this.slotRanges.addAll(ranges);
    }

    public void removeSlotRanges(Set<ClusterSlotRange> ranges) {
        for (ClusterSlotRange clusterSlotRange : ranges) {
            this.slots.clear(clusterSlotRange.getStartSlot(), clusterSlotRange.getEndSlot() + 1);
        }
        this.slotRanges.removeAll(ranges);
    }

    public Set<ClusterSlotRange> getSlotRanges() {
        return this.slotRanges;
    }

    public void clear() {
        this.slotRanges.clear();
        this.slots.clear();
    }

    public Iterable<Integer> getSlots() {
        return this.slots.stream()::iterator;
    }

    public BitSet slots() {
        return this.slots;
    }

    public BitSet copySlots() {
        return (BitSet)this.slots.clone();
    }

    public boolean hasSlot(int slot) {
        return this.slots.get(slot);
    }

    public int getSlotsAmount() {
        return this.slots.cardinality();
    }

    public RedisURI getMasterAddress() {
        return this.masterAddress;
    }

    public void setMasterAddress(RedisURI masterAddress) {
        this.masterAddress = masterAddress;
    }

    public void addFailedSlaveAddress(RedisURI address) {
        this.failedSlaves.add(address);
    }

    public Set<RedisURI> getFailedSlaveAddresses() {
        return Collections.unmodifiableSet(this.failedSlaves);
    }

    public void removeFailedSlaveAddress(RedisURI uri) {
        this.failedSlaves.remove(uri);
    }

    public void addSlaveAddress(RedisURI address) {
        this.slaveAddresses.add(address);
    }

    public Set<RedisURI> getSlaveAddresses() {
        return Collections.unmodifiableSet(this.slaveAddresses);
    }

    public void removeSlaveAddress(RedisURI uri) {
        this.slaveAddresses.remove(uri);
        this.failedSlaves.remove(uri);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterPartition other = (ClusterPartition)obj;
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId));
    }

    public String toString() {
        return "ClusterPartition [nodeId=" + this.nodeId + ", masterFail=" + this.masterFail + ", masterAddress=" + this.masterAddress + ", slaveAddresses=" + this.slaveAddresses + ", failedSlaves=" + this.failedSlaves + ", slotRanges=" + this.slotRanges + "]";
    }

    public static enum Type {
        MASTER,
        SLAVE;

    }
}

