/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.redisson.api.FunctionLibrary;
import org.redisson.api.FunctionMode;
import org.redisson.api.FunctionResult;
import org.redisson.api.FunctionStats;
import org.redisson.api.RFunction;
import org.redisson.api.RFuture;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonFuction
implements RFunction {
    private final Codec codec;
    private final CommandAsyncExecutor commandExecutor;

    public RedissonFuction(CommandAsyncExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.codec = commandExecutor.getServiceManager().getCfg().getCodec();
    }

    public RedissonFuction(CommandAsyncExecutor commandExecutor, Codec codec) {
        this.commandExecutor = commandExecutor;
        this.codec = codec;
    }

    @Override
    public void delete(String libraryName) {
        this.commandExecutor.get(this.deleteAsync(libraryName));
    }

    @Override
    public RFuture<Void> deleteAsync(String libraryName) {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FUNCTION_DELETE, libraryName);
    }

    @Override
    public byte[] dump() {
        return this.commandExecutor.get(this.dumpAsync());
    }

    @Override
    public RFuture<byte[]> dumpAsync() {
        return this.commandExecutor.readAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.FUNCTION_DUMP, new Object[0]);
    }

    @Override
    public void flush() {
        this.commandExecutor.get(this.flushAsync());
    }

    @Override
    public RFuture<Void> flushAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FUNCTION_FLUSH, new Object[0]);
    }

    @Override
    public void kill() {
        this.commandExecutor.get(this.killAsync());
    }

    @Override
    public RFuture<Void> killAsync() {
        List futures = this.commandExecutor.executeAllAsync(RedisCommands.FUNCTION_KILL, new Object[0]);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public List<FunctionLibrary> list() {
        return this.commandExecutor.get(this.listAsync());
    }

    @Override
    public RFuture<List<FunctionLibrary>> listAsync() {
        return this.commandExecutor.readAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.FUNCTION_LIST, new Object[0]);
    }

    @Override
    public List<FunctionLibrary> list(String namePattern) {
        return this.commandExecutor.get(this.listAsync(namePattern));
    }

    @Override
    public RFuture<List<FunctionLibrary>> listAsync(String namePattern) {
        return this.commandExecutor.readAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.FUNCTION_LIST, "LIBRARYNAME", namePattern);
    }

    @Override
    public void load(String libraryName, String code) {
        this.commandExecutor.get(this.loadAsync(libraryName, code));
    }

    @Override
    public RFuture<Void> loadAsync(String libraryName, String code) {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FUNCTION_LOAD, "#!lua name=" + libraryName + " \n " + code);
    }

    @Override
    public void loadAndReplace(String libraryName, String code) {
        this.commandExecutor.get(this.loadAndReplaceAsync(libraryName, code));
    }

    @Override
    public RFuture<Void> loadAndReplaceAsync(String libraryName, String code) {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FUNCTION_LOAD, "REPLACE", "#!lua name=" + libraryName + " \n " + code);
    }

    @Override
    public void restore(byte[] payload) {
        this.commandExecutor.get(this.restoreAsync(payload));
    }

    @Override
    public RFuture<Void> restoreAsync(byte[] payload) {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FUNCTION_RESTORE, new Object[]{payload});
    }

    @Override
    public void restoreAndReplace(byte[] payload) {
        this.commandExecutor.get(this.restoreAndReplaceAsync(payload));
    }

    @Override
    public RFuture<Void> restoreAndReplaceAsync(byte[] payload) {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FUNCTION_RESTORE, payload, "REPLACE");
    }

    @Override
    public void restoreAfterFlush(byte[] payload) {
        this.commandExecutor.get(this.restoreAfterFlushAsync(payload));
    }

    @Override
    public RFuture<Void> restoreAfterFlushAsync(byte[] payload) {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FUNCTION_RESTORE, payload, "FLUSH");
    }

    private List<Object> encode(Collection<?> values, Codec codec) {
        ArrayList<Object> result = new ArrayList<Object>(values.size());
        for (Object object : values) {
            result.add(this.commandExecutor.encode(codec, object));
        }
        return result;
    }

    @Override
    public <R> R call(String key, FunctionMode mode, String name, FunctionResult returnType, List<Object> keys, Object ... values) {
        return this.commandExecutor.get(this.callAsync(key, mode, name, returnType, keys, values));
    }

    @Override
    public <R> R call(FunctionMode mode, String name, FunctionResult returnType, List<Object> keys, Object ... values) {
        return this.commandExecutor.get(this.callAsync(mode, name, returnType, keys, values));
    }

    @Override
    public <R> R call(FunctionMode mode, String name, FunctionResult returnType) {
        return this.commandExecutor.get(this.callAsync(mode, name, returnType));
    }

    @Override
    public FunctionStats stats() {
        return this.commandExecutor.get(this.statsAsync());
    }

    @Override
    public RFuture<FunctionStats> statsAsync() {
        return this.commandExecutor.readAsync((String)null, (Codec)StringCodec.INSTANCE, RedisCommands.FUNCTION_STATS, new Object[0]);
    }

    @Override
    public <R> RFuture<R> callAsync(String key, FunctionMode mode, String name, FunctionResult returnType, List<Object> keys, Object ... values) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(name);
        args.add(keys.size());
        if (keys.size() > 0) {
            args.addAll(keys.stream().map(k -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)k)).collect(Collectors.toList()));
        }
        args.addAll(this.encode(Arrays.asList(values), this.codec));
        if (mode == FunctionMode.READ) {
            return this.commandExecutor.readAsync(key, this.codec, returnType.getCommand(), args.toArray());
        }
        return this.commandExecutor.writeAsync(key, this.codec, returnType.getCommand(), args.toArray());
    }

    @Override
    public <R> RFuture<R> callAsync(FunctionMode mode, String name, FunctionResult returnType, List<Object> keys, Object ... values) {
        String key = null;
        if (keys.size() > 0) {
            key = this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)keys.get(0));
        }
        return this.callAsync(key, mode, name, returnType, keys, values);
    }

    @Override
    public <R> RFuture<R> callAsync(FunctionMode mode, String name, FunctionResult returnType) {
        return this.callAsync(mode, name, returnType, Collections.emptyList(), new Object[0]);
    }
}

