/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.remote.AsyncRemoteProxy;
import org.redisson.remote.BaseRemoteService;
import org.redisson.remote.ResponseEntry;
import org.redisson.rx.CommandRxExecutor;

public class RxRemoteProxy
extends AsyncRemoteProxy {
    public RxRemoteProxy(CommandAsyncExecutor commandExecutor, String name, String responseQueueName, ConcurrentMap<String, ResponseEntry> responses, Codec codec, String executorId, String cancelRequestMapName, BaseRemoteService remoteService) {
        super(commandExecutor, name, responseQueueName, responses, codec, executorId, cancelRequestMapName, remoteService);
    }

    @Override
    protected List<Class<?>> permittedClasses() {
        return Arrays.asList(Completable.class, Single.class, Maybe.class);
    }

    @Override
    protected Object convertResult(RemotePromise<Object> result, Class<?> returnType) {
        Flowable flowable = ((CommandRxExecutor)this.commandExecutor).flowable(() -> new CompletableFutureWrapper(result));
        if (returnType == Completable.class) {
            return flowable.ignoreElements();
        }
        if (returnType == Single.class) {
            return flowable.singleOrError();
        }
        return flowable.singleElement();
    }
}

