/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.Objects;

public class TimeSeriesEntry<V, L> {
    private long timestamp;
    private V value;
    private L label;

    public TimeSeriesEntry(long timestamp, V value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public TimeSeriesEntry(long timestamp, V value, L label) {
        this.timestamp = timestamp;
        this.value = value;
        this.label = label;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public V getValue() {
        return this.value;
    }

    public L getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesEntry that = (TimeSeriesEntry)o;
        return this.timestamp == that.timestamp && this.value.equals(that.value) && Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value, this.label);
    }

    public String toString() {
        return "Entry{timestamp=" + this.timestamp + ", value=" + this.value + '}';
    }
}

