/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonLock;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSemaphore;
import org.redisson.ScanIterator;
import org.redisson.ScanResult;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonClient;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.mapreduce.RedissonCollectionMapReduce;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonSetCache<V>
extends RedissonExpirable
implements RSetCache<V>,
ScanIterator {
    final RedissonClient redisson;
    final EvictionScheduler evictionScheduler;
    final RedissonScoredSortedSet<V> scoredSortedSet;

    public RedissonSetCache(EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getRawName(), 0L);
        }
        this.evictionScheduler = evictionScheduler;
        this.redisson = redisson;
        this.scoredSortedSet = new RedissonScoredSortedSet(commandExecutor, name, redisson);
    }

    public RedissonSetCache(Codec codec, EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getRawName(), 0L);
        }
        this.evictionScheduler = evictionScheduler;
        this.redisson = redisson;
        this.scoredSortedSet = new RedissonScoredSortedSet(codec, commandExecutor, name, redisson);
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor);
    }

    @Override
    public int size() {
        return this.scoredSortedSet.size();
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[1], ARGV[2]);return #values;", Arrays.asList(this.getRawName()), System.currentTimeMillis(), 92233720368547758L);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        String name = this.getRawName(o);
        return this.commandExecutor.evalReadAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;else return 1;end;else return 0;end; ", Arrays.asList(name), System.currentTimeMillis(), this.encode(o));
    }

    @Override
    public ScanResult<Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        RFuture<ScanResult<Object>> f = this.scanIteratorAsync(name, client, startPos, pattern, count);
        return this.get(f);
    }

    @Override
    public RFuture<ScanResult<Object>> scanIteratorAsync(String name, RedisClient client, long startPos, String pattern, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startPos);
        params.add(System.currentTimeMillis());
        if (pattern != null) {
            params.add(pattern);
        }
        params.add(count);
        return this.commandExecutor.evalReadAsync(client, name, this.codec, RedisCommands.EVAL_SCAN, "local result = {}; local res; if (#ARGV == 4) then  res = redis.call('zscan', KEYS[1], ARGV[1], 'match', ARGV[3], 'count', ARGV[4]); else  res = redis.call('zscan', KEYS[1], ARGV[1], 'count', ARGV[3]); end;for i, value in ipairs(res[2]) do if i % 2 == 0 then local expireDate = value; if tonumber(expireDate) > tonumber(ARGV[2]) then table.insert(result, res[2][i-1]); end; end;end;return {res[1], result};", Arrays.asList(name), params.toArray());
    }

    @Override
    public Iterator<V> iterator(int count) {
        return this.iterator(null, count);
    }

    @Override
    public Iterator<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    @Override
    public Iterator<V> iterator(final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonSetCache.this.scanIterator(RedissonSetCache.this.getRawName(), client, nextIterPos, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSetCache.this.remove(value);
            }
        };
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGEBYSCORE, this.getRawName(), System.currentTimeMillis(), 92233720368547758L);
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public boolean add(V value, long ttl, TimeUnit unit) {
        return this.get(this.addAsync(value, ttl, unit));
    }

    @Override
    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit unit) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("TTL can't be negative");
        }
        if (ttl == 0L) {
            return this.addAsync(value);
        }
        if (unit == null) {
            throw new NullPointerException("TimeUnit param can't be null");
        }
        ByteBuf objectState = this.encode(value);
        long timeoutDate = System.currentTimeMillis() + unit.toMillis(ttl);
        String name = this.getRawName(value);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0;end; return 1; ", Arrays.asList(name), System.currentTimeMillis(), timeoutDate, objectState);
    }

    @Override
    public boolean tryAdd(V ... values) {
        return this.get(this.tryAddAsync(values));
    }

    @Override
    public RFuture<Boolean> tryAddAsync(V ... values) {
        return this.tryAddAsync(92233720368547758L - System.currentTimeMillis(), TimeUnit.MILLISECONDS, values);
    }

    @Override
    public boolean tryAdd(long ttl, TimeUnit unit, V ... values) {
        return this.get(this.tryAddAsync(ttl, unit, values));
    }

    @Override
    public RFuture<Boolean> tryAddAsync(long ttl, TimeUnit unit, V ... values) {
        long timeoutDate = System.currentTimeMillis() + unit.toMillis(ttl);
        if (ttl == 0L) {
            timeoutDate = 92233720368547758L - System.currentTimeMillis();
        }
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        params.add(Long.valueOf(System.currentTimeMillis()));
        params.add(Long.valueOf(timeoutDate));
        params.addAll(this.encode(Arrays.asList(values)));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "for i, v in ipairs(ARGV) do local expireDateScore = redis.call('zscore', KEYS[1], v); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0; end; end; for i=3, #ARGV, 1 do redis.call('zadd', KEYS[1], ARGV[2], ARGV[i]); end; return 1; ", Arrays.asList(this.getRawName()), params.toArray());
    }

    @Override
    public RFuture<Boolean> addAsync(V value) {
        return this.addAsync(value, 92233720368547758L - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        String name = this.getRawName(o);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.ZREM, name, this.encode(o));
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(true);
        }
        ArrayList<Object> params = new ArrayList<Object>(c.size() + 1);
        params.add(System.currentTimeMillis());
        this.encode(params, c);
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "for j = 2, #ARGV, 1 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[j]) if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;end; else return 0;end; end; return 1; ", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2 + 1);
        params.add(this.getRawName());
        for (V value : c) {
            ByteBuf objectState = this.encode(value);
            params.add(score);
            params.add(objectState);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL_RAW, params.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Long> params = new ArrayList<Long>(c.size() * 2);
        for (Object object : c) {
            params.add(score);
            this.encode(params, object);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('zadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('zcard', KEYS[1]); local size = redis.call('zinterstore', KEYS[1], #ARGV/2, KEYS[1], KEYS[2], 'aggregate', 'min');redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getRawName(), "redisson_temp__{" + this.getRawName() + "}"), params.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        ArrayList<Object> params = new ArrayList<Object>(c.size() + 1);
        params.add(this.getRawName());
        this.encode(params, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREM, params.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(V value) {
        String lockName = this.getLockByValue(value, "permitexpirablesemaphore");
        return new RedissonPermitExpirableSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RSemaphore getSemaphore(V value) {
        String lockName = this.getLockByValue(value, "semaphore");
        return new RedissonSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RCountDownLatch getCountDownLatch(V value) {
        String lockName = this.getLockByValue(value, "countdownlatch");
        return new RedissonCountDownLatch(this.commandExecutor, lockName);
    }

    @Override
    public RLock getFairLock(V value) {
        String lockName = this.getLockByValue(value, "fairlock");
        return new RedissonFairLock(this.commandExecutor, lockName);
    }

    @Override
    public RLock getLock(V value) {
        String lockName = this.getLockByValue(value, "lock");
        return new RedissonLock(this.commandExecutor, lockName);
    }

    @Override
    public RReadWriteLock getReadWriteLock(V value) {
        String lockName = this.getLockByValue(value, "rw_lock");
        return new RedissonReadWriteLock(this.commandExecutor, lockName);
    }

    @Override
    public void destroy() {
        if (this.evictionScheduler != null) {
            this.evictionScheduler.remove(this.getRawName());
        }
    }

    @Override
    public Stream<V> stream(int count) {
        return this.toStream(this.iterator(count));
    }

    @Override
    public Stream<V> stream(String pattern, int count) {
        return this.toStream(this.iterator(pattern, count));
    }

    @Override
    public Stream<V> stream(String pattern) {
        return this.toStream(this.iterator(pattern));
    }

    @Override
    public int addAllCounted(Collection<? extends V> c) {
        return this.get(this.addAllCountedAsync(c));
    }

    @Override
    public int removeAllCounted(Collection<? extends V> c) {
        return this.get(this.removeAllCountedAsync(c));
    }

    @Override
    public Iterator<V> distributedIterator(String pattern) {
        String iteratorName = "__redisson_scored_sorted_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, pattern, 10);
    }

    @Override
    public Iterator<V> distributedIterator(int count) {
        String iteratorName = "__redisson_scored_sorted_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, null, count);
    }

    @Override
    public Iterator<V> distributedIterator(final String iteratorName, final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonSetCache.this.distributedScanIterator(iteratorName, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSetCache.this.remove(value);
            }
        };
    }

    private ScanResult<Object> distributedScanIterator(String iteratorName, String pattern, int count) {
        return this.get(this.distributedScanIteratorAsync(iteratorName, pattern, count));
    }

    private RFuture<ScanResult<Object>> distributedScanIteratorAsync(String iteratorName, String pattern, int count) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(System.currentTimeMillis());
        if (pattern != null) {
            args.add(pattern);
        }
        args.add(count);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SCAN, "local cursor = redis.call('get', KEYS[2]); if cursor ~= false then cursor = tonumber(cursor); else cursor = 0;end;if cursor == -1 then return {0, {}}; end;local result; if (#ARGV == 3) then result = redis.call('zscan', KEYS[1], cursor, 'match', ARGV[2], 'count', ARGV[3]); else result = redis.call('zscan', KEYS[1], cursor, 'count', ARGV[2]); end;local next_cursor = result[1]if next_cursor ~= \"0\" then redis.call('setex', KEYS[2], 3600, next_cursor);else redis.call('setex', KEYS[2], 3600, -1);end; local res = {};for i, value in ipairs(result[2]) do if i % 2 == 0 then local expireDate = value; if tonumber(expireDate) > tonumber(ARGV[1]) then table.insert(res, result[2][i-1]); end; end; end;return {result[1], res};", Arrays.asList(this.getRawName(), iteratorName), args.toArray());
    }

    @Override
    public Set<V> removeRandom(int amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V removeRandom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public Set<V> random(int count) {
        return this.get(this.randomAsync(count));
    }

    @Override
    public boolean move(String destination, V member) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public Integer countIntersection(String ... names) {
        return this.get(this.countIntersectionAsync(names));
    }

    @Override
    public Integer countIntersection(int limit, String ... names) {
        return this.get(this.countIntersectionAsync(limit, names));
    }

    @Override
    public List<V> containsEach(Collection<V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Set<V>> removeRandomAsync(int amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<V> randomAsync() {
        String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", this.getRawName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_OBJECT, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[1], ARGV[2], 'WITHSCORES');for i = 1, #values, 2 do redis.call('zadd', KEYS[2], values[i], values[i+1]); end;local res = redis.call('zrandmember', KEYS[2]); redis.call('del', KEYS[2]); return res;", Arrays.asList(this.getRawName(), tempName), System.currentTimeMillis(), 92233720368547758L);
    }

    @Override
    public RFuture<Set<V>> randomAsync(int count) {
        String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", this.getRawName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "local values = redis.call('zrangebyscore', KEYS[1], ARGV[1], ARGV[2], 'WITHSCORES');for i = 1, #values, 2 do redis.call('zadd', KEYS[2], values[i], values[i+1]); end;local res = redis.call('zrandmember', KEYS[2], ARGV[3]); redis.call('del', KEYS[2]); return res;", Arrays.asList(this.getRawName(), tempName), System.currentTimeMillis(), 92233720368547758L, count);
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(Arrays.asList(names));
        for (String key : names) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {KEYS[1], (#KEYS-1)/2};for i = 2, (#KEYS-1)/2 + 1, 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = (#KEYS-1)/2 + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; table.insert(args, 'AGGREGATE'); table.insert(args, 'SUM'); local res = redis.call('zunionstore', unpack(args));redis.call('del', unpack(KEYS, (#KEYS-1)/2+2, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(Arrays.asList(names));
        for (Object key : new ArrayList(keys)) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "for i = 1, #KEYS, 1 do local values = redis.call('zrangebyscore', KEYS[ARGV[3] + i], ARGV[1], ARGV[2], 'WITHSCORES');for j = 1, #values, 2 do redis.call('zadd', KEYS[ARGV[3] + i], values[j], values[j+1]); end;end; local values = redis.call('zunion', ARGV[3], unpack(KEYS, ARGV[3], #ARGV), 'AGGREGATE', 'SUM');redis.call('del', unpack(KEYS, ARGV[3], #KEYS)); return values;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(Arrays.asList(names));
        for (String key : names) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {KEYS[1], (#KEYS-1)/2};for i = 2, (#KEYS-1)/2 + 1, 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = (#KEYS-1)/2 + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; local res = redis.call('zdiffstore', unpack(args));redis.call('del', unpack(KEYS, (#KEYS-1)/2+2, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(Arrays.asList(names));
        for (Object key : new ArrayList(keys)) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "for i = 1, #KEYS, 1 do local values = redis.call('zrangebyscore', KEYS[ARGV[3] + i], ARGV[1], ARGV[2], 'WITHSCORES');for j = 1, #values, 2 do redis.call('zadd', KEYS[ARGV[3] + i], values[j], values[j+1]); end;end; local values = redis.call('zdiff', ARGV[3], unpack(KEYS, ARGV[3], #ARGV));redis.call('del', unpack(KEYS, ARGV[3], #KEYS)); return values;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(Arrays.asList(names));
        for (String key : names) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {KEYS[1], (#KEYS-1)/2};for i = 2, (#KEYS-1)/2 + 1, 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = (#KEYS-1)/2 + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; table.insert(args, 'AGGREGATE'); table.insert(args, 'SUM'); local res = redis.call('zinterstore', unpack(args));redis.call('del', unpack(KEYS, (#KEYS-1)/2+2, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(Arrays.asList(names));
        for (Object key : new ArrayList(keys)) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "for i = 1, #KEYS, 1 do local values = redis.call('zrangebyscore', KEYS[ARGV[3] + i], ARGV[1], ARGV[2], 'WITHSCORES');for j = 1, #values, 2 do redis.call('zadd', KEYS[ARGV[3] + i], values[j], values[j+1]); end;end; local values = redis.call('zinter', ARGV[3], unpack(KEYS, ARGV[3], #ARGV), 'AGGREGATE', 'SUM');redis.call('del', unpack(KEYS, ARGV[3], #KEYS)); return values;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1);
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(String ... names) {
        return this.countIntersectionAsync(0, names);
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(int limit, String ... names) {
        LinkedList<Object> keys = new LinkedList<Object>();
        keys.add(this.getRawName());
        keys.addAll(Arrays.asList(names));
        for (Object key : new ArrayList(keys)) {
            String tempName = RedissonSetCache.prefixName("__redisson_cache_temp", key.toString());
            keys.add(tempName);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)IntegerCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local args = {ARGV[3]};for i = 1, ARGV[3], 1 do local values = redis.call('zrangebyscore', KEYS[i], ARGV[1], ARGV[2], 'WITHSCORES');local k = tonumber(ARGV[3]) + i; table.insert(args, KEYS[k]); for j = 1, #values, 2 do redis.call('zadd', KEYS[k], values[j+1], values[j]); end;end; table.insert(args, 'LIMIT'); table.insert(args, ARGV[4]); local res = redis.call('zintercard', unpack(args));redis.call('del', unpack(KEYS, ARGV[3]+1, #KEYS)); return res;", keys, System.currentTimeMillis(), 92233720368547758L, names.length + 1, limit);
    }

    @Override
    public RFuture<Integer> addAllCountedAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        for (V v : c) {
            args.add(92233720368547758L);
            try {
                args.add(v);
            }
            catch (Exception e) {
                args.forEach(vv -> ReferenceCountUtil.safeRelease(vv));
                throw e;
            }
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_INT, args.toArray());
    }

    @Override
    public RFuture<Integer> removeAllCountedAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREM_INT, args.toArray());
    }

    @Override
    public RFuture<List<V>> containsEachAsync(Collection<V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return this.get(this.readSortAsync(order));
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(order, offset, count));
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, order));
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, order, offset, count));
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order) {
        return this.get(this.readSortAlphaAsync(order));
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(order, offset, count));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, order));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, order, offset, count));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.get(this.sortToAsync(destName, order));
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, order));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order));
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.readSortAsync(null, null, order, -1, -1, false);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.readSortAsync(null, null, order, offset, count, false);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.readSortAsync(byPattern, null, order, -1, -1, false);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, null, order, offset, count, false);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, false);
    }

    private <T> RFuture<T> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count, boolean alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        return this.readSortAsync(null, null, order, -1, -1, true);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.readSortAsync(null, null, order, offset, count, true);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.readSortAsync(byPattern, null, order, -1, -1, true);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, null, order, offset, count, true);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1, true);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, true);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.sortToAsync(destName, null, null, order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, null, null, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.sortToAsync(destName, byPattern, null, order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, byPattern, null, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.sortToAsync(destName, byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }
}

