/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.LockPubSub;

public class RedissonReadLock
extends RedissonLock
implements RLock {
    protected RedissonReadLock(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    String getChannelName() {
        return RedissonReadLock.prefixName("redisson_rwlock", this.getRawName());
    }

    String getWriteLockName(long threadId) {
        return super.getLockName(threadId) + ":write";
    }

    String getReadWriteTimeoutNamePrefix(long threadId) {
        return RedissonReadLock.suffixName(this.getRawName(), this.getLockName(threadId)) + ":rwlock_timeout";
    }

    @Override
    <T> RFuture<T> tryLockInnerAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, command, "local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call('hset', KEYS[1], 'mode', 'read'); redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('set', KEYS[2] .. ':1', 1); redis.call('pexpire', KEYS[2] .. ':1', ARGV[1]); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (mode == 'read') or (mode == 'write' and redis.call('hexists', KEYS[1], ARGV[3]) == 1) then local ind = redis.call('hincrby', KEYS[1], ARGV[2], 1); local key = KEYS[2] .. ':' .. ind;redis.call('set', key, 1); redis.call('pexpire', key, ARGV[1]); local remainTime = redis.call('pttl', KEYS[1]); redis.call('pexpire', KEYS[1], math.max(remainTime, ARGV[1])); return nil; end;return redis.call('pttl', KEYS[1]);", Arrays.asList(this.getRawName(), this.getReadWriteTimeoutNamePrefix(threadId)), unit.toMillis(leaseTime), this.getLockName(threadId), this.getWriteLockName(threadId));
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId) {
        String timeoutPrefix = this.getReadWriteTimeoutNamePrefix(threadId);
        String keyPrefix = this.getKeyPrefix(threadId, timeoutPrefix);
        return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call('publish', KEYS[2], ARGV[1]); return 1; end; local lockExists = redis.call('hexists', KEYS[1], ARGV[2]); if (lockExists == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter == 0) then redis.call('hdel', KEYS[1], ARGV[2]); end;redis.call('del', KEYS[3] .. ':' .. (counter+1)); if (redis.call('hlen', KEYS[1]) > 1) then local maxRemainTime = -3; local keys = redis.call('hkeys', KEYS[1]); for n, key in ipairs(keys) do counter = tonumber(redis.call('hget', KEYS[1], key)); if type(counter) == 'number' then for i=counter, 1, -1 do local remainTime = redis.call('pttl', KEYS[4] .. ':' .. key .. ':rwlock_timeout:' .. i); maxRemainTime = math.max(remainTime, maxRemainTime);end; end; end; if maxRemainTime > 0 then redis.call('pexpire', KEYS[1], maxRemainTime); return 0; end;if mode == 'write' then return 0;end; end; redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; ", Arrays.asList(this.getRawName(), this.getChannelName(), timeoutPrefix, keyPrefix), LockPubSub.UNLOCK_MESSAGE, this.getLockName(threadId));
    }

    protected String getKeyPrefix(long threadId, String timeoutPrefix) {
        return timeoutPrefix.split(":" + this.getLockName(threadId))[0];
    }

    @Override
    protected CompletionStage<Boolean> renewExpirationAsync(long threadId) {
        String timeoutPrefix = this.getReadWriteTimeoutNamePrefix(threadId);
        String keyPrefix = this.getKeyPrefix(threadId, timeoutPrefix);
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local counter = redis.call('hget', KEYS[1], ARGV[2]); if (counter ~= false) then redis.call('pexpire', KEYS[1], ARGV[1]); if (redis.call('hlen', KEYS[1]) > 1) then local keys = redis.call('hkeys', KEYS[1]); for n, key in ipairs(keys) do counter = tonumber(redis.call('hget', KEYS[1], key)); if type(counter) == 'number' then for i=counter, 1, -1 do redis.call('pexpire', KEYS[2] .. ':' .. key .. ':rwlock_timeout:' .. i, ARGV[1]); end; end; end; end; return 1; end; return 0;", Arrays.asList(this.getRawName(), keyPrefix), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null);
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hget', KEYS[1], 'mode') == 'read') then redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; end; return 0; ", Arrays.asList(this.getRawName(), this.getChannelName()), LockPubSub.UNLOCK_MESSAGE);
    }

    @Override
    public boolean isLocked() {
        RFuture future = this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.HGET, this.getRawName(), "mode");
        String res = (String)this.get(future);
        return "read".equals(res);
    }
}

