/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractObjectInput;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.Unmarshaller;

public abstract class AbstractUnmarshaller
extends AbstractObjectInput
implements Unmarshaller {
    protected final ClassExternalizerFactory classExternalizerFactory;
    protected final StreamHeader streamHeader;
    protected final ClassResolver classResolver;
    protected final ObjectResolver objectResolver;
    protected final ObjectResolver objectPreResolver;
    protected final ClassTable classTable;
    protected final ObjectTable objectTable;
    protected final ExceptionListener exceptionListener;
    protected final SerializabilityChecker serializabilityChecker;
    protected final int configuredVersion;

    protected AbstractUnmarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) {
        super(configuration.getBufferSize());
        ClassExternalizerFactory classExternalizerFactory = configuration.getClassExternalizerFactory();
        this.classExternalizerFactory = classExternalizerFactory == null ? marshallerFactory.getDefaultClassExternalizerFactory() : classExternalizerFactory;
        StreamHeader streamHeader = configuration.getStreamHeader();
        this.streamHeader = streamHeader == null ? marshallerFactory.getDefaultStreamHeader() : streamHeader;
        ClassResolver classResolver = configuration.getClassResolver();
        this.classResolver = classResolver == null ? marshallerFactory.getDefaultClassResolver() : classResolver;
        ObjectResolver objectResolver = configuration.getObjectResolver();
        this.objectResolver = objectResolver == null ? marshallerFactory.getDefaultObjectResolver() : objectResolver;
        ObjectResolver objectPreResolver = configuration.getObjectPreResolver();
        this.objectPreResolver = objectPreResolver == null ? marshallerFactory.getDefaultObjectResolver() : objectPreResolver;
        ClassTable classTable = configuration.getClassTable();
        this.classTable = classTable == null ? marshallerFactory.getDefaultClassTable() : classTable;
        ObjectTable objectTable = configuration.getObjectTable();
        this.objectTable = objectTable == null ? marshallerFactory.getDefaultObjectTable() : objectTable;
        ExceptionListener exceptionListener = configuration.getExceptionListener();
        this.exceptionListener = exceptionListener == null ? ExceptionListener.NO_OP : exceptionListener;
        SerializabilityChecker serializabilityChecker = configuration.getSerializabilityChecker();
        this.serializabilityChecker = serializabilityChecker == null ? SerializabilityChecker.DEFAULT : serializabilityChecker;
        int configuredVersion = configuration.getVersion();
        this.configuredVersion = configuredVersion == -1 ? marshallerFactory.getDefaultVersion() : configuredVersion;
    }

    @Override
    public void start(ByteInput byteInput) throws IOException {
        this.byteInput = byteInput;
        this.limit = 0;
        this.position = 0;
        this.streamHeader.readHeader(this);
    }

    @Override
    public void finish() throws IOException {
        this.limit = -1;
        this.position = 0;
        this.byteInput = null;
        this.clearClassCache();
    }
}

