/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import java.util.concurrent.TimeUnit;
import org.redisson.RedissonSetCache;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.set.SetOperation;

public class AddCacheOperation
extends SetOperation {
    private Object value;
    private long ttl;
    private TimeUnit timeUnit;

    public AddCacheOperation(RObject set, Object value, String transactionId, long threadId) {
        this(set, value, 0L, null, transactionId, threadId);
    }

    public AddCacheOperation(RObject set, Object value, long ttl, TimeUnit timeUnit, String transactionId, long threadId) {
        this(set.getName(), set.getCodec(), value, ttl, timeUnit, transactionId, threadId);
    }

    public AddCacheOperation(String name, Codec codec, Object value, long ttl, TimeUnit timeUnit, String transactionId, long threadId) {
        super(name, codec, transactionId, threadId);
        this.value = value;
        this.timeUnit = timeUnit;
        this.ttl = ttl;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache<Object> set = new RedissonSetCache<Object>(this.codec, null, commandExecutor, this.name, null);
        if (this.timeUnit != null) {
            set.addAsync(this.value, this.ttl, this.timeUnit);
        } else {
            set.addAsync(this.value);
        }
        this.getLock(set, commandExecutor, this.value).unlockAsync(this.threadId);
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache set = new RedissonSetCache(this.codec, null, commandExecutor, this.name, null);
        this.getLock(set, commandExecutor, this.value).unlockAsync(this.threadId);
    }

    public Object getValue() {
        return this.value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getTTL() {
        return this.ttl;
    }
}

