/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.BatchOptions;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.BaseRedisBatchExecutor;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.LogHelper;

public class RedisQueuedBatchExecutor<V, R>
extends BaseRedisBatchExecutor<V, R> {
    private final ConcurrentMap<MasterSlaveEntry, CommandBatchService.ConnectionEntry> connections;
    private final Map<MasterSlaveEntry, CommandBatchService.Entry> aggregatedCommands;

    public RedisQueuedBatchExecutor(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, CompletableFuture<R> mainPromise, boolean ignoreRedirect, ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, ConcurrentMap<NodeSource, CommandBatchService.Entry> commands, ConcurrentMap<MasterSlaveEntry, CommandBatchService.ConnectionEntry> connections, BatchOptions options, AtomicInteger index, AtomicBoolean executed, RedissonObjectBuilder.ReferenceType referenceType, boolean noRetry, Map<MasterSlaveEntry, CommandBatchService.Entry> aggregatedCommands) {
        super(readOnlyMode, source, codec, command, params, mainPromise, ignoreRedirect, connectionManager, objectBuilder, commands, options, index, executed, referenceType, noRetry);
        this.aggregatedCommands = aggregatedCommands;
        this.connections = connections;
    }

    @Override
    public void execute() {
        if (this.source.getEntry() != null) {
            CommandBatchService.Entry entry = this.aggregatedCommands.computeIfAbsent(this.source.getEntry(), k -> new CommandBatchService.Entry());
            if (!this.readOnlyMode) {
                entry.setReadOnlyMode(false);
            }
            Codec codecToUse = this.getCodec(this.codec);
            BatchCommandData commandData = new BatchCommandData(this.mainPromise, codecToUse, this.command, null, this.index.incrementAndGet());
            entry.getCommands().add(commandData);
        } else {
            this.addBatchCommandData(null);
        }
        if (!this.readOnlyMode && this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC) {
            throw new IllegalStateException("Data modification commands can't be used with queueStore=REDIS_READ_ATOMIC");
        }
        super.execute();
    }

    @Override
    protected void releaseConnection(CompletableFuture<R> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) {
        if (RedisCommands.EXEC.getName().equals(this.command.getName()) || RedisCommands.DISCARD.getName().equals(this.command.getName())) {
            super.releaseConnection(attemptPromise, connectionFuture);
        } else {
            this.connectionManager.getServiceManager().getShutdownLatch().release();
        }
    }

    @Override
    protected void handleSuccess(CompletableFuture<R> promise, CompletableFuture<RedisConnection> connectionFuture, R res) throws ReflectiveOperationException {
        if (RedisCommands.EXEC.getName().equals(this.command.getName())) {
            super.handleSuccess(promise, connectionFuture, res);
            return;
        }
        if (RedisCommands.DISCARD.getName().equals(this.command.getName())) {
            super.handleSuccess(promise, connectionFuture, null);
            return;
        }
        BatchPromise batchPromise = (BatchPromise)promise;
        CompletableFuture<Void> sentPromise = batchPromise.getSentPromise();
        super.handleSuccess(sentPromise, connectionFuture, null);
    }

    @Override
    protected void handleError(CompletableFuture<RedisConnection> connectionFuture, Throwable cause) {
        if (this.mainPromise instanceof BatchPromise) {
            BatchPromise batchPromise = (BatchPromise)this.mainPromise;
            CompletableFuture<Void> sentPromise = batchPromise.getSentPromise();
            sentPromise.completeExceptionally(cause);
            this.mainPromise.completeExceptionally(cause);
            if (this.executed.compareAndSet(false, true)) {
                this.getNow(connectionFuture).forceFastReconnectAsync().whenComplete((res, e) -> RedisQueuedBatchExecutor.super.releaseConnection(this.mainPromise, connectionFuture));
            }
            return;
        }
        super.handleError(connectionFuture, cause);
    }

    @Override
    protected void sendCommand(CompletableFuture<R> attemptPromise, RedisConnection connection) {
        boolean syncSlaves;
        MasterSlaveEntry msEntry = this.getEntry();
        CommandBatchService.ConnectionEntry connectionEntry = (CommandBatchService.ConnectionEntry)this.connections.get(msEntry);
        boolean bl = syncSlaves = this.options.getSyncSlaves() > 0;
        if (this.source.getRedirect() == NodeSource.Redirect.ASK) {
            ArrayList list = new ArrayList(2);
            CompletableFuture promise = new CompletableFuture();
            list.add(new CommandData(promise, this.codec, RedisCommands.ASKING, new Object[0]));
            if (connectionEntry.isFirstCommand()) {
                list.add(new CommandData(promise, this.codec, RedisCommands.MULTI, new Object[0]));
                connectionEntry.setFirstCommand(false);
            }
            list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
            CompletableFuture<Void> main = new CompletableFuture<Void>();
            this.writeFuture = connection.send(new CommandsData(main, list, true, syncSlaves));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("acquired connection for command {} and params {} from slot {} using node {}... {}", this.command, LogHelper.toString(this.params), this.source, connection.getRedisClient().getAddr(), connection);
            }
            if (connectionEntry.isFirstCommand()) {
                ArrayList list = new ArrayList(2);
                list.add(new CommandData(new CompletableFuture(), this.codec, RedisCommands.MULTI, new Object[0]));
                list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
                CompletableFuture<Void> main = new CompletableFuture<Void>();
                this.writeFuture = connection.send(new CommandsData(main, list, true, syncSlaves));
                connectionEntry.setFirstCommand(false);
            } else if (RedisCommands.EXEC.getName().equals(this.command.getName())) {
                CommandBatchService.Entry entry = this.aggregatedCommands.get(msEntry);
                ArrayList list = new ArrayList();
                if (this.options.isSkipResult()) {
                    list.add(new CommandData(new CompletableFuture(), this.codec, RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}));
                }
                list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
                if (this.options.isSkipResult()) {
                    list.add(new CommandData(new CompletableFuture(), this.codec, RedisCommands.CLIENT_REPLY, new Object[]{"ON"}));
                }
                if (this.options.getSyncSlaves() > 0) {
                    BatchCommandData waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                    list.add(waitCommand);
                    entry.getCommands().add(waitCommand);
                }
                CompletableFuture<Void> main = new CompletableFuture<Void>();
                this.writeFuture = connection.send(new CommandsData(main, list, new ArrayList(entry.getCommands()), this.options.isSkipResult(), false, true, syncSlaves));
            } else {
                CompletableFuture<Void> main = new CompletableFuture<Void>();
                ArrayList list = new ArrayList();
                list.add(new CommandData(attemptPromise, this.codec, this.command, this.params));
                this.writeFuture = connection.send(new CommandsData(main, list, true, syncSlaves));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<RedisConnection> getConnection() {
        MasterSlaveEntry msEntry = this.getEntry();
        CommandBatchService.ConnectionEntry entry = this.connections.computeIfAbsent(msEntry, k -> new CommandBatchService.ConnectionEntry());
        if (entry.getConnectionFuture() != null) {
            this.connectionFuture = entry.getConnectionFuture();
            return this.connectionFuture;
        }
        RedisQueuedBatchExecutor redisQueuedBatchExecutor = this;
        synchronized (redisQueuedBatchExecutor) {
            if (entry.getConnectionFuture() != null) {
                this.connectionFuture = entry.getConnectionFuture();
                return this.connectionFuture;
            }
            this.connectionFuture = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC ? this.connectionWriteOp(null) : this.connectionReadOp(null);
            this.connectionFuture.toCompletableFuture().join();
            entry.setConnectionFuture(this.connectionFuture);
            entry.setCancelCallback(() -> this.handleError(this.connectionFuture, new CancellationException()));
            return this.connectionFuture;
        }
    }
}

