/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.RedisBatchExecutor;
import org.redisson.command.RedisCommonBatchExecutor;
import org.redisson.command.RedisExecutor;
import org.redisson.command.RedisQueuedBatchExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.CompletableFutureWrapper;

public class CommandBatchService
extends CommandAsyncService {
    private final AtomicInteger index = new AtomicInteger();
    private final ConcurrentMap<NodeSource, Entry> commands = new ConcurrentHashMap<NodeSource, Entry>();
    private Map<MasterSlaveEntry, Entry> aggregatedCommands = Collections.emptyMap();
    private final ConcurrentMap<MasterSlaveEntry, ConnectionEntry> connections = new ConcurrentHashMap<MasterSlaveEntry, ConnectionEntry>();
    private final BatchOptions options;
    private final Map<RFuture<?>, List<CommandBatchService>> nestedServices = new ConcurrentHashMap();
    private final AtomicBoolean executed = new AtomicBoolean();

    public CommandBatchService(CommandAsyncExecutor executor) {
        this(executor, RedissonObjectBuilder.ReferenceType.DEFAULT);
    }

    public CommandBatchService(CommandAsyncExecutor executor, RedissonObjectBuilder.ReferenceType referenceType) {
        this(executor.getConnectionManager(), BatchOptions.defaults(), executor.getObjectBuilder(), referenceType);
    }

    public CommandBatchService(CommandAsyncExecutor executor, BatchOptions options) {
        this(executor.getConnectionManager(), options, executor.getObjectBuilder(), RedissonObjectBuilder.ReferenceType.DEFAULT);
    }

    public CommandBatchService(CommandAsyncExecutor executor, BatchOptions options, RedissonObjectBuilder.ReferenceType referenceType) {
        this(executor.getConnectionManager(), options, executor.getObjectBuilder(), referenceType);
    }

    private CommandBatchService(ConnectionManager connectionManager, BatchOptions options, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType) {
        super(connectionManager, objectBuilder, referenceType);
        this.options = options;
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    public void add(RFuture<?> future, List<CommandBatchService> services) {
        this.nestedServices.put(future, services);
    }

    @Override
    public <V, R> RFuture<R> async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, boolean ignoreRedirect, boolean noRetry) {
        CompletableFuture<R> mainPromise = this.createPromise();
        if (this.isRedisBasedQueue()) {
            boolean isReadOnly = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC;
            RedisQueuedBatchExecutor<V, R> executor = new RedisQueuedBatchExecutor<V, R>(isReadOnly, nodeSource, codec, command, params, mainPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.connections, this.options, this.index, this.executed, this.referenceType, noRetry, this.aggregatedCommands);
            ((RedisExecutor)executor).execute();
        } else {
            RedisBatchExecutor<V, R> executor = new RedisBatchExecutor<V, R>(readOnlyMode, nodeSource, codec, command, params, mainPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.options, this.index, this.executed, this.referenceType, noRetry);
            ((RedisExecutor)executor).execute();
        }
        return new CompletableFutureWrapper<R>(mainPromise);
    }

    @Override
    public <R> CompletableFuture<R> createPromise() {
        if (this.isRedisBasedQueue()) {
            return new BatchPromise();
        }
        return new CompletableFuture();
    }

    public void discard() {
        this.get(this.discardAsync());
    }

    public RFuture<Void> discardAsync() {
        if (this.executed.get()) {
            throw new IllegalStateException("Batch already executed!");
        }
        this.executed.set(true);
        if (this.isRedisBasedQueue()) {
            return this.writeAllVoidAsync(RedisCommands.DISCARD, new Object[0]);
        }
        this.commands.values().stream().flatMap(e -> e.getCommands().stream()).flatMap(c -> Arrays.stream(c.getParams())).forEach(obj -> ReferenceCountUtil.safeRelease(obj));
        return new CompletableFutureWrapper<Void>((Void)null);
    }

    public BatchResult<?> execute() {
        RFuture<BatchResult<?>> f = this.executeAsync();
        return this.get(f);
    }

    public RFuture<Void> executeAsyncVoid() {
        CompletableFuture resFuture = this.executeAsync().toCompletableFuture();
        CompletionStage s = resFuture.thenApply(res -> null);
        return new CompletableFutureWrapper<Void>((CompletableFuture<Void>)s);
    }

    public boolean isExecuted() {
        return this.executed.get();
    }

    public RFuture<BatchResult<?>> executeAsync() {
        if (this.executed.get()) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            this.executed.set(true);
            BatchResult result = new BatchResult(Collections.emptyList(), 0);
            return new CompletableFutureWrapper(result);
        }
        if (this.isRedisBasedQueue()) {
            return this.executeRedisBasedQueue();
        }
        CompletableFuture promise = new CompletableFuture();
        CompletableFuture<Void> voidPromise = new CompletableFuture<Void>();
        if (this.options.isSkipResult() && this.options.getSyncSlaves() == 0) {
            voidPromise.whenComplete((res, ex) -> {
                this.executed.set(true);
                if (ex != null) {
                    for (Entry e : this.commands.values()) {
                        e.getCommands().forEach(t -> t.tryFailure((Throwable)ex));
                    }
                    promise.completeExceptionally((Throwable)ex);
                    this.aggregatedCommands.clear();
                    this.commands.clear();
                    this.nestedServices.clear();
                    return;
                }
                this.aggregatedCommands.clear();
                this.commands.clear();
                this.nestedServices.clear();
                promise.complete(new BatchResult(Collections.emptyList(), 0));
            });
        } else {
            voidPromise.whenComplete((res, ex) -> {
                this.executed.set(true);
                if (ex != null) {
                    for (Entry e : this.commands.values()) {
                        e.getCommands().forEach(t -> t.tryFailure((Throwable)ex));
                    }
                    promise.completeExceptionally((Throwable)ex);
                    this.aggregatedCommands.clear();
                    this.commands.clear();
                    this.nestedServices.clear();
                    return;
                }
                ArrayList entries = new ArrayList();
                for (Entry e : this.aggregatedCommands.values()) {
                    entries.addAll(e.getCommands());
                }
                Collections.sort(entries);
                ArrayList<Object> responses = new ArrayList<Object>(entries.size());
                int syncedSlaves = 0;
                for (BatchCommandData batchCommandData : entries) {
                    if (this.isWaitCommand(batchCommandData)) {
                        syncedSlaves = batchCommandData.getPromise().getNow(null);
                        continue;
                    }
                    if (batchCommandData.getCommand().getName().equals(RedisCommands.MULTI.getName()) || batchCommandData.getCommand().getName().equals(RedisCommands.EXEC.getName()) || this.options.isSkipResult() || batchCommandData.getPromise().isCancelled()) continue;
                    Object entryResult = batchCommandData.getPromise().getNow(null);
                    try {
                        if (this.objectBuilder != null) {
                            entryResult = this.objectBuilder.tryHandleReference(entryResult, this.referenceType);
                        }
                    }
                    catch (ReflectiveOperationException exc) {
                        log.error("Unable to handle reference from {}", entryResult, (Object)exc);
                    }
                    responses.add(entryResult);
                }
                BatchResult result = new BatchResult(responses, syncedSlaves);
                promise.complete(result);
                this.aggregatedCommands.clear();
                this.commands.clear();
                this.nestedServices.clear();
            });
        }
        this.execute(voidPromise);
        return new CompletableFutureWrapper(promise);
    }

    private void execute(CompletableFuture<Void> voidPromise) {
        AtomicInteger attempt = new AtomicInteger();
        CompletableFuture<Map<MasterSlaveEntry, Entry>> future = new CompletableFuture<Map<MasterSlaveEntry, Entry>>();
        this.resolveCommands(attempt, future);
        future.whenComplete((r, ex) -> {
            if (ex != null) {
                voidPromise.completeExceptionally((Throwable)ex);
                return;
            }
            AtomicInteger slots = new AtomicInteger(r.size());
            for (Map.Entry<RFuture<?>, List<CommandBatchService>> entry : this.nestedServices.entrySet()) {
                slots.incrementAndGet();
                for (CommandBatchService service : entry.getValue()) {
                    service.executeAsync();
                }
                entry.getKey().whenComplete((res, e) -> this.handle(voidPromise, slots, (RFuture)entry.getKey()));
            }
            for (Map.Entry<RFuture<Object>, List<CommandBatchService>> entry : r.entrySet()) {
                if (this.options.getExecutionMode() != BatchOptions.ExecutionMode.IN_MEMORY) {
                    for (Entry entry2 : r.values()) {
                        BatchCommandData multiCommand = new BatchCommandData(RedisCommands.MULTI, new Object[0], this.index.incrementAndGet());
                        entry2.getCommands().addFirst(multiCommand);
                        BatchCommandData execCommand = new BatchCommandData(RedisCommands.EXEC, new Object[0], this.index.incrementAndGet());
                        entry2.getCommands().add(execCommand);
                    }
                }
                if (this.options.isSkipResult()) {
                    for (Entry entry2 : r.values()) {
                        BatchCommandData offCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}, this.index.incrementAndGet());
                        entry2.getCommands().addFirst(offCommand);
                        BatchCommandData onCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"ON"}, this.index.incrementAndGet());
                        entry2.getCommands().add(onCommand);
                    }
                }
                if (this.options.getSyncSlaves() > 0) {
                    for (Entry entry2 : r.values()) {
                        BatchCommandData waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                        entry2.getCommands().add(waitCommand);
                    }
                }
                BatchOptions options = BatchOptions.defaults().executionMode(this.options.getExecutionMode()).syncSlaves(this.options.getSyncSlaves(), this.options.getSyncTimeout(), TimeUnit.MILLISECONDS).responseTimeout(this.options.getResponseTimeout(), TimeUnit.MILLISECONDS).retryAttempts(Math.max(0, this.options.getRetryAttempts() - attempt.get())).retryInterval(this.options.getRetryInterval(), TimeUnit.MILLISECONDS);
                if (this.options.isSkipResult()) {
                    options.skipResult();
                }
                RedisCommonBatchExecutor executor = new RedisCommonBatchExecutor(new NodeSource((MasterSlaveEntry)((Object)entry.getKey())), voidPromise, this.connectionManager, options, (Entry)((Object)entry.getValue()), slots, this.referenceType, false);
                executor.execute();
            }
        });
    }

    private void resolveCommands(AtomicInteger attempt, CompletableFuture<Map<MasterSlaveEntry, Entry>> future) {
        long retryAttempts;
        long retryInterval = this.options.getRetryInterval();
        if (retryInterval == 0L) {
            retryInterval = this.connectionManager.getServiceManager().getConfig().getRetryInterval();
        }
        if ((retryAttempts = this.options.getRetryInterval()) == 0L) {
            retryAttempts = this.connectionManager.getServiceManager().getConfig().getRetryAttempts();
        }
        HashMap<MasterSlaveEntry, Entry> result = new HashMap<MasterSlaveEntry, Entry>();
        for (Map.Entry e : this.commands.entrySet()) {
            MasterSlaveEntry entry = this.getEntry((NodeSource)e.getKey());
            if (entry == null) {
                if ((long)attempt.incrementAndGet() == retryAttempts + 1L) {
                    future.completeExceptionally(this.connectionManager.getServiceManager().createNodeNotFoundException((NodeSource)e.getKey()));
                    return;
                }
                this.connectionManager.getServiceManager().newTimeout(task -> this.resolveCommands(attempt, future), retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            Entry ee = result.computeIfAbsent(entry, k -> new Entry());
            if (!((Entry)e.getValue()).isReadOnlyMode()) {
                ee.setReadOnlyMode(false);
            }
            ee.getCommands().addAll(((Entry)e.getValue()).getCommands());
        }
        for (Entry entry : result.values()) {
            ArrayList list = new ArrayList(entry.getCommands());
            Collections.sort(list);
            entry.getCommands().clear();
            entry.getCommands().addAll(list);
        }
        this.aggregatedCommands = result;
        future.complete(result);
    }

    private MasterSlaveEntry getEntry(NodeSource source) {
        if (source.getSlot() != null) {
            return this.connectionManager.getWriteEntry(source.getSlot());
        }
        return source.getEntry();
    }

    protected Throwable cause(CompletableFuture<?> future) {
        try {
            future.getNow(null);
            return null;
        }
        catch (CompletionException ex2) {
            return ex2.getCause();
        }
        catch (CancellationException ex1) {
            return ex1;
        }
    }

    private <R> RFuture<R> executeRedisBasedQueue() {
        final CompletableFuture resultPromise = new CompletableFuture();
        final long responseTimeout = this.options.getResponseTimeout() > 0L ? this.options.getResponseTimeout() : (long)this.connectionManager.getServiceManager().getConfig().getTimeout();
        Timeout timeout = this.connectionManager.getServiceManager().newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                CommandBatchService.this.connections.values().forEach(c -> c.getCancelCallback().run());
                resultPromise.completeExceptionally(new RedisTimeoutException("Response timeout for queued commands " + responseTimeout + ": " + CommandBatchService.this.commands.values().stream().flatMap(e -> e.getCommands().stream().map(d -> d.getCommand())).collect(Collectors.toList())));
            }
        }, responseTimeout, TimeUnit.MILLISECONDS);
        CompletableFuture<Void> allFutures = CompletableFuture.allOf((CompletableFuture[])this.commands.values().stream().flatMap(m -> m.getCommands().stream().map(c -> ((BatchPromise)c.getPromise()).getSentPromise())).toArray(CompletableFuture[]::new));
        allFutures.whenComplete((fr, exc) -> {
            if (!timeout.cancel()) {
                return;
            }
            block0: for (Entry entry : this.commands.values()) {
                for (BatchCommandData<?, ?> command : entry.getCommands()) {
                    if (!command.getPromise().isDone() || !command.getPromise().isCompletedExceptionally()) continue;
                    resultPromise.completeExceptionally(this.cause(command.getPromise()));
                    continue block0;
                }
            }
            if (resultPromise.isDone()) {
                return;
            }
            ConcurrentHashMap result = new ConcurrentHashMap();
            AtomicInteger attempt = new AtomicInteger();
            CompletableFuture<Map<MasterSlaveEntry, Entry>> resolvedEntriesFuture = new CompletableFuture<Map<MasterSlaveEntry, Entry>>();
            this.resolveCommands(attempt, resolvedEntriesFuture);
            resolvedEntriesFuture.whenComplete((map, ee) -> {
                if (ee != null) {
                    resultPromise.completeExceptionally((Throwable)ee);
                    return;
                }
                ArrayList futures = new ArrayList(map.size());
                for (Map.Entry<MasterSlaveEntry, Entry> entry : this.aggregatedCommands.entrySet()) {
                    boolean isReadOnly = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC;
                    CompletableFuture execPromise = this.createPromise();
                    RedisQueuedBatchExecutor executor = new RedisQueuedBatchExecutor(isReadOnly, new NodeSource(entry.getKey()), this.codec, RedisCommands.EXEC, new Object[0], execPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.connections, this.options, this.index, this.executed, this.referenceType, false, this.aggregatedCommands);
                    ((RedisExecutor)executor).execute();
                    CompletionStage f = execPromise.thenCompose(r -> {
                        BatchCommandData<?, ?> lastCommand = ((Entry)entry.getValue()).getCommands().peekLast();
                        result.put((MasterSlaveEntry)entry.getKey(), r);
                        if (RedisCommands.WAIT.getName().equals(lastCommand.getCommand().getName())) {
                            return lastCommand.getPromise().thenApply(i -> null);
                        }
                        return CompletableFuture.completedFuture(null);
                    });
                    futures.add(f.toCompletableFuture());
                }
                CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                future.whenComplete((res, ex) -> {
                    this.executed.set(true);
                    if (ex != null) {
                        resultPromise.completeExceptionally((Throwable)ex);
                        return;
                    }
                    try {
                        for (Map.Entry entry : result.entrySet()) {
                            Entry commandEntry = this.aggregatedCommands.get(entry.getKey());
                            Iterator resultIter = ((List)entry.getValue()).iterator();
                            for (BatchCommandData<?, ?> data : commandEntry.getCommands()) {
                                if (data.getCommand().getName().equals(RedisCommands.EXEC.getName())) break;
                                CompletableFuture promise = data.getPromise();
                                if (resultIter.hasNext()) {
                                    promise.complete(resultIter.next());
                                    continue;
                                }
                                promise.complete(null);
                            }
                        }
                        ArrayList entries = new ArrayList();
                        for (Entry e : this.aggregatedCommands.values()) {
                            entries.addAll(e.getCommands());
                        }
                        Collections.sort(entries);
                        ArrayList<Object> arrayList = new ArrayList<Object>(entries.size());
                        int syncedSlaves = 0;
                        for (BatchCommandData batchCommandData : entries) {
                            if (this.isWaitCommand(batchCommandData)) {
                                syncedSlaves += ((Integer)batchCommandData.getPromise().getNow(null)).intValue();
                                continue;
                            }
                            if (batchCommandData.getCommand().getName().equals(RedisCommands.MULTI.getName()) || batchCommandData.getCommand().getName().equals(RedisCommands.EXEC.getName())) continue;
                            Object entryResult = batchCommandData.getPromise().getNow(null);
                            if (this.objectBuilder != null) {
                                entryResult = this.objectBuilder.tryHandleReference(entryResult, this.referenceType);
                            }
                            arrayList.add(entryResult);
                        }
                        BatchResult r = new BatchResult(arrayList, syncedSlaves);
                        resultPromise.complete(r);
                    }
                    catch (Exception e) {
                        resultPromise.completeExceptionally(e);
                    }
                });
            });
        });
        return new CompletableFutureWrapper(resultPromise);
    }

    protected boolean isRedisBasedQueue() {
        return this.options != null && (this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC || this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC);
    }

    protected boolean isWaitCommand(CommandData<?, ?> c) {
        return c.getCommand().getName().equals(RedisCommands.WAIT.getName());
    }

    protected void handle(CompletableFuture<Void> mainPromise, AtomicInteger slots, RFuture<?> future) {
        Throwable c = this.cause(future.toCompletableFuture());
        if (c == null) {
            if (slots.decrementAndGet() == 0) {
                mainPromise.complete(null);
            }
        } else {
            mainPromise.completeExceptionally(c);
        }
    }

    @Override
    protected boolean isEvalCacheActive() {
        return false;
    }

    public static class Entry {
        Deque<BatchCommandData<?, ?>> commands = new LinkedBlockingDeque();
        volatile boolean readOnlyMode = true;

        public Deque<BatchCommandData<?, ?>> getCommands() {
            return this.commands;
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }

        public void clearErrors() {
            for (BatchCommandData<?, ?> commandEntry : this.commands) {
                commandEntry.clearError();
            }
        }
    }

    public static class ConnectionEntry {
        boolean firstCommand = true;
        CompletableFuture<RedisConnection> connectionFuture;
        Runnable cancelCallback;

        public CompletableFuture<RedisConnection> getConnectionFuture() {
            return this.connectionFuture;
        }

        public void setConnectionFuture(CompletableFuture<RedisConnection> connectionFuture) {
            this.connectionFuture = connectionFuture;
        }

        public boolean isFirstCommand() {
            return this.firstCommand;
        }

        public void setFirstCommand(boolean firstCommand) {
            this.firstCommand = firstCommand;
        }

        public Runnable getCancelCallback() {
            return this.cancelCallback;
        }

        public void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }
    }
}

