/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.redisson.RedissonReference;
import org.redisson.SlotCallback;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.command.RedisExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.connection.ServiceManager;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.CompletableFutureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAsyncService
implements CommandAsyncExecutor {
    static final Logger log = LoggerFactory.getLogger(CommandAsyncService.class);
    final Codec codec;
    final ConnectionManager connectionManager;
    final RedissonObjectBuilder objectBuilder;
    final RedissonObjectBuilder.ReferenceType referenceType;
    private static final Map<String, String> SHA_CACHE = new LRUCacheMap<String, String>(500, 0L, 0L);
    private final AtomicBoolean evalShaROSupported = new AtomicBoolean(true);
    private final AtomicBoolean sortRoSupported = new AtomicBoolean(true);

    public CommandAsyncService(ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType) {
        this.connectionManager = connectionManager;
        this.objectBuilder = objectBuilder;
        this.referenceType = referenceType;
        this.codec = connectionManager.getServiceManager().getCfg().getCodec();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    private boolean isRedissonReferenceSupportEnabled() {
        return this.objectBuilder != null;
    }

    @Override
    public <V> V getNow(CompletableFuture<V> future) {
        try {
            return future.getNow(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <V> void transfer(CompletableFuture<V> future1, CompletableFuture<V> future2) {
        future1.whenComplete((res, e) -> {
            if (e != null) {
                future2.completeExceptionally((Throwable)e);
                return;
            }
            future2.complete(res);
        });
    }

    @Override
    public <V> V get(RFuture<V> future) {
        if (Thread.currentThread().getName().startsWith("redisson-netty")) {
            throw new IllegalStateException("Sync methods can't be invoked from async/rx/reactive listeners");
        }
        try {
            return (V)future.toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            Thread.currentThread().interrupt();
            throw new RedisException(e);
        }
        catch (ExecutionException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <V> V get(CompletableFuture<V> future) {
        if (Thread.currentThread().getName().startsWith("redisson-netty")) {
            throw new IllegalStateException("Sync methods can't be invoked from async/rx/reactive listeners");
        }
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            Thread.currentThread().interrupt();
            throw new RedisException(e);
        }
        catch (ExecutionException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <V> V getInterrupted(RFuture<V> future) throws InterruptedException {
        try {
            return (V)future.toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            future.toCompletableFuture().completeExceptionally(e);
            throw e;
        }
        catch (ExecutionException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public <V> V getInterrupted(CompletableFuture<V> future) throws InterruptedException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.completeExceptionally(e);
            throw e;
        }
        catch (ExecutionException e) {
            throw this.convertException(e);
        }
    }

    protected <R> CompletableFuture<R> createPromise() {
        return new CompletableFuture();
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        return this.async(true, new NodeSource(entry, client), codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, String name, Codec codec, RedisCommand<T> command, Object ... params) {
        int slot = this.connectionManager.calcSlot(name);
        return this.async(true, new NodeSource(slot, client), codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, byte[] key, Codec codec, RedisCommand<T> command, Object ... params) {
        int slot = this.connectionManager.calcSlot(key);
        return this.async(true, new NodeSource(slot, client), codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, Codec codec, RedisCommand<T> command, Object ... params) {
        return this.async(true, new NodeSource(client), codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> readRandomAsync(Codec codec, RedisCommand<T> command, Object ... params) {
        CompletableFuture<R> mainPromise = this.createPromise();
        ArrayList<MasterSlaveEntry> nodes = new ArrayList<MasterSlaveEntry>(this.connectionManager.getEntrySet());
        Collections.shuffle(nodes);
        this.retryReadRandomAsync(codec, command, mainPromise, nodes, params);
        return new CompletableFutureWrapper<R>(mainPromise);
    }

    @Override
    public <T, R> RFuture<R> readRandomAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        CompletableFuture<R> mainPromise = this.createPromise();
        this.retryReadRandomAsync(codec, command, mainPromise, Collections.singletonList(entry), params);
        return new CompletableFutureWrapper<R>(mainPromise);
    }

    private <R, T> void retryReadRandomAsync(Codec codec, RedisCommand<T> command, CompletableFuture<R> mainPromise, List<MasterSlaveEntry> nodes, Object ... params) {
        MasterSlaveEntry entry = nodes.remove(0);
        RFuture<R> attemptPromise = this.async(true, new NodeSource(entry), codec, command, params, false, false);
        attemptPromise.whenComplete((res, e) -> {
            if (e == null) {
                if (res == null) {
                    if (nodes.isEmpty()) {
                        mainPromise.complete(null);
                    } else {
                        this.retryReadRandomAsync(codec, command, mainPromise, nodes, params);
                    }
                } else {
                    mainPromise.complete(res);
                }
            } else {
                mainPromise.completeExceptionally((Throwable)e);
            }
        });
    }

    @Override
    public <T> RFuture<Void> writeAllVoidAsync(RedisCommand<T> command, Object ... params) {
        List futures = this.writeAllAsync(command, StringCodec.INSTANCE, params);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public <R> List<CompletableFuture<R>> writeAllAsync(RedisCommand<?> command, Object ... params) {
        return this.writeAllAsync(command, this.codec, params);
    }

    private <R> List<CompletableFuture<R>> writeAllAsync(RedisCommand<?> command, Codec codec, Object ... params) {
        List<CompletableFuture<R>> futures = this.connectionManager.getEntrySet().stream().map(e -> {
            RFuture f = this.async(false, new NodeSource((MasterSlaveEntry)e), codec, command, params, true, false);
            return f.toCompletableFuture();
        }).collect(Collectors.toList());
        return futures;
    }

    @Override
    public <R> List<CompletableFuture<R>> readAllAsync(Codec codec, RedisCommand<?> command, Object ... params) {
        List<CompletableFuture<R>> futures = this.connectionManager.getEntrySet().stream().map(e -> {
            RFuture f = this.async(true, new NodeSource((MasterSlaveEntry)e), codec, command, params, true, false);
            return f.toCompletableFuture();
        }).collect(Collectors.toList());
        return futures;
    }

    @Override
    public <R> List<CompletableFuture<R>> readAllAsync(RedisCommand<?> command, Object ... params) {
        return this.readAllAsync(this.codec, command, params);
    }

    @Override
    public <R> List<CompletableFuture<R>> executeAllAsync(RedisCommand<?> command, Object ... params) {
        Collection<MasterSlaveEntry> nodes = this.connectionManager.getEntrySet();
        ArrayList futures = new ArrayList();
        nodes.forEach(e -> {
            RFuture promise = this.async(false, new NodeSource((MasterSlaveEntry)e), this.codec, command, params, true, false);
            futures.add(promise.toCompletableFuture());
            e.getAllEntries().stream().filter(c -> c.getNodeType() == NodeType.SLAVE && !c.isFreezed()).forEach(c -> {
                RFuture slavePromise = this.async(true, new NodeSource((MasterSlaveEntry)e, c.getClient()), this.codec, command, params, true, false);
                futures.add(slavePromise.toCompletableFuture());
            });
        });
        return futures;
    }

    @Override
    public RedisException convertException(ExecutionException e) {
        if (e.getCause() instanceof RedisException) {
            return (RedisException)e.getCause();
        }
        return new RedisException("Unexpected exception while processing command", e.getCause());
    }

    private NodeSource getNodeSource(String key) {
        int slot = this.connectionManager.calcSlot(key);
        return new NodeSource(slot);
    }

    private NodeSource getNodeSource(byte[] key) {
        int slot = this.connectionManager.calcSlot(key);
        return new NodeSource(slot);
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.async(true, source, codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> readAsync(byte[] key, Codec codec, RedisCommand<T> command, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.async(true, source, codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> readAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        return this.async(true, new NodeSource(entry), codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(RedisClient client, Codec codec, RedisCommand<T> command, Object ... params) {
        MasterSlaveEntry entry = this.getConnectionManager().getEntry(client);
        return this.writeAsync(entry, codec, command, params);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        return this.async(false, new NodeSource(entry), codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.readAsync(key, this.codec, command, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, true, codec, evalCommandType, script, keys, false, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), true, codec, evalCommandType, script, keys, false, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(RedisClient client, String name, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        int slot = this.connectionManager.calcSlot(name);
        return this.evalAsync(new NodeSource(slot, client), true, codec, evalCommandType, script, keys, false, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, false, codec, evalCommandType, script, keys, false, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteNoRetryAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, false, codec, evalCommandType, script, keys, true, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), false, codec, evalCommandType, script, keys, false, params);
    }

    private RFuture<String> loadScript(RedisClient client, String script) {
        MasterSlaveEntry entry = this.getConnectionManager().getEntry(client);
        if (entry.getClient().equals(client)) {
            return this.writeAsync(entry, (Codec)StringCodec.INSTANCE, RedisCommands.SCRIPT_LOAD, script);
        }
        return this.readAsync(client, (Codec)StringCodec.INSTANCE, RedisCommands.SCRIPT_LOAD, script);
    }

    protected boolean isEvalCacheActive() {
        return this.connectionManager.getServiceManager().getCfg().isUseScriptCache();
    }

    private String calcSHA(String script) {
        return SHA_CACHE.computeIfAbsent(script, k -> {
            try {
                MessageDigest mdigest = MessageDigest.getInstance("SHA-1");
                byte[] s = mdigest.digest(script.getBytes());
                return ByteBufUtil.hexDump(s);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private Object[] copy(Object[] params) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : params) {
            if (object instanceof ByteBuf) {
                ByteBuf b = (ByteBuf)object;
                ByteBuf nb = ByteBufAllocator.DEFAULT.buffer(b.readableBytes());
                int ri = b.readerIndex();
                nb.writeBytes(b);
                b.readerIndex(ri);
                result.add(nb);
                continue;
            }
            result.add(object);
        }
        return result.toArray();
    }

    @Override
    public boolean isEvalShaROSupported() {
        return this.evalShaROSupported.get();
    }

    @Override
    public void setEvalShaROSupported(boolean value) {
        this.evalShaROSupported.set(value);
    }

    private <T, R> RFuture<R> evalAsync(NodeSource nodeSource, boolean readOnlyMode, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, boolean noRetry, Object ... params) {
        if (this.isEvalCacheActive() && evalCommandType.getName().equals("EVAL")) {
            CompletableFuture mainPromise = new CompletableFuture();
            Object[] pps = this.copy(params);
            CompletableFuture promise = new CompletableFuture();
            String sha1 = this.calcSHA(script);
            RedisCommand cmd = readOnlyMode && this.evalShaROSupported.get() ? new RedisCommand<T>(evalCommandType, "EVALSHA_RO") : new RedisCommand(evalCommandType, "EVALSHA");
            ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
            args.add(sha1);
            args.add(keys.size());
            args.addAll(keys);
            args.addAll(Arrays.asList(params));
            RedisExecutor executor = new RedisExecutor(readOnlyMode, nodeSource, codec, cmd, args.toArray(), promise, false, this.connectionManager, this.objectBuilder, this.referenceType, noRetry);
            executor.execute();
            promise.whenComplete((res, e) -> {
                if (e != null) {
                    if (e.getMessage().startsWith("ERR unknown command")) {
                        this.evalShaROSupported.set(false);
                        RFuture future = this.evalAsync(nodeSource, readOnlyMode, codec, evalCommandType, script, keys, noRetry, pps);
                        this.transfer(future.toCompletableFuture(), mainPromise);
                    } else if (e.getMessage().startsWith("NOSCRIPT")) {
                        RFuture<String> loadFuture = this.loadScript(executor.getRedisClient(), script);
                        loadFuture.whenComplete((r, ex) -> {
                            if (ex != null) {
                                this.free(pps);
                                mainPromise.completeExceptionally((Throwable)ex);
                                return;
                            }
                            ArrayList<Object> newargs = new ArrayList<Object>(2 + keys.size() + params.length);
                            newargs.add(sha1);
                            newargs.add(keys.size());
                            newargs.addAll(keys);
                            newargs.addAll(Arrays.asList(pps));
                            NodeSource ns = nodeSource;
                            if (ns.getRedisClient() == null) {
                                ns = new NodeSource(nodeSource, executor.getRedisClient());
                            }
                            RFuture future = this.async(readOnlyMode, ns, codec, cmd, newargs.toArray(), false, noRetry);
                            this.transfer(future.toCompletableFuture(), mainPromise);
                        });
                    } else {
                        this.free(pps);
                        mainPromise.completeExceptionally((Throwable)e);
                    }
                    return;
                }
                this.free(pps);
                mainPromise.complete(res);
            });
            return new CompletableFutureWrapper(mainPromise);
        }
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        return this.async(readOnlyMode, nodeSource, codec, evalCommandType, args.toArray(), false, noRetry);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.writeAsync(key, this.codec, command, params);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.async(false, source, codec, command, params, false, false);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(byte[] key, Codec codec, RedisCommand<T> command, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.async(false, source, codec, command, params, false, false);
    }

    @Override
    public <V, R> RFuture<R> async(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, boolean ignoreRedirect, boolean noRetry) {
        if (readOnlyMode && command.getName().equals("SORT") && !this.sortRoSupported.get()) {
            readOnlyMode = false;
        } else if (readOnlyMode && command.getName().equals("SORT") && this.sortRoSupported.get()) {
            RedisCommand<V> cmd = new RedisCommand<V>("SORT_RO", command.getReplayMultiDecoder());
            CompletableFuture mainPromise = this.createPromise();
            RedisExecutor<V, R> executor = new RedisExecutor<V, R>(readOnlyMode, source, codec, cmd, params, mainPromise, ignoreRedirect, this.connectionManager, this.objectBuilder, this.referenceType, noRetry);
            executor.execute();
            CompletableFuture result = new CompletableFuture();
            mainPromise.whenComplete((r, e) -> {
                if (e != null && e.getMessage().startsWith("ERR unknown command")) {
                    this.sortRoSupported.set(false);
                    RFuture future = this.async(false, source, codec, command, params, ignoreRedirect, noRetry);
                    this.transfer(future.toCompletableFuture(), result);
                    return;
                }
                this.transfer(mainPromise, result);
            });
            return new CompletableFutureWrapper(result);
        }
        CompletableFuture<R> mainPromise = this.createPromise();
        RedisExecutor<V, R> executor = new RedisExecutor<V, R>(readOnlyMode, source, codec, command, params, mainPromise, ignoreRedirect, this.connectionManager, this.objectBuilder, this.referenceType, noRetry);
        executor.execute();
        return new CompletableFutureWrapper<R>(mainPromise);
    }

    private void free(Object[] params) {
        for (Object obj : params) {
            ReferenceCountUtil.safeRelease(obj);
        }
    }

    @Override
    public <T, R> RFuture<R> readBatchedAsync(Codec codec, RedisCommand<T> command, SlotCallback<T, R> callback, String ... keys) {
        return this.executeBatchedAsync(true, codec, command, callback, keys);
    }

    @Override
    public <T, R> RFuture<R> writeBatchedAsync(Codec codec, RedisCommand<T> command, SlotCallback<T, R> callback, String ... keys) {
        return this.executeBatchedAsync(false, codec, command, callback, keys);
    }

    private <T, R> RFuture<R> executeBatchedAsync(boolean readOnly, Codec codec, RedisCommand<T> command, SlotCallback<T, R> callback, String[] keys) {
        if (!this.connectionManager.isClusterMode()) {
            Object[] params = callback.createParams(Arrays.asList(keys));
            if (readOnly) {
                return this.readAsync((String)null, codec, command, params);
            }
            return this.writeAsync((String)null, codec, command, params);
        }
        Map entry2keys = Arrays.stream(keys).collect(Collectors.groupingBy(k -> {
            int slot = this.connectionManager.calcSlot((String)k);
            return this.connectionManager.getWriteEntry(slot);
        }, Collectors.groupingBy(k -> this.connectionManager.calcSlot((String)k), Collectors.toList())));
        ArrayList futures = new ArrayList();
        for (Map.Entry entry : entry2keys.entrySet()) {
            CommandBatchService executorService = this instanceof CommandBatchService ? (CommandBatchService)this : new CommandBatchService(this);
            for (List<String> list : entry.getValue().values()) {
                RFuture<R> f;
                RedisCommand<T> c = command;
                RedisCommand<T> newCommand = callback.createCommand(list);
                if (newCommand != null) {
                    c = newCommand;
                }
                if (readOnly) {
                    f = executorService.readAsync(entry.getKey(), codec, c, callback.createParams(list));
                    futures.add(f.toCompletableFuture());
                    continue;
                }
                f = executorService.writeAsync(entry.getKey(), codec, c, callback.createParams(list));
                futures.add(f.toCompletableFuture());
            }
            if (this instanceof CommandBatchService) continue;
            executorService.executeAsync();
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage result = future.thenApply(r -> {
            futures.forEach(f -> {
                if (!f.isCompletedExceptionally() && f.getNow(null) != null) {
                    callback.onSlotResult(f.getNow(null));
                }
            });
            return callback.onFinish();
        });
        return new CompletableFutureWrapper(result);
    }

    @Override
    public RedissonObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.connectionManager.getServiceManager();
    }

    @Override
    public ByteBuf encode(Codec codec, Object value) {
        RedissonReference reference;
        if (this.isRedissonReferenceSupportEnabled() && (reference = this.getObjectBuilder().toReference(value)) != null) {
            value = reference;
        }
        try {
            return codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ByteBuf encodeMapKey(Codec codec, Object value) {
        RedissonReference reference;
        if (this.isRedissonReferenceSupportEnabled() && (reference = this.getObjectBuilder().toReference(value)) != null) {
            value = reference;
        }
        try {
            return codec.getMapKeyEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ByteBuf encodeMapValue(Codec codec, Object value) {
        RedissonReference reference;
        if (this.isRedissonReferenceSupportEnabled() && (reference = this.getObjectBuilder().toReference(value)) != null) {
            value = reference;
        }
        try {
            return codec.getMapValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <V> RFuture<V> pollFromAnyAsync(String name, Codec codec, RedisCommand<?> command, long secondsTimeout, String ... queueNames) {
        List mappedNames = Arrays.stream(queueNames).map(m -> this.connectionManager.getServiceManager().getConfig().getNameMapper().map((String)m)).collect(Collectors.toList());
        if (this.connectionManager.isClusterMode() && queueNames.length > 0) {
            AtomicReference<Iterator<String>> ref = new AtomicReference<Iterator<String>>();
            ArrayList<String> names = new ArrayList<String>();
            names.add(name);
            names.addAll(mappedNames);
            ref.set(names.iterator());
            AtomicLong counter = new AtomicLong(secondsTimeout);
            CompletionStage<V> result = this.poll(codec, ref, names, counter, command);
            return new CompletableFutureWrapper<V>(result);
        }
        ArrayList<Object> params = new ArrayList<Object>(queueNames.length + 1);
        params.add(name);
        params.addAll(mappedNames);
        params.add(secondsTimeout);
        return this.writeAsync(name, codec, command, params.toArray());
    }

    private <V> CompletionStage<V> poll(Codec codec, AtomicReference<Iterator<String>> ref, List<String> names, AtomicLong counter, RedisCommand<?> command) {
        if (ref.get().hasNext()) {
            String currentName = ref.get().next();
            RFuture future = this.writeAsync(currentName, codec, command, currentName, 1);
            return future.thenCompose(res -> {
                if (res != null) {
                    return CompletableFuture.completedFuture(res);
                }
                if (counter.decrementAndGet() == 0L) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.poll(codec, ref, names, counter, command);
            });
        }
        ref.set(names.iterator());
        return this.poll(codec, ref, names, counter, command);
    }
}

