/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.concurrent.TimeUnit;

public final class BatchOptions {
    private ExecutionMode executionMode = ExecutionMode.IN_MEMORY;
    private long responseTimeout;
    private int retryAttempts;
    private long retryInterval;
    private long syncTimeout;
    private int syncSlaves;
    private boolean skipResult;

    private BatchOptions() {
    }

    public static BatchOptions defaults() {
        return new BatchOptions();
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public BatchOptions responseTimeout(long timeout, TimeUnit unit) {
        this.responseTimeout = unit.toMillis(timeout);
        return this;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public BatchOptions retryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
        return this;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public BatchOptions retryInterval(long retryInterval, TimeUnit retryIntervalUnit) {
        this.retryInterval = retryIntervalUnit.toMillis(retryInterval);
        return this;
    }

    public BatchOptions syncSlaves(int slaves, long timeout, TimeUnit unit) {
        this.syncSlaves = slaves;
        this.syncTimeout = unit.toMillis(timeout);
        return this;
    }

    public long getSyncTimeout() {
        return this.syncTimeout;
    }

    public int getSyncSlaves() {
        return this.syncSlaves;
    }

    public BatchOptions skipResult() {
        this.skipResult = true;
        return this;
    }

    public boolean isSkipResult() {
        return this.skipResult;
    }

    public BatchOptions executionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
        return this;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public String toString() {
        return "BatchOptions [queueStore=" + (Object)((Object)this.executionMode) + "]";
    }

    public static enum ExecutionMode {
        REDIS_READ_ATOMIC,
        REDIS_WRITE_ATOMIC,
        IN_MEMORY,
        IN_MEMORY_ATOMIC;

    }
}

